<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZKwfGetRequestsByUser01 StructType
 * @subpackage Structs
 */
class ZKwfGetRequestsByUser01 extends AbstractStructBase
{
    /**
     * The ItRequestList_01
     * @var \StructType\TableOfZkwfRequestL01
     */
    public $ItRequestList_01;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 241
     * @var string
     */
    public $User;
    /**
     * Constructor method for ZKwfGetRequestsByUser01
     * @uses ZKwfGetRequestsByUser01::setItRequestList_01()
     * @uses ZKwfGetRequestsByUser01::setUser()
     * @param \StructType\TableOfZkwfRequestL01 $itRequestList_01
     * @param string $user
     */
    public function __construct(\StructType\TableOfZkwfRequestL01 $itRequestList_01 = null, $user = null)
    {
        $this
            ->setItRequestList_01($itRequestList_01)
            ->setUser($user);
    }
    /**
     * Get itRequestList value
     * @return itRequestList
     */
    public function getItRequestList_01()
    {
        return $this->ItRequestList_01;
    }
    /**
     * Set itRequestList value
     * @param itRequestList $itRequestList
     * @return \StructType\ZKwfGetRequestsByUser01
     */
    public function setItRequestList_01(\StructType\TableOfZkwfRequestL01 $itRequestList_01 = null)
    {
        $this->ItRequestList_01 = $itRequestList_01;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\ZKwfGetRequestsByUser01
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: maxLength(241)
        if (!is_null($user) && mb_strlen($user) > 241) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 241', mb_strlen($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZKwfGetRequestsByUser01
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
