<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZkwfRequestL01 StructType
 * @subpackage Structs
 */
class ZkwfRequestL01 extends AbstractStructBase
{
    /**
     * The Mandt
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * @var string
     */
    public $Mandt;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 7
     * @var string
     */
    public $Id;
    /**
     * The Posid1C
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 24
     * @var string
     */
    public $Posid1C;
    /**
     * The Post1
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 40
     * @var string
     */
    public $Post1;
    /**
     * The Valuetot1C
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * @var string
     */
    public $Valuetot1C;
    /**
     * The Posid2C
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 24
     * @var string
     */
    public $Posid2C;
    /**
     * The Post2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 40
     * @var string
     */
    public $Post2;
    /**
     * The Valuetot2C
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * @var string
     */
    public $Valuetot2C;
    /**
     * The Waers
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * @var string
     */
    public $Waers;
    /**
     * The Typen
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - pattern: \d*
     * @var string
     */
    public $Typen;
    /**
     * The Typedesc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * @var string
     */
    public $Typedesc;
    /**
     * Constructor method for ZkwfRequestL01
     * @uses ZkwfRequestL01::setMandt()
     * @uses ZkwfRequestL01::setId()
     * @uses ZkwfRequestL01::setPosid1C()
     * @uses ZkwfRequestL01::setPost1()
     * @uses ZkwfRequestL01::setValuetot1C()
     * @uses ZkwfRequestL01::setPosid2C()
     * @uses ZkwfRequestL01::setPost2()
     * @uses ZkwfRequestL01::setValuetot2C()
     * @uses ZkwfRequestL01::setWaers()
     * @uses ZkwfRequestL01::setTypen()
     * @uses ZkwfRequestL01::setTypedesc()
     * @param string $mandt
     * @param string $id
     * @param string $posid1C
     * @param string $post1
     * @param string $valuetot1C
     * @param string $posid2C
     * @param string $post2
     * @param string $valuetot2C
     * @param string $waers
     * @param string $typen
     * @param string $typedesc
     */
    public function __construct($mandt = null, $id = null, $posid1C = null, $post1 = null, $valuetot1C = null, $posid2C = null, $post2 = null, $valuetot2C = null, $waers = null, $typen = null, $typedesc = null)
    {
        $this
            ->setMandt($mandt)
            ->setId($id)
            ->setPosid1C($posid1C)
            ->setPost1($post1)
            ->setValuetot1C($valuetot1C)
            ->setPosid2C($posid2C)
            ->setPost2($post2)
            ->setValuetot2C($valuetot2C)
            ->setWaers($waers)
            ->setTypen($typen)
            ->setTypedesc($typedesc);
    }
    /**
     * Get Mandt value
     * @return string|null
     */
    public function getMandt()
    {
        return $this->Mandt;
    }
    /**
     * Set Mandt value
     * @param string $mandt
     * @return \StructType\ZkwfRequestL01
     */
    public function setMandt($mandt = null)
    {
        // validation for constraint: string
        if (!is_null($mandt) && !is_string($mandt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandt, true), gettype($mandt)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($mandt) && mb_strlen($mandt) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($mandt)), __LINE__);
        }
        $this->Mandt = $mandt;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ZkwfRequestL01
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($id) && mb_strlen($id) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Posid1C value
     * @return string|null
     */
    public function getPosid1C()
    {
        return $this->Posid1C;
    }
    /**
     * Set Posid1C value
     * @param string $posid1C
     * @return \StructType\ZkwfRequestL01
     */
    public function setPosid1C($posid1C = null)
    {
        // validation for constraint: string
        if (!is_null($posid1C) && !is_string($posid1C)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posid1C, true), gettype($posid1C)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($posid1C) && mb_strlen($posid1C) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($posid1C)), __LINE__);
        }
        $this->Posid1C = $posid1C;
        return $this;
    }
    /**
     * Get Post1 value
     * @return string|null
     */
    public function getPost1()
    {
        return $this->Post1;
    }
    /**
     * Set Post1 value
     * @param string $post1
     * @return \StructType\ZkwfRequestL01
     */
    public function setPost1($post1 = null)
    {
        // validation for constraint: string
        if (!is_null($post1) && !is_string($post1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($post1, true), gettype($post1)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($post1) && mb_strlen($post1) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($post1)), __LINE__);
        }
        $this->Post1 = $post1;
        return $this;
    }
    /**
     * Get Valuetot1C value
     * @return string|null
     */
    public function getValuetot1C()
    {
        return $this->Valuetot1C;
    }
    /**
     * Set Valuetot1C value
     * @param string $valuetot1C
     * @return \StructType\ZkwfRequestL01
     */
    public function setValuetot1C($valuetot1C = null)
    {
        // validation for constraint: string
        if (!is_null($valuetot1C) && !is_string($valuetot1C)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valuetot1C, true), gettype($valuetot1C)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($valuetot1C) && mb_strlen($valuetot1C) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($valuetot1C)), __LINE__);
        }
        $this->Valuetot1C = $valuetot1C;
        return $this;
    }
    /**
     * Get Posid2C value
     * @return string|null
     */
    public function getPosid2C()
    {
        return $this->Posid2C;
    }
    /**
     * Set Posid2C value
     * @param string $posid2C
     * @return \StructType\ZkwfRequestL01
     */
    public function setPosid2C($posid2C = null)
    {
        // validation for constraint: string
        if (!is_null($posid2C) && !is_string($posid2C)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posid2C, true), gettype($posid2C)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($posid2C) && mb_strlen($posid2C) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($posid2C)), __LINE__);
        }
        $this->Posid2C = $posid2C;
        return $this;
    }
    /**
     * Get Post2 value
     * @return string|null
     */
    public function getPost2()
    {
        return $this->Post2;
    }
    /**
     * Set Post2 value
     * @param string $post2
     * @return \StructType\ZkwfRequestL01
     */
    public function setPost2($post2 = null)
    {
        // validation for constraint: string
        if (!is_null($post2) && !is_string($post2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($post2, true), gettype($post2)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($post2) && mb_strlen($post2) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($post2)), __LINE__);
        }
        $this->Post2 = $post2;
        return $this;
    }
    /**
     * Get Valuetot2C value
     * @return string|null
     */
    public function getValuetot2C()
    {
        return $this->Valuetot2C;
    }
    /**
     * Set Valuetot2C value
     * @param string $valuetot2C
     * @return \StructType\ZkwfRequestL01
     */
    public function setValuetot2C($valuetot2C = null)
    {
        // validation for constraint: string
        if (!is_null($valuetot2C) && !is_string($valuetot2C)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valuetot2C, true), gettype($valuetot2C)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($valuetot2C) && mb_strlen($valuetot2C) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($valuetot2C)), __LINE__);
        }
        $this->Valuetot2C = $valuetot2C;
        return $this;
    }
    /**
     * Get Waers value
     * @return string|null
     */
    public function getWaers()
    {
        return $this->Waers;
    }
    /**
     * Set Waers value
     * @param string $waers
     * @return \StructType\ZkwfRequestL01
     */
    public function setWaers($waers = null)
    {
        // validation for constraint: string
        if (!is_null($waers) && !is_string($waers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waers, true), gettype($waers)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($waers) && mb_strlen($waers) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($waers)), __LINE__);
        }
        $this->Waers = $waers;
        return $this;
    }
    /**
     * Get Typen value
     * @return string|null
     */
    public function getTypen()
    {
        return $this->Typen;
    }
    /**
     * Set Typen value
     * @param string $typen
     * @return \StructType\ZkwfRequestL01
     */
    public function setTypen($typen = null)
    {
        // validation for constraint: string
        if (!is_null($typen) && !is_string($typen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typen, true), gettype($typen)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($typen) && mb_strlen($typen) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($typen)), __LINE__);
        }
        // validation for constraint: pattern(\d*)
        if (!is_null($typen) && !preg_match('/\\d*/', $typen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d*', var_export($typen, true)), __LINE__);
        }
        $this->Typen = $typen;
        return $this;
    }
    /**
     * Get Typedesc value
     * @return string|null
     */
    public function getTypedesc()
    {
        return $this->Typedesc;
    }
    /**
     * Set Typedesc value
     * @param string $typedesc
     * @return \StructType\ZkwfRequestL01
     */
    public function setTypedesc($typedesc = null)
    {
        // validation for constraint: string
        if (!is_null($typedesc) && !is_string($typedesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typedesc, true), gettype($typedesc)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($typedesc) && mb_strlen($typedesc) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($typedesc)), __LINE__);
        }
        $this->Typedesc = $typedesc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZkwfRequestL01
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
