<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ZK ServiceType
 * @subpackage Services
 */
class ZK extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZKwfGetRequestsByUser01
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZKwfGetRequestsByUser01 $parameters
     * @return \StructType\ZKwfGetRequestsByUser01Response|bool
     */
    public function ZKwfGetRequestsByUser01(\StructType\ZKwfGetRequestsByUser01 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZKwfGetRequestsByUser01($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZKwfGetRequestsByUser01Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
