<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZKwfIdStatus StructType
 * @subpackage Structs
 */
class ZKwfIdStatus extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 7
     * @var string
     */
    public $Id;
    /**
     * The Sap
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sap;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * @var string
     */
    public $Status;
    /**
     * The Uname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 40
     * @var string
     */
    public $Uname;
    /**
     * Constructor method for ZKwfIdStatus
     * @uses ZKwfIdStatus::setId()
     * @uses ZKwfIdStatus::setSap()
     * @uses ZKwfIdStatus::setStatus()
     * @uses ZKwfIdStatus::setUname()
     * @param string $id
     * @param string $sap
     * @param string $status
     * @param string $uname
     */
    public function __construct($id = null, $sap = null, $status = null, $uname = null)
    {
        $this
            ->setId($id)
            ->setSap($sap)
            ->setStatus($status)
            ->setUname($uname);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ZKwfIdStatus
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($id) && mb_strlen($id) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Sap value
     * @return string|null
     */
    public function getSap()
    {
        return $this->Sap;
    }
    /**
     * Set Sap value
     * @param string $sap
     * @return \StructType\ZKwfIdStatus
     */
    public function setSap($sap = null)
    {
        // validation for constraint: string
        if (!is_null($sap) && !is_string($sap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sap, true), gettype($sap)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($sap) && mb_strlen($sap) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($sap)), __LINE__);
        }
        $this->Sap = $sap;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\ZKwfIdStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($status) && mb_strlen($status) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Uname value
     * @return string|null
     */
    public function getUname()
    {
        return $this->Uname;
    }
    /**
     * Set Uname value
     * @param string $uname
     * @return \StructType\ZKwfIdStatus
     */
    public function setUname($uname = null)
    {
        // validation for constraint: string
        if (!is_null($uname) && !is_string($uname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uname, true), gettype($uname)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($uname) && mb_strlen($uname) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($uname)), __LINE__);
        }
        $this->Uname = $uname;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZKwfIdStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
