<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructSessionInfo StructType
 * @subpackage Structs
 * @Version 2.0
 */
class StructSessionInfo extends AbstractStructBase
{
    /**
     * The IDSession
     * @var string
     */
    public $IDSession;
    /**
     * The timeLogin
     * @var int
     */
    public $timeLogin;
    /**
     * The timeLastActivity
     * @var int
     */
    public $timeLastActivity;
    /**
     * The lang
     * @var string
     */
    public $lang;
    /**
     * The sync
     * @var int
     */
    public $sync;
    /**
     * Constructor method for StructSessionInfo
     * @uses StructSessionInfo::setIDSession()
     * @uses StructSessionInfo::setTimeLogin()
     * @uses StructSessionInfo::setTimeLastActivity()
     * @uses StructSessionInfo::setLang()
     * @uses StructSessionInfo::setSync()
     * @param string $iDSession
     * @param int $timeLogin
     * @param int $timeLastActivity
     * @param string $lang
     * @param int $sync
     */
    public function __construct($iDSession = null, $timeLogin = null, $timeLastActivity = null, $lang = null, $sync = null)
    {
        $this
            ->setIDSession($iDSession)
            ->setTimeLogin($timeLogin)
            ->setTimeLastActivity($timeLastActivity)
            ->setLang($lang)
            ->setSync($sync);
    }
    /**
     * Get IDSession value
     * @return string|null
     */
    public function getIDSession()
    {
        return $this->IDSession;
    }
    /**
     * Set IDSession value
     * @param string $iDSession
     * @return \StructType\StructSessionInfo
     */
    public function setIDSession($iDSession = null)
    {
        // validation for constraint: string
        if (!is_null($iDSession) && !is_string($iDSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSession, true), gettype($iDSession)), __LINE__);
        }
        $this->IDSession = $iDSession;
        return $this;
    }
    /**
     * Get timeLogin value
     * @return int|null
     */
    public function getTimeLogin()
    {
        return $this->timeLogin;
    }
    /**
     * Set timeLogin value
     * @param int $timeLogin
     * @return \StructType\StructSessionInfo
     */
    public function setTimeLogin($timeLogin = null)
    {
        // validation for constraint: int
        if (!is_null($timeLogin) && !(is_int($timeLogin) || ctype_digit($timeLogin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeLogin, true), gettype($timeLogin)), __LINE__);
        }
        $this->timeLogin = $timeLogin;
        return $this;
    }
    /**
     * Get timeLastActivity value
     * @return int|null
     */
    public function getTimeLastActivity()
    {
        return $this->timeLastActivity;
    }
    /**
     * Set timeLastActivity value
     * @param int $timeLastActivity
     * @return \StructType\StructSessionInfo
     */
    public function setTimeLastActivity($timeLastActivity = null)
    {
        // validation for constraint: int
        if (!is_null($timeLastActivity) && !(is_int($timeLastActivity) || ctype_digit($timeLastActivity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeLastActivity, true), gettype($timeLastActivity)), __LINE__);
        }
        $this->timeLastActivity = $timeLastActivity;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\StructSessionInfo
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Get sync value
     * @return int|null
     */
    public function getSync()
    {
        return $this->sync;
    }
    /**
     * Set sync value
     * @param int $sync
     * @return \StructType\StructSessionInfo
     */
    public function setSync($sync = null)
    {
        // validation for constraint: int
        if (!is_null($sync) && !(is_int($sync) || ctype_digit($sync))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sync, true), gettype($sync)), __LINE__);
        }
        $this->sync = $sync;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructSessionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
