<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryWebFwdList StructType
 * @subpackage Structs
 * @Version 2.0
 */
class StructQueryWebFwdList extends AbstractStructBase
{
    /**
     * The FQDN
     * @var string
     */
    public $FQDN;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The target
     * @var string
     */
    public $target;
    /**
     * The install
     * @var int
     */
    public $install;
    /**
     * The options
     * @var \StructType\StructOptionsFwd
     */
    public $options;
    /**
     * Constructor method for StructQueryWebFwdList
     * @uses StructQueryWebFwdList::setFQDN()
     * @uses StructQueryWebFwdList::setType()
     * @uses StructQueryWebFwdList::setTarget()
     * @uses StructQueryWebFwdList::setInstall()
     * @uses StructQueryWebFwdList::setOptions()
     * @param string $fQDN
     * @param string $type
     * @param string $target
     * @param int $install
     * @param \StructType\StructOptionsFwd $options
     */
    public function __construct($fQDN = null, $type = null, $target = null, $install = null, \StructType\StructOptionsFwd $options = null)
    {
        $this
            ->setFQDN($fQDN)
            ->setType($type)
            ->setTarget($target)
            ->setInstall($install)
            ->setOptions($options);
    }
    /**
     * Get FQDN value
     * @return string|null
     */
    public function getFQDN()
    {
        return $this->FQDN;
    }
    /**
     * Set FQDN value
     * @param string $fQDN
     * @return \StructType\StructQueryWebFwdList
     */
    public function setFQDN($fQDN = null)
    {
        // validation for constraint: string
        if (!is_null($fQDN) && !is_string($fQDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fQDN, true), gettype($fQDN)), __LINE__);
        }
        $this->FQDN = $fQDN;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\StructQueryWebFwdList
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\StructQueryWebFwdList
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get install value
     * @return int|null
     */
    public function getInstall()
    {
        return $this->install;
    }
    /**
     * Set install value
     * @param int $install
     * @return \StructType\StructQueryWebFwdList
     */
    public function setInstall($install = null)
    {
        // validation for constraint: int
        if (!is_null($install) && !(is_int($install) || ctype_digit($install))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($install, true), gettype($install)), __LINE__);
        }
        $this->install = $install;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\StructOptionsFwd|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\StructOptionsFwd $options
     * @return \StructType\StructQueryWebFwdList
     */
    public function setOptions(\StructType\StructOptionsFwd $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructQueryWebFwdList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
