<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryMailFwdList StructType
 * @subpackage Structs
 * @Version 2.0
 */
class StructQueryMailFwdList extends AbstractStructBase
{
    /**
     * The mailBox
     * @var string
     */
    public $mailBox;
    /**
     * The recipients
     * @var string
     */
    public $recipients;
    /**
     * The install
     * @var int
     */
    public $install;
    /**
     * Constructor method for StructQueryMailFwdList
     * @uses StructQueryMailFwdList::setMailBox()
     * @uses StructQueryMailFwdList::setRecipients()
     * @uses StructQueryMailFwdList::setInstall()
     * @param string $mailBox
     * @param string $recipients
     * @param int $install
     */
    public function __construct($mailBox = null, $recipients = null, $install = null)
    {
        $this
            ->setMailBox($mailBox)
            ->setRecipients($recipients)
            ->setInstall($install);
    }
    /**
     * Get mailBox value
     * @return string|null
     */
    public function getMailBox()
    {
        return $this->mailBox;
    }
    /**
     * Set mailBox value
     * @param string $mailBox
     * @return \StructType\StructQueryMailFwdList
     */
    public function setMailBox($mailBox = null)
    {
        // validation for constraint: string
        if (!is_null($mailBox) && !is_string($mailBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailBox, true), gettype($mailBox)), __LINE__);
        }
        $this->mailBox = $mailBox;
        return $this;
    }
    /**
     * Get recipients value
     * @return string|null
     */
    public function getRecipients()
    {
        return $this->recipients;
    }
    /**
     * Set recipients value
     * @param string $recipients
     * @return \StructType\StructQueryMailFwdList
     */
    public function setRecipients($recipients = null)
    {
        // validation for constraint: string
        if (!is_null($recipients) && !is_string($recipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipients, true), gettype($recipients)), __LINE__);
        }
        $this->recipients = $recipients;
        return $this;
    }
    /**
     * Get install value
     * @return int|null
     */
    public function getInstall()
    {
        return $this->install;
    }
    /**
     * Set install value
     * @param int $install
     * @return \StructType\StructQueryMailFwdList
     */
    public function setInstall($install = null)
    {
        // validation for constraint: int
        if (!is_null($install) && !(is_int($install) || ctype_digit($install))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($install, true), gettype($install)), __LINE__);
        }
        $this->install = $install;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructQueryMailFwdList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
