<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructOptionsFwd StructType
 * @subpackage Structs
 * @Version 2.0
 */
class StructOptionsFwd extends AbstractStructBase
{
    /**
     * The header
     * @var int
     */
    public $header;
    /**
     * The protocol
     * @var string
     */
    public $protocol;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The parking
     * @var string
     */
    public $parking;
    /**
     * Constructor method for StructOptionsFwd
     * @uses StructOptionsFwd::setHeader()
     * @uses StructOptionsFwd::setProtocol()
     * @uses StructOptionsFwd::setTitle()
     * @uses StructOptionsFwd::setParking()
     * @param int $header
     * @param string $protocol
     * @param string $title
     * @param string $parking
     */
    public function __construct($header = null, $protocol = null, $title = null, $parking = null)
    {
        $this
            ->setHeader($header)
            ->setProtocol($protocol)
            ->setTitle($title)
            ->setParking($parking);
    }
    /**
     * Get header value
     * @return int|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param int $header
     * @return \StructType\StructOptionsFwd
     */
    public function setHeader($header = null)
    {
        // validation for constraint: int
        if (!is_null($header) && !(is_int($header) || ctype_digit($header))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        $this->header = $header;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \StructType\StructOptionsFwd
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocol, true), gettype($protocol)), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\StructOptionsFwd
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get parking value
     * @return string|null
     */
    public function getParking()
    {
        return $this->parking;
    }
    /**
     * Set parking value
     * @param string $parking
     * @return \StructType\StructOptionsFwd
     */
    public function setParking($parking = null)
    {
        // validation for constraint: string
        if (!is_null($parking) && !is_string($parking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parking, true), gettype($parking)), __LINE__);
        }
        $this->parking = $parking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructOptionsFwd
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
