<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructDomainInfo StructType
 * @subpackage Structs
 * @Version 2.0
 */
class StructDomainInfo extends AbstractStructBase
{
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * The dateCreate
     * @var string
     */
    public $dateCreate;
    /**
     * The dateExpiration
     * @var string
     */
    public $dateExpiration;
    /**
     * The dateMinRenew
     * @var string
     */
    public $dateMinRenew;
    /**
     * The dateMaxRenew
     * @var string
     */
    public $dateMaxRenew;
    /**
     * The dateMaxRestore
     * @var string
     */
    public $dateMaxRestore;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The idOwner
     * @var string
     */
    public $idOwner;
    /**
     * The idAdmin
     * @var string
     */
    public $idAdmin;
    /**
     * The idTech
     * @var string
     */
    public $idTech;
    /**
     * The idBilling
     * @var string
     */
    public $idBilling;
    /**
     * The domainIsLock
     * @var int
     */
    public $domainIsLock;
    /**
     * The whoisPrivacy
     * @var int
     */
    public $whoisPrivacy;
    /**
     * The autoRenew
     * @var int
     */
    public $autoRenew;
    /**
     * The ns
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soapenc:Array
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $ns;
    /**
     * The authID
     * @var string
     */
    public $authID;
    /**
     * The IsSigned
     * @var int
     */
    public $IsSigned;
    /**
     * The DNSSEC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $DNSSEC;
    /**
     * Constructor method for StructDomainInfo
     * @uses StructDomainInfo::setDomain()
     * @uses StructDomainInfo::setDateCreate()
     * @uses StructDomainInfo::setDateExpiration()
     * @uses StructDomainInfo::setDateMinRenew()
     * @uses StructDomainInfo::setDateMaxRenew()
     * @uses StructDomainInfo::setDateMaxRestore()
     * @uses StructDomainInfo::setStatus()
     * @uses StructDomainInfo::setIdOwner()
     * @uses StructDomainInfo::setIdAdmin()
     * @uses StructDomainInfo::setIdTech()
     * @uses StructDomainInfo::setIdBilling()
     * @uses StructDomainInfo::setDomainIsLock()
     * @uses StructDomainInfo::setWhoisPrivacy()
     * @uses StructDomainInfo::setAutoRenew()
     * @uses StructDomainInfo::setNs()
     * @uses StructDomainInfo::setAuthID()
     * @uses StructDomainInfo::setIsSigned()
     * @uses StructDomainInfo::setDNSSEC()
     * @param string $domain
     * @param string $dateCreate
     * @param string $dateExpiration
     * @param string $dateMinRenew
     * @param string $dateMaxRenew
     * @param string $dateMaxRestore
     * @param string $status
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param int $domainIsLock
     * @param int $whoisPrivacy
     * @param int $autoRenew
     * @param string[] $ns
     * @param string $authID
     * @param int $isSigned
     * @param mixed $dNSSEC
     */
    public function __construct($domain = null, $dateCreate = null, $dateExpiration = null, $dateMinRenew = null, $dateMaxRenew = null, $dateMaxRestore = null, $status = null, $idOwner = null, $idAdmin = null, $idTech = null, $idBilling = null, $domainIsLock = null, $whoisPrivacy = null, $autoRenew = null, array $ns = array(), $authID = null, $isSigned = null, $dNSSEC = null)
    {
        $this
            ->setDomain($domain)
            ->setDateCreate($dateCreate)
            ->setDateExpiration($dateExpiration)
            ->setDateMinRenew($dateMinRenew)
            ->setDateMaxRenew($dateMaxRenew)
            ->setDateMaxRestore($dateMaxRestore)
            ->setStatus($status)
            ->setIdOwner($idOwner)
            ->setIdAdmin($idAdmin)
            ->setIdTech($idTech)
            ->setIdBilling($idBilling)
            ->setDomainIsLock($domainIsLock)
            ->setWhoisPrivacy($whoisPrivacy)
            ->setAutoRenew($autoRenew)
            ->setNs($ns)
            ->setAuthID($authID)
            ->setIsSigned($isSigned)
            ->setDNSSEC($dNSSEC);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\StructDomainInfo
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get dateCreate value
     * @return string|null
     */
    public function getDateCreate()
    {
        return $this->dateCreate;
    }
    /**
     * Set dateCreate value
     * @param string $dateCreate
     * @return \StructType\StructDomainInfo
     */
    public function setDateCreate($dateCreate = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreate) && !is_string($dateCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreate, true), gettype($dateCreate)), __LINE__);
        }
        $this->dateCreate = $dateCreate;
        return $this;
    }
    /**
     * Get dateExpiration value
     * @return string|null
     */
    public function getDateExpiration()
    {
        return $this->dateExpiration;
    }
    /**
     * Set dateExpiration value
     * @param string $dateExpiration
     * @return \StructType\StructDomainInfo
     */
    public function setDateExpiration($dateExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($dateExpiration) && !is_string($dateExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateExpiration, true), gettype($dateExpiration)), __LINE__);
        }
        $this->dateExpiration = $dateExpiration;
        return $this;
    }
    /**
     * Get dateMinRenew value
     * @return string|null
     */
    public function getDateMinRenew()
    {
        return $this->dateMinRenew;
    }
    /**
     * Set dateMinRenew value
     * @param string $dateMinRenew
     * @return \StructType\StructDomainInfo
     */
    public function setDateMinRenew($dateMinRenew = null)
    {
        // validation for constraint: string
        if (!is_null($dateMinRenew) && !is_string($dateMinRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateMinRenew, true), gettype($dateMinRenew)), __LINE__);
        }
        $this->dateMinRenew = $dateMinRenew;
        return $this;
    }
    /**
     * Get dateMaxRenew value
     * @return string|null
     */
    public function getDateMaxRenew()
    {
        return $this->dateMaxRenew;
    }
    /**
     * Set dateMaxRenew value
     * @param string $dateMaxRenew
     * @return \StructType\StructDomainInfo
     */
    public function setDateMaxRenew($dateMaxRenew = null)
    {
        // validation for constraint: string
        if (!is_null($dateMaxRenew) && !is_string($dateMaxRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateMaxRenew, true), gettype($dateMaxRenew)), __LINE__);
        }
        $this->dateMaxRenew = $dateMaxRenew;
        return $this;
    }
    /**
     * Get dateMaxRestore value
     * @return string|null
     */
    public function getDateMaxRestore()
    {
        return $this->dateMaxRestore;
    }
    /**
     * Set dateMaxRestore value
     * @param string $dateMaxRestore
     * @return \StructType\StructDomainInfo
     */
    public function setDateMaxRestore($dateMaxRestore = null)
    {
        // validation for constraint: string
        if (!is_null($dateMaxRestore) && !is_string($dateMaxRestore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateMaxRestore, true), gettype($dateMaxRestore)), __LINE__);
        }
        $this->dateMaxRestore = $dateMaxRestore;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\StructDomainInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get idOwner value
     * @return string|null
     */
    public function getIdOwner()
    {
        return $this->idOwner;
    }
    /**
     * Set idOwner value
     * @param string $idOwner
     * @return \StructType\StructDomainInfo
     */
    public function setIdOwner($idOwner = null)
    {
        // validation for constraint: string
        if (!is_null($idOwner) && !is_string($idOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idOwner, true), gettype($idOwner)), __LINE__);
        }
        $this->idOwner = $idOwner;
        return $this;
    }
    /**
     * Get idAdmin value
     * @return string|null
     */
    public function getIdAdmin()
    {
        return $this->idAdmin;
    }
    /**
     * Set idAdmin value
     * @param string $idAdmin
     * @return \StructType\StructDomainInfo
     */
    public function setIdAdmin($idAdmin = null)
    {
        // validation for constraint: string
        if (!is_null($idAdmin) && !is_string($idAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idAdmin, true), gettype($idAdmin)), __LINE__);
        }
        $this->idAdmin = $idAdmin;
        return $this;
    }
    /**
     * Get idTech value
     * @return string|null
     */
    public function getIdTech()
    {
        return $this->idTech;
    }
    /**
     * Set idTech value
     * @param string $idTech
     * @return \StructType\StructDomainInfo
     */
    public function setIdTech($idTech = null)
    {
        // validation for constraint: string
        if (!is_null($idTech) && !is_string($idTech)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idTech, true), gettype($idTech)), __LINE__);
        }
        $this->idTech = $idTech;
        return $this;
    }
    /**
     * Get idBilling value
     * @return string|null
     */
    public function getIdBilling()
    {
        return $this->idBilling;
    }
    /**
     * Set idBilling value
     * @param string $idBilling
     * @return \StructType\StructDomainInfo
     */
    public function setIdBilling($idBilling = null)
    {
        // validation for constraint: string
        if (!is_null($idBilling) && !is_string($idBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idBilling, true), gettype($idBilling)), __LINE__);
        }
        $this->idBilling = $idBilling;
        return $this;
    }
    /**
     * Get domainIsLock value
     * @return int|null
     */
    public function getDomainIsLock()
    {
        return $this->domainIsLock;
    }
    /**
     * Set domainIsLock value
     * @param int $domainIsLock
     * @return \StructType\StructDomainInfo
     */
    public function setDomainIsLock($domainIsLock = null)
    {
        // validation for constraint: int
        if (!is_null($domainIsLock) && !(is_int($domainIsLock) || ctype_digit($domainIsLock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($domainIsLock, true), gettype($domainIsLock)), __LINE__);
        }
        $this->domainIsLock = $domainIsLock;
        return $this;
    }
    /**
     * Get whoisPrivacy value
     * @return int|null
     */
    public function getWhoisPrivacy()
    {
        return $this->whoisPrivacy;
    }
    /**
     * Set whoisPrivacy value
     * @param int $whoisPrivacy
     * @return \StructType\StructDomainInfo
     */
    public function setWhoisPrivacy($whoisPrivacy = null)
    {
        // validation for constraint: int
        if (!is_null($whoisPrivacy) && !(is_int($whoisPrivacy) || ctype_digit($whoisPrivacy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whoisPrivacy, true), gettype($whoisPrivacy)), __LINE__);
        }
        $this->whoisPrivacy = $whoisPrivacy;
        return $this;
    }
    /**
     * Get autoRenew value
     * @return int|null
     */
    public function getAutoRenew()
    {
        return $this->autoRenew;
    }
    /**
     * Set autoRenew value
     * @param int $autoRenew
     * @return \StructType\StructDomainInfo
     */
    public function setAutoRenew($autoRenew = null)
    {
        // validation for constraint: int
        if (!is_null($autoRenew) && !(is_int($autoRenew) || ctype_digit($autoRenew))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($autoRenew, true), gettype($autoRenew)), __LINE__);
        }
        $this->autoRenew = $autoRenew;
        return $this;
    }
    /**
     * Get ns value
     * @return string[]|null
     */
    public function getNs()
    {
        return $this->ns;
    }
    /**
     * This method is responsible for validating the values passed to the setNs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNsForArrayConstraintsFromSetNs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $structDomainInfoNsItem) {
            // validation for constraint: itemType
            if (!is_string($structDomainInfoNsItem)) {
                $invalidValues[] = is_object($structDomainInfoNsItem) ? get_class($structDomainInfoNsItem) : sprintf('%s(%s)', gettype($structDomainInfoNsItem), var_export($structDomainInfoNsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ns property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ns value
     * @throws \InvalidArgumentException
     * @param string[] $ns
     * @return \StructType\StructDomainInfo
     */
    public function setNs(array $ns = array())
    {
        // validation for constraint: array
        if ('' !== ($nsArrayErrorMessage = self::validateNsForArrayConstraintsFromSetNs($ns))) {
            throw new \InvalidArgumentException($nsArrayErrorMessage, __LINE__);
        }
        $this->ns = $ns;
        return $this;
    }
    /**
     * Add item to ns value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\StructDomainInfo
     */
    public function addToNs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ns property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ns[] = $item;
        return $this;
    }
    /**
     * Get authID value
     * @return string|null
     */
    public function getAuthID()
    {
        return $this->authID;
    }
    /**
     * Set authID value
     * @param string $authID
     * @return \StructType\StructDomainInfo
     */
    public function setAuthID($authID = null)
    {
        // validation for constraint: string
        if (!is_null($authID) && !is_string($authID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authID, true), gettype($authID)), __LINE__);
        }
        $this->authID = $authID;
        return $this;
    }
    /**
     * Get IsSigned value
     * @return int|null
     */
    public function getIsSigned()
    {
        return $this->IsSigned;
    }
    /**
     * Set IsSigned value
     * @param int $isSigned
     * @return \StructType\StructDomainInfo
     */
    public function setIsSigned($isSigned = null)
    {
        // validation for constraint: int
        if (!is_null($isSigned) && !(is_int($isSigned) || ctype_digit($isSigned))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isSigned, true), gettype($isSigned)), __LINE__);
        }
        $this->IsSigned = $isSigned;
        return $this;
    }
    /**
     * Get DNSSEC value
     * @return mixed|null
     */
    public function getDNSSEC()
    {
        return $this->DNSSEC;
    }
    /**
     * Set DNSSEC value
     * @param mixed $dNSSEC
     * @return \StructType\StructDomainInfo
     */
    public function setDNSSEC($dNSSEC = null)
    {
        $this->DNSSEC = $dNSSEC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructDomainInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
