<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Contact ServiceType
 * @subpackage Services
 * @Version 2.0
 */
class Contact extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named contactCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param \StructType\StructContact $contact
     * @return string|bool
     */
    public function contactCreate($iDSession, \StructType\StructContact $contact)
    {
        try {
            $this->setResult($this->getSoapClient()->contactCreate($iDSession, $contact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $idContact
     * @return \StructType\StructOperationResponse|bool
     */
    public function contactDelete($iDSession, $idContact)
    {
        try {
            $this->setResult($this->getSoapClient()->contactDelete($iDSession, $idContact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $iDIdentifiant
     * @return \StructType\StructContactReturn|bool
     */
    public function contactInfo($iDSession, $iDIdentifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->contactInfo($iDSession, $iDIdentifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $idContact
     * @param \StructType\StructContact $contact
     * @return \StructType\StructOperationResponse|bool
     */
    public function contactUpdate($iDSession, $idContact, \StructType\StructContact $contact)
    {
        try {
            $this->setResult($this->getSoapClient()->contactUpdate($iDSession, $idContact, $contact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contactOwnerUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $idContact
     * @param \StructType\StructOwnerContact $contact
     * @return \StructType\StructOperationResponse|bool
     */
    public function contactOwnerUpdate($iDSession, $idContact, \StructType\StructOwnerContact $contact)
    {
        try {
            $this->setResult($this->getSoapClient()->contactOwnerUpdate($iDSession, $idContact, $contact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\StructType\StructContactReturn|\StructType\StructOperationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
