<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKeyValueData ArrayType
 * @subpackage Arrays
 * @Version 2.0
 */
class ArrayOfKeyValueData extends AbstractStructArrayBase
{
    /**
     * The keyval
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $keyval;
    /**
     * Constructor method for ArrayOfKeyValueData
     * @uses ArrayOfKeyValueData::setKeyval()
     * @param mixed[] $keyval
     */
    public function __construct(array $keyval = array())
    {
        $this
            ->setKeyval($keyval);
    }
    /**
     * Get keyval value
     * @return mixed[]|null
     */
    public function getKeyval()
    {
        return $this->keyval;
    }
    /**
     * This method is responsible for validating the values passed to the setKeyval method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyval method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyvalForArrayConstraintsFromSetKeyval(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfKeyValueDataKeyvalItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($arrayOfKeyValueDataKeyvalItem) ? get_class($arrayOfKeyValueDataKeyvalItem) : sprintf('%s(%s)', gettype($arrayOfKeyValueDataKeyvalItem), var_export($arrayOfKeyValueDataKeyvalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The keyval property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set keyval value
     * @throws \InvalidArgumentException
     * @param mixed[] $keyval
     * @return \ArrayType\ArrayOfKeyValueData
     */
    public function setKeyval(array $keyval = array())
    {
        // validation for constraint: array
        if ('' !== ($keyvalArrayErrorMessage = self::validateKeyvalForArrayConstraintsFromSetKeyval($keyval))) {
            throw new \InvalidArgumentException($keyvalArrayErrorMessage, __LINE__);
        }
        $this->keyval = $keyval;
        return $this;
    }
    /**
     * Add item to keyval value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \ArrayType\ArrayOfKeyValueData
     */
    public function addToKeyval($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The keyval property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->keyval[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return mixed|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return mixed|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return mixed|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return mixed|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string keyval
     */
    public function getAttributeName()
    {
        return 'keyval';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfKeyValueData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
