<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructTld StructType
 * @subpackage Structs
 * @Version 2.0
 */
class StructTld extends AbstractStructBase
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The tld
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soapenc:Array
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $tld;
    /**
     * Constructor method for StructTld
     * @uses StructTld::setType()
     * @uses StructTld::setTld()
     * @param string $type
     * @param string[] $tld
     */
    public function __construct($type = null, array $tld = array())
    {
        $this
            ->setType($type)
            ->setTld($tld);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\StructTld
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get tld value
     * @return string[]|null
     */
    public function getTld()
    {
        return $this->tld;
    }
    /**
     * This method is responsible for validating the values passed to the setTld method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTld method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTldForArrayConstraintsFromSetTld(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $structTldTldItem) {
            // validation for constraint: itemType
            if (!is_string($structTldTldItem)) {
                $invalidValues[] = is_object($structTldTldItem) ? get_class($structTldTldItem) : sprintf('%s(%s)', gettype($structTldTldItem), var_export($structTldTldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tld property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tld value
     * @throws \InvalidArgumentException
     * @param string[] $tld
     * @return \StructType\StructTld
     */
    public function setTld(array $tld = array())
    {
        // validation for constraint: array
        if ('' !== ($tldArrayErrorMessage = self::validateTldForArrayConstraintsFromSetTld($tld))) {
            throw new \InvalidArgumentException($tldArrayErrorMessage, __LINE__);
        }
        $this->tld = $tld;
        return $this;
    }
    /**
     * Add item to tld value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\StructTld
     */
    public function addToTld($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The tld property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tld[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructTld
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
