<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructHostList StructType
 * @subpackage Structs
 * @Version 2.0
 */
class StructHostList extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The ipv4
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soapenc:Array
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $ipv4;
    /**
     * The ipv6
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soapenc:Array
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $ipv6;
    /**
     * Constructor method for StructHostList
     * @uses StructHostList::setName()
     * @uses StructHostList::setIpv4()
     * @uses StructHostList::setIpv6()
     * @param string $name
     * @param string[] $ipv4
     * @param string[] $ipv6
     */
    public function __construct($name = null, array $ipv4 = array(), array $ipv6 = array())
    {
        $this
            ->setName($name)
            ->setIpv4($ipv4)
            ->setIpv6($ipv6);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\StructHostList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipv4 value
     * @return string[]|null
     */
    public function getIpv4()
    {
        return $this->ipv4;
    }
    /**
     * This method is responsible for validating the values passed to the setIpv4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIpv4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIpv4ForArrayConstraintsFromSetIpv4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $structHostListIpv4Item) {
            // validation for constraint: itemType
            if (!is_string($structHostListIpv4Item)) {
                $invalidValues[] = is_object($structHostListIpv4Item) ? get_class($structHostListIpv4Item) : sprintf('%s(%s)', gettype($structHostListIpv4Item), var_export($structHostListIpv4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ipv4 property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ipv4 value
     * @throws \InvalidArgumentException
     * @param string[] $ipv4
     * @return \StructType\StructHostList
     */
    public function setIpv4(array $ipv4 = array())
    {
        // validation for constraint: array
        if ('' !== ($ipv4ArrayErrorMessage = self::validateIpv4ForArrayConstraintsFromSetIpv4($ipv4))) {
            throw new \InvalidArgumentException($ipv4ArrayErrorMessage, __LINE__);
        }
        $this->ipv4 = $ipv4;
        return $this;
    }
    /**
     * Add item to ipv4 value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\StructHostList
     */
    public function addToIpv4($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ipv4 property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ipv4[] = $item;
        return $this;
    }
    /**
     * Get ipv6 value
     * @return string[]|null
     */
    public function getIpv6()
    {
        return $this->ipv6;
    }
    /**
     * This method is responsible for validating the values passed to the setIpv6 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIpv6 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIpv6ForArrayConstraintsFromSetIpv6(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $structHostListIpv6Item) {
            // validation for constraint: itemType
            if (!is_string($structHostListIpv6Item)) {
                $invalidValues[] = is_object($structHostListIpv6Item) ? get_class($structHostListIpv6Item) : sprintf('%s(%s)', gettype($structHostListIpv6Item), var_export($structHostListIpv6Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ipv6 property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ipv6 value
     * @throws \InvalidArgumentException
     * @param string[] $ipv6
     * @return \StructType\StructHostList
     */
    public function setIpv6(array $ipv6 = array())
    {
        // validation for constraint: array
        if ('' !== ($ipv6ArrayErrorMessage = self::validateIpv6ForArrayConstraintsFromSetIpv6($ipv6))) {
            throw new \InvalidArgumentException($ipv6ArrayErrorMessage, __LINE__);
        }
        $this->ipv6 = $ipv6;
        return $this;
    }
    /**
     * Add item to ipv6 value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\StructHostList
     */
    public function addToIpv6($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ipv6 property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ipv6[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructHostList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
