<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructDomainList StructType
 * @subpackage Structs
 * @Version 2.0
 */
class StructDomainList extends AbstractStructBase
{
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * The dateCreate
     * @var string
     */
    public $dateCreate;
    /**
     * The dateExpiration
     * @var string
     */
    public $dateExpiration;
    /**
     * Constructor method for StructDomainList
     * @uses StructDomainList::setDomain()
     * @uses StructDomainList::setDateCreate()
     * @uses StructDomainList::setDateExpiration()
     * @param string $domain
     * @param string $dateCreate
     * @param string $dateExpiration
     */
    public function __construct($domain = null, $dateCreate = null, $dateExpiration = null)
    {
        $this
            ->setDomain($domain)
            ->setDateCreate($dateCreate)
            ->setDateExpiration($dateExpiration);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\StructDomainList
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get dateCreate value
     * @return string|null
     */
    public function getDateCreate()
    {
        return $this->dateCreate;
    }
    /**
     * Set dateCreate value
     * @param string $dateCreate
     * @return \StructType\StructDomainList
     */
    public function setDateCreate($dateCreate = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreate) && !is_string($dateCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreate, true), gettype($dateCreate)), __LINE__);
        }
        $this->dateCreate = $dateCreate;
        return $this;
    }
    /**
     * Get dateExpiration value
     * @return string|null
     */
    public function getDateExpiration()
    {
        return $this->dateExpiration;
    }
    /**
     * Set dateExpiration value
     * @param string $dateExpiration
     * @return \StructType\StructDomainList
     */
    public function setDateExpiration($dateExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($dateExpiration) && !is_string($dateExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateExpiration, true), gettype($dateExpiration)), __LINE__);
        }
        $this->dateExpiration = $dateExpiration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructDomainList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
