<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 * @Version 2.0
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named queryAllSessions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \StructType\StructSessionInfo[]|bool
     */
    public function queryAllSessions($iDSession)
    {
        try {
            $this->setResult($this->getSoapClient()->queryAllSessions($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryOpeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $ext
     * @return \StructType\StructQueryOpeList|bool
     */
    public function queryOpeList($iDSession, $ext)
    {
        try {
            $this->setResult($this->getSoapClient()->queryOpeList($iDSession, $ext));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryDomainList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $filter
     * @return \StructType\StructDomainList[]|bool
     */
    public function queryDomainList($iDSession, $filter)
    {
        try {
            $this->setResult($this->getSoapClient()->queryDomainList($iDSession, $filter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryDomainPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $authID
     * @return \StructType\StructQueryDomainPrice|bool
     */
    public function queryDomainPrice($iDSession, $domain, $authID)
    {
        try {
            $this->setResult($this->getSoapClient()->queryDomainPrice($iDSession, $domain, $authID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryDomainClaim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return int|bool
     */
    public function queryDomainClaim($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->queryDomainClaim($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryOpe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $numOperation
     * @return \StructType\StructOperationResponse|bool
     */
    public function queryOpe($iDSession, $numOperation)
    {
        try {
            $this->setResult($this->getSoapClient()->queryOpe($iDSession, $numOperation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryContactList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $filter
     * @param string $field
     * @return \StructType\StructContactList[]|bool
     */
    public function queryContactList($iDSession, $filter, $field)
    {
        try {
            $this->setResult($this->getSoapClient()->queryContactList($iDSession, $filter, $field));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryZoneList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \StructType\StructQueryZoneList[]|bool
     */
    public function queryZoneList($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->queryZoneList($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryMailFwdList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \StructType\StructQueryMailFwdList[]|bool
     */
    public function queryMailFwdList($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->queryMailFwdList($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryWebFwdList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \StructType\StructQueryWebFwdList[]|bool
     */
    public function queryWebFwdList($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->queryWebFwdList($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryHostList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $filter
     * @return \StructType\StructHostList[]|bool
     */
    public function queryHostList($iDSession, $filter)
    {
        try {
            $this->setResult($this->getSoapClient()->queryHostList($iDSession, $filter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryResellerAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \StructType\StructQueryResellerAccount|bool
     */
    public function queryResellerAccount($iDSession)
    {
        try {
            $this->setResult($this->getSoapClient()->queryResellerAccount($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryOpePending
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \StructType\StructQueryOpePending[]|bool
     */
    public function queryOpePending($iDSession)
    {
        try {
            $this->setResult($this->getSoapClient()->queryOpePending($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int|\StructType\StructContactList[]|\StructType\StructDomainList[]|\StructType\StructHostList[]|\StructType\StructOperationResponse|\StructType\StructQueryDomainPrice|\StructType\StructQueryMailFwdList[]|\StructType\StructQueryOpeList|\StructType\StructQueryOpePending[]|\StructType\StructQueryResellerAccount|\StructType\StructQueryWebFwdList[]|\StructType\StructQueryZoneList[]|\StructType\StructSessionInfo[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
