<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ope ServiceType
 * @subpackage Services
 * @Version 2.0
 */
class Ope extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named opeSpecial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $action
     * @param \ArrayType\ArrayOfKeyValueData $params
     * @param string $reseller
     * @return \StructType\StructOperationResponse|bool
     */
    public function opeSpecial($iDSession, $action, \ArrayType\ArrayOfKeyValueData $params, $reseller)
    {
        try {
            $this->setResult($this->getSoapClient()->opeSpecial($iDSession, $action, $params, $reseller));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StructOperationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
