<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Domain ServiceType
 * @subpackage Services
 * @Version 2.0
 */
class Domain extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named domainWhois
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return string|bool
     */
    public function domainWhois($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->domainWhois($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \StructType\StructDomainCheckResponse[]|bool
     */
    public function domainCheck($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->domainCheck($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @param string $duration
     * @param string $templateDNS
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainCreate($iDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $templateDNS)
    {
        try {
            $this->setResult($this->getSoapClient()->domainCreate($iDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $templateDNS));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainCreateLP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @param string $duration
     * @param string $launchPhase
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainCreateLP($iDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $launchPhase)
    {
        try {
            $this->setResult($this->getSoapClient()->domainCreateLP($iDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $launchPhase));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \StructType\StructDomainInfo|bool
     */
    public function domainInfo($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->domainInfo($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainTldInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $tld
     * @return \StructType\StructDomainTldInfo|bool
     */
    public function domainTldInfo($iDSession, $tld)
    {
        try {
            $this->setResult($this->getSoapClient()->domainTldInfo($iDSession, $tld));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainPriceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @return \StructType\StructDomainPriceList[]|bool
     */
    public function domainPriceList($iDSession)
    {
        try {
            $this->setResult($this->getSoapClient()->domainPriceList($iDSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainAuthID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $sendtoregistrant
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainAuthID($iDSession, $domain, $sendtoregistrant)
    {
        try {
            $this->setResult($this->getSoapClient()->domainAuthID($iDSession, $domain, $sendtoregistrant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainSetMembership
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $token
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainSetMembership($iDSession, $domain, $token)
    {
        try {
            $this->setResult($this->getSoapClient()->domainSetMembership($iDSession, $domain, $token));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainChangeContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainChangeContact($iDSession, $domain, $idAdmin, $idTech, $idBilling)
    {
        try {
            $this->setResult($this->getSoapClient()->domainChangeContact($iDSession, $domain, $idAdmin, $idTech, $idBilling));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainChangeDNS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainChangeDNS($iDSession, $domain, $ns1, $ns2, $ns3, $ns4, $ns5)
    {
        try {
            $this->setResult($this->getSoapClient()->domainChangeDNS($iDSession, $domain, $ns1, $ns2, $ns3, $ns4, $ns5));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainSetDNSSec
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $enable
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainSetDNSSec($iDSession, $domain, $enable)
    {
        try {
            $this->setResult($this->getSoapClient()->domainSetDNSSec($iDSession, $domain, $enable));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainSetDNSSecExt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param \StructType\StructDSRecord[] $dSRecords
     * @param string $flags
     * @param string $protocol
     * @param string $algo
     * @param string $pubKey
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainSetDNSSecExt($iDSession, $domain, array $dSRecords, $flags, $protocol, $algo, $pubKey)
    {
        try {
            $this->setResult($this->getSoapClient()->domainSetDNSSecExt($iDSession, $domain, $dSRecords, $flags, $protocol, $algo, $pubKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $duration
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainRenew($iDSession, $domain, $duration)
    {
        try {
            $this->setResult($this->getSoapClient()->domainRenew($iDSession, $domain, $duration));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainRelease
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainRelease($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->domainRelease($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainRestore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainRestore($iDSession, $domain)
    {
        try {
            $this->setResult($this->getSoapClient()->domainRestore($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainInternalTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $authID
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainInternalTransfer($iDSession, $domain, $authID, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5)
    {
        try {
            $this->setResult($this->getSoapClient()->domainInternalTransfer($iDSession, $domain, $authID, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainTransferIn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $authID
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainTransferIn($iDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5)
    {
        try {
            $this->setResult($this->getSoapClient()->domainTransferIn($iDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainTransferTrade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $authID
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param string $ns1
     * @param string $ns2
     * @param string $ns3
     * @param string $ns4
     * @param string $ns5
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainTransferTrade($iDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5)
    {
        try {
            $this->setResult($this->getSoapClient()->domainTransferTrade($iDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainTransferOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $idOwner
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainTransferOwner($iDSession, $domain, $idOwner)
    {
        try {
            $this->setResult($this->getSoapClient()->domainTransferOwner($iDSession, $domain, $idOwner));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainSetPreference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $codePref
     * @param string $enable
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainSetPreference($iDSession, $domain, $codePref, $enable)
    {
        try {
            $this->setResult($this->getSoapClient()->domainSetPreference($iDSession, $domain, $codePref, $enable));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $typeDelete
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainDelete($iDSession, $domain, $typeDelete)
    {
        try {
            $this->setResult($this->getSoapClient()->domainDelete($iDSession, $domain, $typeDelete));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainMailFwdCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mailBox
     * @param string $recipients
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainMailFwdCreate($iDSession, $mailBox, $recipients)
    {
        try {
            $this->setResult($this->getSoapClient()->domainMailFwdCreate($iDSession, $mailBox, $recipients));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainMailFwdDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mailBox
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainMailFwdDelete($iDSession, $mailBox)
    {
        try {
            $this->setResult($this->getSoapClient()->domainMailFwdDelete($iDSession, $mailBox));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainWebFwdCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fQDN
     * @param string $target
     * @param string $type
     * @param \StructType\StructOptionsFwd $structOptionsFwd
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainWebFwdCreate($iDSession, $fQDN, $target, $type, \StructType\StructOptionsFwd $structOptionsFwd)
    {
        try {
            $this->setResult($this->getSoapClient()->domainWebFwdCreate($iDSession, $fQDN, $target, $type, $structOptionsFwd));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainWebFwdDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fQDN
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainWebFwdDelete($iDSession, $fQDN)
    {
        try {
            $this->setResult($this->getSoapClient()->domainWebFwdDelete($iDSession, $fQDN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainZoneCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $subdomain
     * @param string $type
     * @param string $value
     * @param \StructType\StructOptionsZone $structOptionsZone
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainZoneCreate($iDSession, $domain, $subdomain, $type, $value, \StructType\StructOptionsZone $structOptionsZone)
    {
        try {
            $this->setResult($this->getSoapClient()->domainZoneCreate($iDSession, $domain, $subdomain, $type, $value, $structOptionsZone));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainZoneDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $subdomain
     * @param string $type
     * @param string $value
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainZoneDelete($iDSession, $domain, $subdomain, $type, $value)
    {
        try {
            $this->setResult($this->getSoapClient()->domainZoneDelete($iDSession, $domain, $subdomain, $type, $value));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainZoneInit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $numTemplate
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainZoneInit($iDSession, $domain, $numTemplate)
    {
        try {
            $this->setResult($this->getSoapClient()->domainZoneInit($iDSession, $domain, $numTemplate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domainZoneInitSoa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $ttl
     * @param string $ttlUnity
     * @param string $refresh
     * @param string $refreshUnity
     * @param string $retry
     * @param string $retryUnity
     * @param string $expire
     * @param string $expireUnity
     * @param string $minimum
     * @param string $minimumUnity
     * @return \StructType\StructOperationResponse|bool
     */
    public function domainZoneInitSoa($iDSession, $domain, $ttl, $ttlUnity, $refresh, $refreshUnity, $retry, $retryUnity, $expire, $expireUnity, $minimum, $minimumUnity)
    {
        try {
            $this->setResult($this->getSoapClient()->domainZoneInitSoa($iDSession, $domain, $ttl, $ttlUnity, $refresh, $refreshUnity, $retry, $retryUnity, $expire, $expireUnity, $minimum, $minimumUnity));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\StructType\StructDomainCheckResponse[]|\StructType\StructDomainInfo|\StructType\StructDomainPriceList[]|\StructType\StructDomainTldInfo|\StructType\StructOperationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
