<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosEstado StructType
 * @subpackage Structs
 */
class DatosEstado extends AbstractStructBase
{
    /**
     * The GenerarPDF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GenerarPDF;
    /**
     * The Resultado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Resultado;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Token;
    /**
     * The TipoDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoDocumento;
    /**
     * The Identificador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Identificador;
    /**
     * The Mensaje
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mensaje;
    /**
     * The Estado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Estado;
    /**
     * The PDFBase64
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PDFBase64;
    /**
     * Constructor method for DatosEstado
     * @uses DatosEstado::setGenerarPDF()
     * @uses DatosEstado::setResultado()
     * @uses DatosEstado::setToken()
     * @uses DatosEstado::setTipoDocumento()
     * @uses DatosEstado::setIdentificador()
     * @uses DatosEstado::setMensaje()
     * @uses DatosEstado::setEstado()
     * @uses DatosEstado::setPDFBase64()
     * @param bool $generarPDF
     * @param int $resultado
     * @param string $token
     * @param string $tipoDocumento
     * @param string $identificador
     * @param string $mensaje
     * @param string $estado
     * @param string $pDFBase64
     */
    public function __construct($generarPDF = null, $resultado = null, $token = null, $tipoDocumento = null, $identificador = null, $mensaje = null, $estado = null, $pDFBase64 = null)
    {
        $this
            ->setGenerarPDF($generarPDF)
            ->setResultado($resultado)
            ->setToken($token)
            ->setTipoDocumento($tipoDocumento)
            ->setIdentificador($identificador)
            ->setMensaje($mensaje)
            ->setEstado($estado)
            ->setPDFBase64($pDFBase64);
    }
    /**
     * Get GenerarPDF value
     * @return bool
     */
    public function getGenerarPDF()
    {
        return $this->GenerarPDF;
    }
    /**
     * Set GenerarPDF value
     * @param bool $generarPDF
     * @return \StructType\DatosEstado
     */
    public function setGenerarPDF($generarPDF = null)
    {
        // validation for constraint: boolean
        if (!is_null($generarPDF) && !is_bool($generarPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generarPDF, true), gettype($generarPDF)), __LINE__);
        }
        $this->GenerarPDF = $generarPDF;
        return $this;
    }
    /**
     * Get Resultado value
     * @return int
     */
    public function getResultado()
    {
        return $this->Resultado;
    }
    /**
     * Set Resultado value
     * @param int $resultado
     * @return \StructType\DatosEstado
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: int
        if (!is_null($resultado) && !(is_int($resultado) || ctype_digit($resultado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultado, true), gettype($resultado)), __LINE__);
        }
        $this->Resultado = $resultado;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\DatosEstado
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get TipoDocumento value
     * @return string|null
     */
    public function getTipoDocumento()
    {
        return $this->TipoDocumento;
    }
    /**
     * Set TipoDocumento value
     * @param string $tipoDocumento
     * @return \StructType\DatosEstado
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumento) && !is_string($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumento, true), gettype($tipoDocumento)), __LINE__);
        }
        $this->TipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get Identificador value
     * @return string|null
     */
    public function getIdentificador()
    {
        return $this->Identificador;
    }
    /**
     * Set Identificador value
     * @param string $identificador
     * @return \StructType\DatosEstado
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: string
        if (!is_null($identificador) && !is_string($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificador, true), gettype($identificador)), __LINE__);
        }
        $this->Identificador = $identificador;
        return $this;
    }
    /**
     * Get Mensaje value
     * @return string|null
     */
    public function getMensaje()
    {
        return $this->Mensaje;
    }
    /**
     * Set Mensaje value
     * @param string $mensaje
     * @return \StructType\DatosEstado
     */
    public function setMensaje($mensaje = null)
    {
        // validation for constraint: string
        if (!is_null($mensaje) && !is_string($mensaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensaje, true), gettype($mensaje)), __LINE__);
        }
        $this->Mensaje = $mensaje;
        return $this;
    }
    /**
     * Get Estado value
     * @return string|null
     */
    public function getEstado()
    {
        return $this->Estado;
    }
    /**
     * Set Estado value
     * @param string $estado
     * @return \StructType\DatosEstado
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estado, true), gettype($estado)), __LINE__);
        }
        $this->Estado = $estado;
        return $this;
    }
    /**
     * Get PDFBase64 value
     * @return string|null
     */
    public function getPDFBase64()
    {
        return $this->PDFBase64;
    }
    /**
     * Set PDFBase64 value
     * @param string $pDFBase64
     * @return \StructType\DatosEstado
     */
    public function setPDFBase64($pDFBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($pDFBase64) && !is_string($pDFBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDFBase64, true), gettype($pDFBase64)), __LINE__);
        }
        $this->PDFBase64 = $pDFBase64;
        return $this;
    }
}
