<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consultar ServiceType
 * @subpackage Services
 */
class Consultar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named consultarEstado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarEstado $parameters
     * @return \StructType\ConsultarEstadoResponse|bool
     */
    public function consultarEstado(\StructType\ConsultarEstado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->consultarEstado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarEstadoAdv
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarEstadoAdv $parameters
     * @return \StructType\ConsultarEstadoAdvResponse|bool
     */
    public function consultarEstadoAdv(\StructType\ConsultarEstadoAdv $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->consultarEstadoAdv($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultarEstadoAdvResponse|\StructType\ConsultarEstadoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
