<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosEstadoAdv StructType
 * @subpackage Structs
 */
class DatosEstadoAdv extends AbstractStructBase
{
    /**
     * The GenerarPDF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GenerarPDF;
    /**
     * The Resultado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Resultado;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Token;
    /**
     * The TipoDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoDocumento;
    /**
     * The RutReceptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RutReceptor;
    /**
     * The Folio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Folio;
    /**
     * The Mensaje
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mensaje;
    /**
     * The Trx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trx;
    /**
     * The CodigoSII
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoSII;
    /**
     * The FechaEmision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FechaEmision;
    /**
     * The Estado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Estado;
    /**
     * The PDFBase64
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PDFBase64;
    /**
     * Constructor method for DatosEstadoAdv
     * @uses DatosEstadoAdv::setGenerarPDF()
     * @uses DatosEstadoAdv::setResultado()
     * @uses DatosEstadoAdv::setToken()
     * @uses DatosEstadoAdv::setTipoDocumento()
     * @uses DatosEstadoAdv::setRutReceptor()
     * @uses DatosEstadoAdv::setFolio()
     * @uses DatosEstadoAdv::setMensaje()
     * @uses DatosEstadoAdv::setTrx()
     * @uses DatosEstadoAdv::setCodigoSII()
     * @uses DatosEstadoAdv::setFechaEmision()
     * @uses DatosEstadoAdv::setEstado()
     * @uses DatosEstadoAdv::setPDFBase64()
     * @param bool $generarPDF
     * @param int $resultado
     * @param string $token
     * @param string $tipoDocumento
     * @param string $rutReceptor
     * @param string $folio
     * @param string $mensaje
     * @param string $trx
     * @param string $codigoSII
     * @param string $fechaEmision
     * @param string $estado
     * @param string $pDFBase64
     */
    public function __construct($generarPDF = null, $resultado = null, $token = null, $tipoDocumento = null, $rutReceptor = null, $folio = null, $mensaje = null, $trx = null, $codigoSII = null, $fechaEmision = null, $estado = null, $pDFBase64 = null)
    {
        $this
            ->setGenerarPDF($generarPDF)
            ->setResultado($resultado)
            ->setToken($token)
            ->setTipoDocumento($tipoDocumento)
            ->setRutReceptor($rutReceptor)
            ->setFolio($folio)
            ->setMensaje($mensaje)
            ->setTrx($trx)
            ->setCodigoSII($codigoSII)
            ->setFechaEmision($fechaEmision)
            ->setEstado($estado)
            ->setPDFBase64($pDFBase64);
    }
    /**
     * Get GenerarPDF value
     * @return bool
     */
    public function getGenerarPDF()
    {
        return $this->GenerarPDF;
    }
    /**
     * Set GenerarPDF value
     * @param bool $generarPDF
     * @return \StructType\DatosEstadoAdv
     */
    public function setGenerarPDF($generarPDF = null)
    {
        // validation for constraint: boolean
        if (!is_null($generarPDF) && !is_bool($generarPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generarPDF, true), gettype($generarPDF)), __LINE__);
        }
        $this->GenerarPDF = $generarPDF;
        return $this;
    }
    /**
     * Get Resultado value
     * @return int
     */
    public function getResultado()
    {
        return $this->Resultado;
    }
    /**
     * Set Resultado value
     * @param int $resultado
     * @return \StructType\DatosEstadoAdv
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: int
        if (!is_null($resultado) && !(is_int($resultado) || ctype_digit($resultado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultado, true), gettype($resultado)), __LINE__);
        }
        $this->Resultado = $resultado;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\DatosEstadoAdv
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get TipoDocumento value
     * @return string|null
     */
    public function getTipoDocumento()
    {
        return $this->TipoDocumento;
    }
    /**
     * Set TipoDocumento value
     * @param string $tipoDocumento
     * @return \StructType\DatosEstadoAdv
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumento) && !is_string($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumento, true), gettype($tipoDocumento)), __LINE__);
        }
        $this->TipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get RutReceptor value
     * @return string|null
     */
    public function getRutReceptor()
    {
        return $this->RutReceptor;
    }
    /**
     * Set RutReceptor value
     * @param string $rutReceptor
     * @return \StructType\DatosEstadoAdv
     */
    public function setRutReceptor($rutReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($rutReceptor) && !is_string($rutReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rutReceptor, true), gettype($rutReceptor)), __LINE__);
        }
        $this->RutReceptor = $rutReceptor;
        return $this;
    }
    /**
     * Get Folio value
     * @return string|null
     */
    public function getFolio()
    {
        return $this->Folio;
    }
    /**
     * Set Folio value
     * @param string $folio
     * @return \StructType\DatosEstadoAdv
     */
    public function setFolio($folio = null)
    {
        // validation for constraint: string
        if (!is_null($folio) && !is_string($folio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folio, true), gettype($folio)), __LINE__);
        }
        $this->Folio = $folio;
        return $this;
    }
    /**
     * Get Mensaje value
     * @return string|null
     */
    public function getMensaje()
    {
        return $this->Mensaje;
    }
    /**
     * Set Mensaje value
     * @param string $mensaje
     * @return \StructType\DatosEstadoAdv
     */
    public function setMensaje($mensaje = null)
    {
        // validation for constraint: string
        if (!is_null($mensaje) && !is_string($mensaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensaje, true), gettype($mensaje)), __LINE__);
        }
        $this->Mensaje = $mensaje;
        return $this;
    }
    /**
     * Get Trx value
     * @return string|null
     */
    public function getTrx()
    {
        return $this->Trx;
    }
    /**
     * Set Trx value
     * @param string $trx
     * @return \StructType\DatosEstadoAdv
     */
    public function setTrx($trx = null)
    {
        // validation for constraint: string
        if (!is_null($trx) && !is_string($trx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trx, true), gettype($trx)), __LINE__);
        }
        $this->Trx = $trx;
        return $this;
    }
    /**
     * Get CodigoSII value
     * @return string|null
     */
    public function getCodigoSII()
    {
        return $this->CodigoSII;
    }
    /**
     * Set CodigoSII value
     * @param string $codigoSII
     * @return \StructType\DatosEstadoAdv
     */
    public function setCodigoSII($codigoSII = null)
    {
        // validation for constraint: string
        if (!is_null($codigoSII) && !is_string($codigoSII)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoSII, true), gettype($codigoSII)), __LINE__);
        }
        $this->CodigoSII = $codigoSII;
        return $this;
    }
    /**
     * Get FechaEmision value
     * @return string|null
     */
    public function getFechaEmision()
    {
        return $this->FechaEmision;
    }
    /**
     * Set FechaEmision value
     * @param string $fechaEmision
     * @return \StructType\DatosEstadoAdv
     */
    public function setFechaEmision($fechaEmision = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmision) && !is_string($fechaEmision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmision, true), gettype($fechaEmision)), __LINE__);
        }
        $this->FechaEmision = $fechaEmision;
        return $this;
    }
    /**
     * Get Estado value
     * @return string|null
     */
    public function getEstado()
    {
        return $this->Estado;
    }
    /**
     * Set Estado value
     * @param string $estado
     * @return \StructType\DatosEstadoAdv
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estado, true), gettype($estado)), __LINE__);
        }
        $this->Estado = $estado;
        return $this;
    }
    /**
     * Get PDFBase64 value
     * @return string|null
     */
    public function getPDFBase64()
    {
        return $this->PDFBase64;
    }
    /**
     * Set PDFBase64 value
     * @param string $pDFBase64
     * @return \StructType\DatosEstadoAdv
     */
    public function setPDFBase64($pDFBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($pDFBase64) && !is_string($pDFBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDFBase64, true), gettype($pDFBase64)), __LINE__);
        }
        $this->PDFBase64 = $pDFBase64;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatosEstadoAdv
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
