<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://betaservicios.facturachile.cl/WSServicios.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://betaservicios.facturachile.cl/WSServicios.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Emision ServiceType
 */
$emision = new \ServiceType\Emision($options);
/**
 * Sample call for emisionDocumento operation/method
 */
if ($emision->emisionDocumento(new \StructType\EmisionDocumento()) !== false) {
    print_r($emision->getResult());
} else {
    print_r($emision->getLastError());
}
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \ServiceType\Consultar($options);
/**
 * Sample call for consultarEstado operation/method
 */
if ($consultar->consultarEstado(new \StructType\ConsultarEstado()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for consultarEstadoAdv operation/method
 */
if ($consultar->consultarEstadoAdv(new \StructType\ConsultarEstadoAdv()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
