<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosEmision StructType
 * @subpackage Structs
 */
class DatosEmision extends AbstractStructBase
{
    /**
     * The GenerarPDF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GenerarPDF;
    /**
     * The Resultado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Resultado;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Token;
    /**
     * The RutEmisor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RutEmisor;
    /**
     * The RutReceptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RutReceptor;
    /**
     * The TipoDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoDocumento;
    /**
     * The Documento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Documento;
    /**
     * The Folio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Folio;
    /**
     * The Identificador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Identificador;
    /**
     * The Mensaje
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mensaje;
    /**
     * The PDFBase64
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PDFBase64;
    /**
     * Constructor method for DatosEmision
     * @uses DatosEmision::setGenerarPDF()
     * @uses DatosEmision::setResultado()
     * @uses DatosEmision::setToken()
     * @uses DatosEmision::setRutEmisor()
     * @uses DatosEmision::setRutReceptor()
     * @uses DatosEmision::setTipoDocumento()
     * @uses DatosEmision::setDocumento()
     * @uses DatosEmision::setFolio()
     * @uses DatosEmision::setIdentificador()
     * @uses DatosEmision::setMensaje()
     * @uses DatosEmision::setPDFBase64()
     * @param bool $generarPDF
     * @param int $resultado
     * @param string $token
     * @param string $rutEmisor
     * @param string $rutReceptor
     * @param string $tipoDocumento
     * @param string $documento
     * @param string $folio
     * @param string $identificador
     * @param string $mensaje
     * @param string $pDFBase64
     */
    public function __construct($generarPDF = null, $resultado = null, $token = null, $rutEmisor = null, $rutReceptor = null, $tipoDocumento = null, $documento = null, $folio = null, $identificador = null, $mensaje = null, $pDFBase64 = null)
    {
        $this
            ->setGenerarPDF($generarPDF)
            ->setResultado($resultado)
            ->setToken($token)
            ->setRutEmisor($rutEmisor)
            ->setRutReceptor($rutReceptor)
            ->setTipoDocumento($tipoDocumento)
            ->setDocumento($documento)
            ->setFolio($folio)
            ->setIdentificador($identificador)
            ->setMensaje($mensaje)
            ->setPDFBase64($pDFBase64);
    }
    /**
     * Get GenerarPDF value
     * @return bool
     */
    public function getGenerarPDF()
    {
        return $this->GenerarPDF;
    }
    /**
     * Set GenerarPDF value
     * @param bool $generarPDF
     * @return \StructType\DatosEmision
     */
    public function setGenerarPDF($generarPDF = null)
    {
        // validation for constraint: boolean
        if (!is_null($generarPDF) && !is_bool($generarPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generarPDF, true), gettype($generarPDF)), __LINE__);
        }
        $this->GenerarPDF = $generarPDF;
        return $this;
    }
    /**
     * Get Resultado value
     * @return int
     */
    public function getResultado()
    {
        return $this->Resultado;
    }
    /**
     * Set Resultado value
     * @param int $resultado
     * @return \StructType\DatosEmision
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: int
        if (!is_null($resultado) && !(is_int($resultado) || ctype_digit($resultado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultado, true), gettype($resultado)), __LINE__);
        }
        $this->Resultado = $resultado;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\DatosEmision
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get RutEmisor value
     * @return string|null
     */
    public function getRutEmisor()
    {
        return $this->RutEmisor;
    }
    /**
     * Set RutEmisor value
     * @param string $rutEmisor
     * @return \StructType\DatosEmision
     */
    public function setRutEmisor($rutEmisor = null)
    {
        // validation for constraint: string
        if (!is_null($rutEmisor) && !is_string($rutEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rutEmisor, true), gettype($rutEmisor)), __LINE__);
        }
        $this->RutEmisor = $rutEmisor;
        return $this;
    }
    /**
     * Get RutReceptor value
     * @return string|null
     */
    public function getRutReceptor()
    {
        return $this->RutReceptor;
    }
    /**
     * Set RutReceptor value
     * @param string $rutReceptor
     * @return \StructType\DatosEmision
     */
    public function setRutReceptor($rutReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($rutReceptor) && !is_string($rutReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rutReceptor, true), gettype($rutReceptor)), __LINE__);
        }
        $this->RutReceptor = $rutReceptor;
        return $this;
    }
    /**
     * Get TipoDocumento value
     * @return string|null
     */
    public function getTipoDocumento()
    {
        return $this->TipoDocumento;
    }
    /**
     * Set TipoDocumento value
     * @param string $tipoDocumento
     * @return \StructType\DatosEmision
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumento) && !is_string($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumento, true), gettype($tipoDocumento)), __LINE__);
        }
        $this->TipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get Documento value
     * @return string|null
     */
    public function getDocumento()
    {
        return $this->Documento;
    }
    /**
     * Set Documento value
     * @param string $documento
     * @return \StructType\DatosEmision
     */
    public function setDocumento($documento = null)
    {
        // validation for constraint: string
        if (!is_null($documento) && !is_string($documento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documento, true), gettype($documento)), __LINE__);
        }
        $this->Documento = $documento;
        return $this;
    }
    /**
     * Get Folio value
     * @return string|null
     */
    public function getFolio()
    {
        return $this->Folio;
    }
    /**
     * Set Folio value
     * @param string $folio
     * @return \StructType\DatosEmision
     */
    public function setFolio($folio = null)
    {
        // validation for constraint: string
        if (!is_null($folio) && !is_string($folio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folio, true), gettype($folio)), __LINE__);
        }
        $this->Folio = $folio;
        return $this;
    }
    /**
     * Get Identificador value
     * @return string|null
     */
    public function getIdentificador()
    {
        return $this->Identificador;
    }
    /**
     * Set Identificador value
     * @param string $identificador
     * @return \StructType\DatosEmision
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: string
        if (!is_null($identificador) && !is_string($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificador, true), gettype($identificador)), __LINE__);
        }
        $this->Identificador = $identificador;
        return $this;
    }
    /**
     * Get Mensaje value
     * @return string|null
     */
    public function getMensaje()
    {
        return $this->Mensaje;
    }
    /**
     * Set Mensaje value
     * @param string $mensaje
     * @return \StructType\DatosEmision
     */
    public function setMensaje($mensaje = null)
    {
        // validation for constraint: string
        if (!is_null($mensaje) && !is_string($mensaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensaje, true), gettype($mensaje)), __LINE__);
        }
        $this->Mensaje = $mensaje;
        return $this;
    }
    /**
     * Get PDFBase64 value
     * @return string|null
     */
    public function getPDFBase64()
    {
        return $this->PDFBase64;
    }
    /**
     * Set PDFBase64 value
     * @param string $pDFBase64
     * @return \StructType\DatosEmision
     */
    public function setPDFBase64($pDFBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($pDFBase64) && !is_string($pDFBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDFBase64, true), gettype($pDFBase64)), __LINE__);
        }
        $this->PDFBase64 = $pDFBase64;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatosEmision
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
