<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emision ServiceType
 * @subpackage Services
 */
class Emision extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named emisionDocumento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmisionDocumento $parameters
     * @return \StructType\EmisionDocumentoResponse|bool
     */
    public function emisionDocumento(\StructType\EmisionDocumento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->emisionDocumento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EmisionDocumentoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
