<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://developer.ebay.com/webservices/latest/ebaySvc.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://developer.ebay.com/webservices/latest/ebaySvc.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \ebaySdk\ClassMap::get(),
);
/**
 * Samples for Service ServiceType
 */
$service = new \ebaySdk\ServiceType\Service($options);
$service->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for AddDispute operation/method
 */
if ($service->AddDispute(new \ebaySdk\StructType\AddDisputeRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddDisputeResponse operation/method
 */
if ($service->AddDisputeResponse(new \ebaySdk\StructType\AddDisputeResponseRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddFixedPriceItem operation/method
 */
if ($service->AddFixedPriceItem(new \ebaySdk\StructType\AddFixedPriceItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddItem operation/method
 */
if ($service->AddItem(new \ebaySdk\StructType\AddItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddItemFromSellingManagerTemplate operation/method
 */
if ($service->AddItemFromSellingManagerTemplate(new \ebaySdk\StructType\AddItemFromSellingManagerTemplateRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddItems operation/method
 */
if ($service->AddItems(new \ebaySdk\StructType\AddItemsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddMemberMessageAAQToPartner operation/method
 */
if ($service->AddMemberMessageAAQToPartner(new \ebaySdk\StructType\AddMemberMessageAAQToPartnerRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddMemberMessageRTQ operation/method
 */
if ($service->AddMemberMessageRTQ(new \ebaySdk\StructType\AddMemberMessageRTQRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddMemberMessagesAAQToBidder operation/method
 */
if ($service->AddMemberMessagesAAQToBidder(new \ebaySdk\StructType\AddMemberMessagesAAQToBidderRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddOrder operation/method
 */
if ($service->AddOrder(new \ebaySdk\StructType\AddOrderRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddSecondChanceItem operation/method
 */
if ($service->AddSecondChanceItem(new \ebaySdk\StructType\AddSecondChanceItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddSellingManagerInventoryFolder operation/method
 */
if ($service->AddSellingManagerInventoryFolder(new \ebaySdk\StructType\AddSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddSellingManagerProduct operation/method
 */
if ($service->AddSellingManagerProduct(new \ebaySdk\StructType\AddSellingManagerProductRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddSellingManagerTemplate operation/method
 */
if ($service->AddSellingManagerTemplate(new \ebaySdk\StructType\AddSellingManagerTemplateRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddToItemDescription operation/method
 */
if ($service->AddToItemDescription(new \ebaySdk\StructType\AddToItemDescriptionRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddToWatchList operation/method
 */
if ($service->AddToWatchList(new \ebaySdk\StructType\AddToWatchListRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddTransactionConfirmationItem operation/method
 */
if ($service->AddTransactionConfirmationItem(new \ebaySdk\StructType\AddTransactionConfirmationItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CompleteSale operation/method
 */
if ($service->CompleteSale(new \ebaySdk\StructType\CompleteSaleRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ConfirmIdentity operation/method
 */
if ($service->ConfirmIdentity(new \ebaySdk\StructType\ConfirmIdentityRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMyMessages operation/method
 */
if ($service->DeleteMyMessages(new \ebaySdk\StructType\DeleteMyMessagesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteSellingManagerInventoryFolder operation/method
 */
if ($service->DeleteSellingManagerInventoryFolder(new \ebaySdk\StructType\DeleteSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteSellingManagerItemAutomationRule operation/method
 */
if ($service->DeleteSellingManagerItemAutomationRule(new \ebaySdk\StructType\DeleteSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteSellingManagerProduct operation/method
 */
if ($service->DeleteSellingManagerProduct(new \ebaySdk\StructType\DeleteSellingManagerProductRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteSellingManagerTemplate operation/method
 */
if ($service->DeleteSellingManagerTemplate(new \ebaySdk\StructType\DeleteSellingManagerTemplateRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteSellingManagerTemplateAutomationRule operation/method
 */
if ($service->DeleteSellingManagerTemplateAutomationRule(new \ebaySdk\StructType\DeleteSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DisableUnpaidItemAssistance operation/method
 */
if ($service->DisableUnpaidItemAssistance(new \ebaySdk\StructType\DisableUnpaidItemAssistanceRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for EndFixedPriceItem operation/method
 */
if ($service->EndFixedPriceItem(new \ebaySdk\StructType\EndFixedPriceItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for EndItem operation/method
 */
if ($service->EndItem(new \ebaySdk\StructType\EndItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for EndItems operation/method
 */
if ($service->EndItems(new \ebaySdk\StructType\EndItemsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ExtendSiteHostedPictures operation/method
 */
if ($service->ExtendSiteHostedPictures(new \ebaySdk\StructType\ExtendSiteHostedPicturesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for FetchToken operation/method
 */
if ($service->FetchToken(new \ebaySdk\StructType\FetchTokenRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAccount operation/method
 */
if ($service->GetAccount(new \ebaySdk\StructType\GetAccountRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAdFormatLeads operation/method
 */
if ($service->GetAdFormatLeads(new \ebaySdk\StructType\GetAdFormatLeadsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAllBidders operation/method
 */
if ($service->GetAllBidders(new \ebaySdk\StructType\GetAllBiddersRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetApiAccessRules operation/method
 */
if ($service->GetApiAccessRules(new \ebaySdk\StructType\GetApiAccessRulesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetBestOffers operation/method
 */
if ($service->GetBestOffers(new \ebaySdk\StructType\GetBestOffersRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetBidderList operation/method
 */
if ($service->GetBidderList(new \ebaySdk\StructType\GetBidderListRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCategories operation/method
 */
if ($service->GetCategories(new \ebaySdk\StructType\GetCategoriesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCategoryFeatures operation/method
 */
if ($service->GetCategoryFeatures(new \ebaySdk\StructType\GetCategoryFeaturesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCategoryMappings operation/method
 */
if ($service->GetCategoryMappings(new \ebaySdk\StructType\GetCategoryMappingsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCategorySpecifics operation/method
 */
if ($service->GetCategorySpecifics(new \ebaySdk\StructType\GetCategorySpecificsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetChallengeToken operation/method
 */
if ($service->GetChallengeToken(new \ebaySdk\StructType\GetChallengeTokenRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCharities operation/method
 */
if ($service->GetCharities(new \ebaySdk\StructType\GetCharitiesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetClientAlertsAuthToken operation/method
 */
if ($service->GetClientAlertsAuthToken(new \ebaySdk\StructType\GetClientAlertsAuthTokenRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetContextualKeywords operation/method
 */
if ($service->GetContextualKeywords(new \ebaySdk\StructType\GetContextualKeywordsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDescriptionTemplates operation/method
 */
if ($service->GetDescriptionTemplates(new \ebaySdk\StructType\GetDescriptionTemplatesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDispute operation/method
 */
if ($service->GetDispute(new \ebaySdk\StructType\GetDisputeRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetFeedback operation/method
 */
if ($service->GetFeedback(new \ebaySdk\StructType\GetFeedbackRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetItem operation/method
 */
if ($service->GetItem(new \ebaySdk\StructType\GetItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetItemShipping operation/method
 */
if ($service->GetItemShipping(new \ebaySdk\StructType\GetItemShippingRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetItemTransactions operation/method
 */
if ($service->GetItemTransactions(new \ebaySdk\StructType\GetItemTransactionsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetItemsAwaitingFeedback operation/method
 */
if ($service->GetItemsAwaitingFeedback(new \ebaySdk\StructType\GetItemsAwaitingFeedbackRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMemberMessages operation/method
 */
if ($service->GetMemberMessages(new \ebaySdk\StructType\GetMemberMessagesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMessagePreferences operation/method
 */
if ($service->GetMessagePreferences(new \ebaySdk\StructType\GetMessagePreferencesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMyMessages operation/method
 */
if ($service->GetMyMessages(new \ebaySdk\StructType\GetMyMessagesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMyeBayBuying operation/method
 */
if ($service->GetMyeBayBuying(new \ebaySdk\StructType\GetMyeBayBuyingRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMyeBayReminders operation/method
 */
if ($service->GetMyeBayReminders(new \ebaySdk\StructType\GetMyeBayRemindersRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMyeBaySelling operation/method
 */
if ($service->GetMyeBaySelling(new \ebaySdk\StructType\GetMyeBaySellingRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetNotificationPreferences operation/method
 */
if ($service->GetNotificationPreferences(new \ebaySdk\StructType\GetNotificationPreferencesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetNotificationsUsage operation/method
 */
if ($service->GetNotificationsUsage(new \ebaySdk\StructType\GetNotificationsUsageRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetOrderTransactions operation/method
 */
if ($service->GetOrderTransactions(new \ebaySdk\StructType\GetOrderTransactionsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetOrders operation/method
 */
if ($service->GetOrders(new \ebaySdk\StructType\GetOrdersRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetPromotionalSaleDetails operation/method
 */
if ($service->GetPromotionalSaleDetails(new \ebaySdk\StructType\GetPromotionalSaleDetailsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellerDashboard operation/method
 */
if ($service->GetSellerDashboard(new \ebaySdk\StructType\GetSellerDashboardRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellerEvents operation/method
 */
if ($service->GetSellerEvents(new \ebaySdk\StructType\GetSellerEventsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellerList operation/method
 */
if ($service->GetSellerList(new \ebaySdk\StructType\GetSellerListRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellerTransactions operation/method
 */
if ($service->GetSellerTransactions(new \ebaySdk\StructType\GetSellerTransactionsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerAlerts operation/method
 */
if ($service->GetSellingManagerAlerts(new \ebaySdk\StructType\GetSellingManagerAlertsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerEmailLog operation/method
 */
if ($service->GetSellingManagerEmailLog(new \ebaySdk\StructType\GetSellingManagerEmailLogRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerInventory operation/method
 */
if ($service->GetSellingManagerInventory(new \ebaySdk\StructType\GetSellingManagerInventoryRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerInventoryFolder operation/method
 */
if ($service->GetSellingManagerInventoryFolder(new \ebaySdk\StructType\GetSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerItemAutomationRule operation/method
 */
if ($service->GetSellingManagerItemAutomationRule(new \ebaySdk\StructType\GetSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerSaleRecord operation/method
 */
if ($service->GetSellingManagerSaleRecord(new \ebaySdk\StructType\GetSellingManagerSaleRecordRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerSoldListings operation/method
 */
if ($service->GetSellingManagerSoldListings(new \ebaySdk\StructType\GetSellingManagerSoldListingsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerTemplateAutomationRule operation/method
 */
if ($service->GetSellingManagerTemplateAutomationRule(new \ebaySdk\StructType\GetSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSellingManagerTemplates operation/method
 */
if ($service->GetSellingManagerTemplates(new \ebaySdk\StructType\GetSellingManagerTemplatesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSessionID operation/method
 */
if ($service->GetSessionID(new \ebaySdk\StructType\GetSessionIDRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetShippingDiscountProfiles operation/method
 */
if ($service->GetShippingDiscountProfiles(new \ebaySdk\StructType\GetShippingDiscountProfilesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetStore operation/method
 */
if ($service->GetStore(new \ebaySdk\StructType\GetStoreRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetStoreCategoryUpdateStatus operation/method
 */
if ($service->GetStoreCategoryUpdateStatus(new \ebaySdk\StructType\GetStoreCategoryUpdateStatusRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetStoreCustomPage operation/method
 */
if ($service->GetStoreCustomPage(new \ebaySdk\StructType\GetStoreCustomPageRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetStoreOptions operation/method
 */
if ($service->GetStoreOptions(new \ebaySdk\StructType\GetStoreOptionsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetStorePreferences operation/method
 */
if ($service->GetStorePreferences(new \ebaySdk\StructType\GetStorePreferencesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSuggestedCategories operation/method
 */
if ($service->GetSuggestedCategories(new \ebaySdk\StructType\GetSuggestedCategoriesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetTaxTable operation/method
 */
if ($service->GetTaxTable(new \ebaySdk\StructType\GetTaxTableRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetTokenStatus operation/method
 */
if ($service->GetTokenStatus(new \ebaySdk\StructType\GetTokenStatusRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUser operation/method
 */
if ($service->GetUser(new \ebaySdk\StructType\GetUserRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserContactDetails operation/method
 */
if ($service->GetUserContactDetails(new \ebaySdk\StructType\GetUserContactDetailsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserDisputes operation/method
 */
if ($service->GetUserDisputes(new \ebaySdk\StructType\GetUserDisputesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserPreferences operation/method
 */
if ($service->GetUserPreferences(new \ebaySdk\StructType\GetUserPreferencesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetVeROReasonCodeDetails operation/method
 */
if ($service->GetVeROReasonCodeDetails(new \ebaySdk\StructType\GetVeROReasonCodeDetailsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetVeROReportStatus operation/method
 */
if ($service->GetVeROReportStatus(new \ebaySdk\StructType\GetVeROReportStatusRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GeteBayDetails operation/method
 */
if ($service->GeteBayDetails(new \ebaySdk\StructType\GeteBayDetailsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GeteBayOfficialTime operation/method
 */
if ($service->GeteBayOfficialTime(new \ebaySdk\StructType\GeteBayOfficialTimeRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for LeaveFeedback operation/method
 */
if ($service->LeaveFeedback(new \ebaySdk\StructType\LeaveFeedbackRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MoveSellingManagerInventoryFolder operation/method
 */
if ($service->MoveSellingManagerInventoryFolder(new \ebaySdk\StructType\MoveSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PlaceOffer operation/method
 */
if ($service->PlaceOffer(new \ebaySdk\StructType\PlaceOfferRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RelistFixedPriceItem operation/method
 */
if ($service->RelistFixedPriceItem(new \ebaySdk\StructType\RelistFixedPriceItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RelistItem operation/method
 */
if ($service->RelistItem(new \ebaySdk\StructType\RelistItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RemoveFromWatchList operation/method
 */
if ($service->RemoveFromWatchList(new \ebaySdk\StructType\RemoveFromWatchListRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RespondToBestOffer operation/method
 */
if ($service->RespondToBestOffer(new \ebaySdk\StructType\RespondToBestOfferRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RespondToFeedback operation/method
 */
if ($service->RespondToFeedback(new \ebaySdk\StructType\RespondToFeedbackRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseCheckoutStatus operation/method
 */
if ($service->ReviseCheckoutStatus(new \ebaySdk\StructType\ReviseCheckoutStatusRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseFixedPriceItem operation/method
 */
if ($service->ReviseFixedPriceItem(new \ebaySdk\StructType\ReviseFixedPriceItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseInventoryStatus operation/method
 */
if ($service->ReviseInventoryStatus(new \ebaySdk\StructType\ReviseInventoryStatusRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseItem operation/method
 */
if ($service->ReviseItem(new \ebaySdk\StructType\ReviseItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseMyMessages operation/method
 */
if ($service->ReviseMyMessages(new \ebaySdk\StructType\ReviseMyMessagesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseMyMessagesFolders operation/method
 */
if ($service->ReviseMyMessagesFolders(new \ebaySdk\StructType\ReviseMyMessagesFoldersRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseSellingManagerInventoryFolder operation/method
 */
if ($service->ReviseSellingManagerInventoryFolder(new \ebaySdk\StructType\ReviseSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseSellingManagerProduct operation/method
 */
if ($service->ReviseSellingManagerProduct(new \ebaySdk\StructType\ReviseSellingManagerProductRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseSellingManagerSaleRecord operation/method
 */
if ($service->ReviseSellingManagerSaleRecord(new \ebaySdk\StructType\ReviseSellingManagerSaleRecordRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ReviseSellingManagerTemplate operation/method
 */
if ($service->ReviseSellingManagerTemplate(new \ebaySdk\StructType\ReviseSellingManagerTemplateRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RevokeToken operation/method
 */
if ($service->RevokeToken(new \ebaySdk\StructType\RevokeTokenRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SaveItemToSellingManagerTemplate operation/method
 */
if ($service->SaveItemToSellingManagerTemplate(new \ebaySdk\StructType\SaveItemToSellingManagerTemplateRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SellerReverseDispute operation/method
 */
if ($service->SellerReverseDispute(new \ebaySdk\StructType\SellerReverseDisputeRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendInvoice operation/method
 */
if ($service->SendInvoice(new \ebaySdk\StructType\SendInvoiceRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetMessagePreferences operation/method
 */
if ($service->SetMessagePreferences(new \ebaySdk\StructType\SetMessagePreferencesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetNotificationPreferences operation/method
 */
if ($service->SetNotificationPreferences(new \ebaySdk\StructType\SetNotificationPreferencesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetPromotionalSale operation/method
 */
if ($service->SetPromotionalSale(new \ebaySdk\StructType\SetPromotionalSaleRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetPromotionalSaleListings operation/method
 */
if ($service->SetPromotionalSaleListings(new \ebaySdk\StructType\SetPromotionalSaleListingsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetSellingManagerFeedbackOptions operation/method
 */
if ($service->SetSellingManagerFeedbackOptions(new \ebaySdk\StructType\SetSellingManagerFeedbackOptionsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetSellingManagerItemAutomationRule operation/method
 */
if ($service->SetSellingManagerItemAutomationRule(new \ebaySdk\StructType\SetSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetSellingManagerTemplateAutomationRule operation/method
 */
if ($service->SetSellingManagerTemplateAutomationRule(new \ebaySdk\StructType\SetSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetShippingDiscountProfiles operation/method
 */
if ($service->SetShippingDiscountProfiles(new \ebaySdk\StructType\SetShippingDiscountProfilesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetStore operation/method
 */
if ($service->SetStore(new \ebaySdk\StructType\SetStoreRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetStoreCategories operation/method
 */
if ($service->SetStoreCategories(new \ebaySdk\StructType\SetStoreCategoriesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetStoreCustomPage operation/method
 */
if ($service->SetStoreCustomPage(new \ebaySdk\StructType\SetStoreCustomPageRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetStorePreferences operation/method
 */
if ($service->SetStorePreferences(new \ebaySdk\StructType\SetStorePreferencesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetTaxTable operation/method
 */
if ($service->SetTaxTable(new \ebaySdk\StructType\SetTaxTableRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetUserNotes operation/method
 */
if ($service->SetUserNotes(new \ebaySdk\StructType\SetUserNotesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetUserPreferences operation/method
 */
if ($service->SetUserPreferences(new \ebaySdk\StructType\SetUserPreferencesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadSiteHostedPictures operation/method
 */
if ($service->UploadSiteHostedPictures(new \ebaySdk\StructType\UploadSiteHostedPicturesRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ValidateChallengeInput operation/method
 */
if ($service->ValidateChallengeInput(new \ebaySdk\StructType\ValidateChallengeInputRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ValidateTestUserRegistration operation/method
 */
if ($service->ValidateTestUserRegistration(new \ebaySdk\StructType\ValidateTestUserRegistrationRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for VeROReportItems operation/method
 */
if ($service->VeROReportItems(new \ebaySdk\StructType\VeROReportItemsRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for VerifyAddFixedPriceItem operation/method
 */
if ($service->VerifyAddFixedPriceItem(new \ebaySdk\StructType\VerifyAddFixedPriceItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for VerifyAddItem operation/method
 */
if ($service->VerifyAddItem(new \ebaySdk\StructType\VerifyAddItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for VerifyAddSecondChanceItem operation/method
 */
if ($service->VerifyAddSecondChanceItem(new \ebaySdk\StructType\VerifyAddSecondChanceItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for VerifyRelistItem operation/method
 */
if ($service->VerifyRelistItem(new \ebaySdk\StructType\VerifyRelistItemRequestType()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
