<?php

namespace ebaySdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreSubscriptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type used by the Subscription container that is returned in GetStoreOptions to indicate the subscription level and monthly fee associated with the eBay Store.
 * @subpackage Structs
 */
class StoreSubscriptionType extends AbstractStructBase
{
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - documentation: Store subscription level.
     * - minOccurs: 0
     * @var string
     */
    public $Level;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - documentation: Monthly fee for the Store subscription level.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\AmountType
     */
    public $Fee;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for StoreSubscriptionType
     * @uses StoreSubscriptionType::setLevel()
     * @uses StoreSubscriptionType::setFee()
     * @uses StoreSubscriptionType::setAny()
     * @param string $level
     * @param \ebaySdk\StructType\AmountType $fee
     * @param \DOMDocument $any
     */
    public function __construct($level = null, \ebaySdk\StructType\AmountType $fee = null, \DOMDocument $any = null)
    {
        $this
            ->setLevel($level)
            ->setFee($fee)
            ->setAny($any);
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @uses \ebaySdk\EnumType\StoreSubscriptionLevelCodeType::valueIsValid()
     * @uses \ebaySdk\EnumType\StoreSubscriptionLevelCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \ebaySdk\StructType\StoreSubscriptionType
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\ebaySdk\EnumType\StoreSubscriptionLevelCodeType::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \ebaySdk\EnumType\StoreSubscriptionLevelCodeType', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \ebaySdk\EnumType\StoreSubscriptionLevelCodeType::getValidValues())), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get Fee value
     * @return \ebaySdk\StructType\AmountType|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param \ebaySdk\StructType\AmountType $fee
     * @return \ebaySdk\StructType\StoreSubscriptionType
     */
    public function setFee(\ebaySdk\StructType\AmountType $fee = null)
    {
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \ebaySdk\StructType\StoreSubscriptionType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebaySdk\StructType\StoreSubscriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
