<?php

namespace ebaySdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is deprecated.
 * @subpackage Structs
 */
class ProductInfoType extends AbstractStructBase
{
    /**
     * The AverageStartPrice
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\AmountType
     */
    public $AverageStartPrice;
    /**
     * The AverageSoldPrice
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\AmountType
     */
    public $AverageSoldPrice;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The ProductState
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $ProductState;
    /**
     * The productInfoID
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * @var string
     */
    public $productInfoID;
    /**
     * Constructor method for ProductInfoType
     * @uses ProductInfoType::setAverageStartPrice()
     * @uses ProductInfoType::setAverageSoldPrice()
     * @uses ProductInfoType::setTitle()
     * @uses ProductInfoType::setProductState()
     * @uses ProductInfoType::setProductInfoID()
     * @param \ebaySdk\StructType\AmountType $averageStartPrice
     * @param \ebaySdk\StructType\AmountType $averageSoldPrice
     * @param string $title
     * @param string $productState
     * @param string $productInfoID
     */
    public function __construct(\ebaySdk\StructType\AmountType $averageStartPrice = null, \ebaySdk\StructType\AmountType $averageSoldPrice = null, $title = null, $productState = null, $productInfoID = null)
    {
        $this
            ->setAverageStartPrice($averageStartPrice)
            ->setAverageSoldPrice($averageSoldPrice)
            ->setTitle($title)
            ->setProductState($productState)
            ->setProductInfoID($productInfoID);
    }
    /**
     * Get AverageStartPrice value
     * @return \ebaySdk\StructType\AmountType|null
     */
    public function getAverageStartPrice()
    {
        return $this->AverageStartPrice;
    }
    /**
     * Set AverageStartPrice value
     * @param \ebaySdk\StructType\AmountType $averageStartPrice
     * @return \ebaySdk\StructType\ProductInfoType
     */
    public function setAverageStartPrice(\ebaySdk\StructType\AmountType $averageStartPrice = null)
    {
        $this->AverageStartPrice = $averageStartPrice;
        return $this;
    }
    /**
     * Get AverageSoldPrice value
     * @return \ebaySdk\StructType\AmountType|null
     */
    public function getAverageSoldPrice()
    {
        return $this->AverageSoldPrice;
    }
    /**
     * Set AverageSoldPrice value
     * @param \ebaySdk\StructType\AmountType $averageSoldPrice
     * @return \ebaySdk\StructType\ProductInfoType
     */
    public function setAverageSoldPrice(\ebaySdk\StructType\AmountType $averageSoldPrice = null)
    {
        $this->AverageSoldPrice = $averageSoldPrice;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \ebaySdk\StructType\ProductInfoType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get ProductState value
     * @return string|null
     */
    public function getProductState()
    {
        return $this->ProductState;
    }
    /**
     * Set ProductState value
     * @uses \ebaySdk\EnumType\ProductStateCodeType::valueIsValid()
     * @uses \ebaySdk\EnumType\ProductStateCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productState
     * @return \ebaySdk\StructType\ProductInfoType
     */
    public function setProductState($productState = null)
    {
        // validation for constraint: enumeration
        if (!\ebaySdk\EnumType\ProductStateCodeType::valueIsValid($productState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \ebaySdk\EnumType\ProductStateCodeType', is_array($productState) ? implode(', ', $productState) : var_export($productState, true), implode(', ', \ebaySdk\EnumType\ProductStateCodeType::getValidValues())), __LINE__);
        }
        $this->ProductState = $productState;
        return $this;
    }
    /**
     * Get productInfoID value
     * @return string|null
     */
    public function getProductInfoID()
    {
        return $this->productInfoID;
    }
    /**
     * Set productInfoID value
     * @param string $productInfoID
     * @return \ebaySdk\StructType\ProductInfoType
     */
    public function setProductInfoID($productInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($productInfoID) && !is_string($productInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productInfoID, true), gettype($productInfoID)), __LINE__);
        }
        $this->productInfoID = $productInfoID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebaySdk\StructType\ProductInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
