<?php

namespace ebaySdk\EnumType;

/**
 * This class stands for TicketEventTypeCodeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: This enumerated type is deprecated.
 * @subpackage Enumerations
 */
class TicketEventTypeCodeType
{
    /**
     * Constant for value 'Any'
     * Meta information extracted from the WSDL
     * - documentation: (in) Any event (applicable to US, UK, and DE)
     * @return string 'Any'
     */
    const VALUE_ANY = 'Any';
    /**
     * Constant for value 'DE_ComedyAndKabarett'
     * Meta information extracted from the WSDL
     * - documentation: (in) Comedy & Kabarett (Comedy and Cabaret)
     * @return string 'DE_ComedyAndKabarett'
     */
    const VALUE_DE_COMEDY_AND_KABARETT = 'DE_ComedyAndKabarett';
    /**
     * Constant for value 'DE_FreizeitAndEvents'
     * Meta information extracted from the WSDL
     * - documentation: (in) Freizeit & Events (Leisure and Events)
     * @return string 'DE_FreizeitAndEvents'
     */
    const VALUE_DE_FREIZEIT_AND_EVENTS = 'DE_FreizeitAndEvents';
    /**
     * Constant for value 'DE_KonzerteAndFestivals'
     * Meta information extracted from the WSDL
     * - documentation: (in) Konzerte & Festivals (Concerts and Festivals)
     * @return string 'DE_KonzerteAndFestivals'
     */
    const VALUE_DE_KONZERTE_AND_FESTIVALS = 'DE_KonzerteAndFestivals';
    /**
     * Constant for value 'DE_KulturAndKlassik'
     * Meta information extracted from the WSDL
     * - documentation: (in) Kultur & Klassik (Culture and Classical)
     * @return string 'DE_KulturAndKlassik'
     */
    const VALUE_DE_KULTUR_AND_KLASSIK = 'DE_KulturAndKlassik';
    /**
     * Constant for value 'DE_MusicalsAndShows'
     * Meta information extracted from the WSDL
     * - documentation: (in) Musicals & Shows
     * @return string 'DE_MusicalsAndShows'
     */
    const VALUE_DE_MUSICALS_AND_SHOWS = 'DE_MusicalsAndShows';
    /**
     * Constant for value 'DE_Sportveranstaltungen'
     * Meta information extracted from the WSDL
     * - documentation: (in) Sportveranstaltungen (Sporting Events)
     * @return string 'DE_Sportveranstaltungen'
     */
    const VALUE_DE_SPORTVERANSTALTUNGEN = 'DE_Sportveranstaltungen';
    /**
     * Constant for value 'DE_Sonstige'
     * Meta information extracted from the WSDL
     * - documentation: (in) Other events that are not the above Germany event types (applicable to listings on the DE site)
     * @return string 'DE_Sonstige'
     */
    const VALUE_DE_SONSTIGE = 'DE_Sonstige';
    /**
     * Constant for value 'UK_AmusementParks'
     * Meta information extracted from the WSDL
     * - documentation: (in) Amusement Parks (applicable to listings on the UK site)
     * @return string 'UK_AmusementParks'
     */
    const VALUE_UK_AMUSEMENT_PARKS = 'UK_AmusementParks';
    /**
     * Constant for value 'UK_Comedy'
     * Meta information extracted from the WSDL
     * - documentation: (in) Comedy (applicable to listings on the UK site)
     * @return string 'UK_Comedy'
     */
    const VALUE_UK_COMEDY = 'UK_Comedy';
    /**
     * Constant for value 'UK_ConcertsAndGigs'
     * Meta information extracted from the WSDL
     * - documentation: (in) Concerts/Gigs (applicable to listings on the UK site)
     * @return string 'UK_ConcertsAndGigs'
     */
    const VALUE_UK_CONCERTS_AND_GIGS = 'UK_ConcertsAndGigs';
    /**
     * Constant for value 'UK_ConferencesAndSeminars'
     * Meta information extracted from the WSDL
     * - documentation: (in) Conferences/Seminars (applicable to listings on the UK site)
     * @return string 'UK_ConferencesAndSeminars'
     */
    const VALUE_UK_CONFERENCES_AND_SEMINARS = 'UK_ConferencesAndSeminars';
    /**
     * Constant for value 'UK_ExhibitionsAndShows'
     * Meta information extracted from the WSDL
     * - documentation: (in) Exhibitions/Shows (applicable to listings on the UK site)
     * @return string 'UK_ExhibitionsAndShows'
     */
    const VALUE_UK_EXHIBITIONS_AND_SHOWS = 'UK_ExhibitionsAndShows';
    /**
     * Constant for value 'UK_Experiences'
     * Meta information extracted from the WSDL
     * - documentation: (in) Experiences (applicable to listings on the UK site)
     * @return string 'UK_Experiences'
     */
    const VALUE_UK_EXPERIENCES = 'UK_Experiences';
    /**
     * Constant for value 'UK_SportingEvents'
     * Meta information extracted from the WSDL
     * - documentation: (in) Sporting events (applicable to listings on the UK site)
     * @return string 'UK_SportingEvents'
     */
    const VALUE_UK_SPORTING_EVENTS = 'UK_SportingEvents';
    /**
     * Constant for value 'UK_TheatreCinemaAndCircus'
     * Meta information extracted from the WSDL
     * - documentation: (in) Theatre/Cinema/Circus (applicable to listings on the UK site)
     * @return string 'UK_TheatreCinemaAndCircus'
     */
    const VALUE_UK_THEATRE_CINEMA_AND_CIRCUS = 'UK_TheatreCinemaAndCircus';
    /**
     * Constant for value 'UK_Other'
     * Meta information extracted from the WSDL
     * - documentation: (in) Other. Events that are not the above UK types (applicable to listings on the UK site)
     * @return string 'UK_Other'
     */
    const VALUE_UK_OTHER = 'UK_Other';
    /**
     * Constant for value 'US_Concerts'
     * Meta information extracted from the WSDL
     * - documentation: (in) Concerts (applicable to listings on the US site)
     * @return string 'US_Concerts'
     */
    const VALUE_US_CONCERTS = 'US_Concerts';
    /**
     * Constant for value 'US_Movies'
     * Meta information extracted from the WSDL
     * - documentation: (in) Movies (applicable to listings on the US site)
     * @return string 'US_Movies'
     */
    const VALUE_US_MOVIES = 'US_Movies';
    /**
     * Constant for value 'US_SportingEvents'
     * Meta information extracted from the WSDL
     * - documentation: (in) Sporting events (applicable to listings on the US site)
     * @return string 'US_SportingEvents'
     */
    const VALUE_US_SPORTING_EVENTS = 'US_SportingEvents';
    /**
     * Constant for value 'US_Theater'
     * Meta information extracted from the WSDL
     * - documentation: (in) Theater (applicable to listings on the US site)
     * @return string 'US_Theater'
     */
    const VALUE_US_THEATER = 'US_Theater';
    /**
     * Constant for value 'US_Other'
     * Meta information extracted from the WSDL
     * - documentation: (in) Events that are not concerts, movies, sporting events, or theater events (applicable to listings on the US site)
     * @return string 'US_Other'
     */
    const VALUE_US_OTHER = 'US_Other';
    /**
     * Constant for value 'CustomCode'
     * Meta information extracted from the WSDL
     * - documentation: Reserved for internal or future use.
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANY
     * @uses self::VALUE_DE_COMEDY_AND_KABARETT
     * @uses self::VALUE_DE_FREIZEIT_AND_EVENTS
     * @uses self::VALUE_DE_KONZERTE_AND_FESTIVALS
     * @uses self::VALUE_DE_KULTUR_AND_KLASSIK
     * @uses self::VALUE_DE_MUSICALS_AND_SHOWS
     * @uses self::VALUE_DE_SPORTVERANSTALTUNGEN
     * @uses self::VALUE_DE_SONSTIGE
     * @uses self::VALUE_UK_AMUSEMENT_PARKS
     * @uses self::VALUE_UK_COMEDY
     * @uses self::VALUE_UK_CONCERTS_AND_GIGS
     * @uses self::VALUE_UK_CONFERENCES_AND_SEMINARS
     * @uses self::VALUE_UK_EXHIBITIONS_AND_SHOWS
     * @uses self::VALUE_UK_EXPERIENCES
     * @uses self::VALUE_UK_SPORTING_EVENTS
     * @uses self::VALUE_UK_THEATRE_CINEMA_AND_CIRCUS
     * @uses self::VALUE_UK_OTHER
     * @uses self::VALUE_US_CONCERTS
     * @uses self::VALUE_US_MOVIES
     * @uses self::VALUE_US_SPORTING_EVENTS
     * @uses self::VALUE_US_THEATER
     * @uses self::VALUE_US_OTHER
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANY,
            self::VALUE_DE_COMEDY_AND_KABARETT,
            self::VALUE_DE_FREIZEIT_AND_EVENTS,
            self::VALUE_DE_KONZERTE_AND_FESTIVALS,
            self::VALUE_DE_KULTUR_AND_KLASSIK,
            self::VALUE_DE_MUSICALS_AND_SHOWS,
            self::VALUE_DE_SPORTVERANSTALTUNGEN,
            self::VALUE_DE_SONSTIGE,
            self::VALUE_UK_AMUSEMENT_PARKS,
            self::VALUE_UK_COMEDY,
            self::VALUE_UK_CONCERTS_AND_GIGS,
            self::VALUE_UK_CONFERENCES_AND_SEMINARS,
            self::VALUE_UK_EXHIBITIONS_AND_SHOWS,
            self::VALUE_UK_EXPERIENCES,
            self::VALUE_UK_SPORTING_EVENTS,
            self::VALUE_UK_THEATRE_CINEMA_AND_CIRCUS,
            self::VALUE_UK_OTHER,
            self::VALUE_US_CONCERTS,
            self::VALUE_US_MOVIES,
            self::VALUE_US_SPORTING_EVENTS,
            self::VALUE_US_THEATER,
            self::VALUE_US_OTHER,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
