<?php

namespace ebaySdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellingManagerProductType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes a Selling Manager Product
 * @subpackage Structs
 */
class SellingManagerProductType extends AbstractStructBase
{
    /**
     * The SellingManagerProductDetails
     * Meta information extracted from the WSDL
     * - documentation: Container for information about the product.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\SellingManagerProductDetailsType
     */
    public $SellingManagerProductDetails;
    /**
     * The SellingManagerTemplateDetailsArray
     * Meta information extracted from the WSDL
     * - documentation: Contains the list of the seller's templates contained in the product, one SellingManagerTemplateType object per template.
     * - minOccurs: 0
     * @var \ebaySdk\ArrayType\SellingManagerTemplateDetailsArrayType
     */
    public $SellingManagerTemplateDetailsArray;
    /**
     * The SellingManagerProductInventoryStatus
     * Meta information extracted from the WSDL
     * - documentation: Container for statistics about the product.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\SellingManagerProductInventoryStatusType
     */
    public $SellingManagerProductInventoryStatus;
    /**
     * The SellingManagerProductSpecifics
     * Meta information extracted from the WSDL
     * - documentation: Specifies an eBay category associated with the product, defines Item Specifics that are relevant to the product, and defines variations available for the product (which may be used to create multivariation listings).
     * - minOccurs: 0
     * @var \ebaySdk\StructType\SellingManagerProductSpecificsType
     */
    public $SellingManagerProductSpecifics;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for SellingManagerProductType
     * @uses SellingManagerProductType::setSellingManagerProductDetails()
     * @uses SellingManagerProductType::setSellingManagerTemplateDetailsArray()
     * @uses SellingManagerProductType::setSellingManagerProductInventoryStatus()
     * @uses SellingManagerProductType::setSellingManagerProductSpecifics()
     * @uses SellingManagerProductType::setAny()
     * @param \ebaySdk\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails
     * @param \ebaySdk\ArrayType\SellingManagerTemplateDetailsArrayType $sellingManagerTemplateDetailsArray
     * @param \ebaySdk\StructType\SellingManagerProductInventoryStatusType $sellingManagerProductInventoryStatus
     * @param \ebaySdk\StructType\SellingManagerProductSpecificsType $sellingManagerProductSpecifics
     * @param \DOMDocument $any
     */
    public function __construct(\ebaySdk\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails = null, \ebaySdk\ArrayType\SellingManagerTemplateDetailsArrayType $sellingManagerTemplateDetailsArray = null, \ebaySdk\StructType\SellingManagerProductInventoryStatusType $sellingManagerProductInventoryStatus = null, \ebaySdk\StructType\SellingManagerProductSpecificsType $sellingManagerProductSpecifics = null, \DOMDocument $any = null)
    {
        $this
            ->setSellingManagerProductDetails($sellingManagerProductDetails)
            ->setSellingManagerTemplateDetailsArray($sellingManagerTemplateDetailsArray)
            ->setSellingManagerProductInventoryStatus($sellingManagerProductInventoryStatus)
            ->setSellingManagerProductSpecifics($sellingManagerProductSpecifics)
            ->setAny($any);
    }
    /**
     * Get SellingManagerProductDetails value
     * @return \ebaySdk\StructType\SellingManagerProductDetailsType|null
     */
    public function getSellingManagerProductDetails()
    {
        return $this->SellingManagerProductDetails;
    }
    /**
     * Set SellingManagerProductDetails value
     * @param \ebaySdk\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails
     * @return \ebaySdk\StructType\SellingManagerProductType
     */
    public function setSellingManagerProductDetails(\ebaySdk\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails = null)
    {
        $this->SellingManagerProductDetails = $sellingManagerProductDetails;
        return $this;
    }
    /**
     * Get SellingManagerTemplateDetailsArray value
     * @return \ebaySdk\ArrayType\SellingManagerTemplateDetailsArrayType|null
     */
    public function getSellingManagerTemplateDetailsArray()
    {
        return $this->SellingManagerTemplateDetailsArray;
    }
    /**
     * Set SellingManagerTemplateDetailsArray value
     * @param \ebaySdk\ArrayType\SellingManagerTemplateDetailsArrayType $sellingManagerTemplateDetailsArray
     * @return \ebaySdk\StructType\SellingManagerProductType
     */
    public function setSellingManagerTemplateDetailsArray(\ebaySdk\ArrayType\SellingManagerTemplateDetailsArrayType $sellingManagerTemplateDetailsArray = null)
    {
        $this->SellingManagerTemplateDetailsArray = $sellingManagerTemplateDetailsArray;
        return $this;
    }
    /**
     * Get SellingManagerProductInventoryStatus value
     * @return \ebaySdk\StructType\SellingManagerProductInventoryStatusType|null
     */
    public function getSellingManagerProductInventoryStatus()
    {
        return $this->SellingManagerProductInventoryStatus;
    }
    /**
     * Set SellingManagerProductInventoryStatus value
     * @param \ebaySdk\StructType\SellingManagerProductInventoryStatusType $sellingManagerProductInventoryStatus
     * @return \ebaySdk\StructType\SellingManagerProductType
     */
    public function setSellingManagerProductInventoryStatus(\ebaySdk\StructType\SellingManagerProductInventoryStatusType $sellingManagerProductInventoryStatus = null)
    {
        $this->SellingManagerProductInventoryStatus = $sellingManagerProductInventoryStatus;
        return $this;
    }
    /**
     * Get SellingManagerProductSpecifics value
     * @return \ebaySdk\StructType\SellingManagerProductSpecificsType|null
     */
    public function getSellingManagerProductSpecifics()
    {
        return $this->SellingManagerProductSpecifics;
    }
    /**
     * Set SellingManagerProductSpecifics value
     * @param \ebaySdk\StructType\SellingManagerProductSpecificsType $sellingManagerProductSpecifics
     * @return \ebaySdk\StructType\SellingManagerProductType
     */
    public function setSellingManagerProductSpecifics(\ebaySdk\StructType\SellingManagerProductSpecificsType $sellingManagerProductSpecifics = null)
    {
        $this->SellingManagerProductSpecifics = $sellingManagerProductSpecifics;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \ebaySdk\StructType\SellingManagerProductType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebaySdk\StructType\SellingManagerProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
