<?php

namespace ebaySdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellingManagerEmailLogResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Returns the log of emails not sent.
 * @subpackage Structs
 */
class GetSellingManagerEmailLogResponseType extends AbstractResponseType
{
    /**
     * The EmailLog
     * Meta information extracted from the WSDL
     * - documentation: Email logs associated with this order.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebaySdk\StructType\SellingManagerEmailLogType[]
     */
    public $EmailLog;
    /**
     * Constructor method for GetSellingManagerEmailLogResponseType
     * @uses GetSellingManagerEmailLogResponseType::setEmailLog()
     * @param \ebaySdk\StructType\SellingManagerEmailLogType[] $emailLog
     */
    public function __construct(array $emailLog = array())
    {
        $this
            ->setEmailLog($emailLog);
    }
    /**
     * Get EmailLog value
     * @return \ebaySdk\StructType\SellingManagerEmailLogType[]|null
     */
    public function getEmailLog()
    {
        return $this->EmailLog;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailLog method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailLog method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailLogForArrayConstraintsFromSetEmailLog(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getSellingManagerEmailLogResponseTypeEmailLogItem) {
            // validation for constraint: itemType
            if (!$getSellingManagerEmailLogResponseTypeEmailLogItem instanceof \ebaySdk\StructType\SellingManagerEmailLogType) {
                $invalidValues[] = is_object($getSellingManagerEmailLogResponseTypeEmailLogItem) ? get_class($getSellingManagerEmailLogResponseTypeEmailLogItem) : sprintf('%s(%s)', gettype($getSellingManagerEmailLogResponseTypeEmailLogItem), var_export($getSellingManagerEmailLogResponseTypeEmailLogItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailLog property can only contain items of type \ebaySdk\StructType\SellingManagerEmailLogType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailLog value
     * @throws \InvalidArgumentException
     * @param \ebaySdk\StructType\SellingManagerEmailLogType[] $emailLog
     * @return \ebaySdk\StructType\GetSellingManagerEmailLogResponseType
     */
    public function setEmailLog(array $emailLog = array())
    {
        // validation for constraint: array
        if ('' !== ($emailLogArrayErrorMessage = self::validateEmailLogForArrayConstraintsFromSetEmailLog($emailLog))) {
            throw new \InvalidArgumentException($emailLogArrayErrorMessage, __LINE__);
        }
        $this->EmailLog = $emailLog;
        return $this;
    }
    /**
     * Add item to EmailLog value
     * @throws \InvalidArgumentException
     * @param \ebaySdk\StructType\SellingManagerEmailLogType $item
     * @return \ebaySdk\StructType\GetSellingManagerEmailLogResponseType
     */
    public function addToEmailLog(\ebaySdk\StructType\SellingManagerEmailLogType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebaySdk\StructType\SellingManagerEmailLogType) {
            throw new \InvalidArgumentException(sprintf('The EmailLog property can only contain items of type \ebaySdk\StructType\SellingManagerEmailLogType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmailLog[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebaySdk\StructType\GetSellingManagerEmailLogResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
