<?php

namespace ebaySdk\EnumType;

/**
 * This class stands for CountryCodeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: This enumerated type contains a partial list of ISO 3166 standard two-letter codes that represent countries around the world. <br><br> It is recommended that users use the <b>GeteBayDetails</b> call to see the full list of currently
 * supported country codes, and the English names associated with each code (e.g., KY="Cayman Islands"). Call <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>Country</b>, and then look for <b>CountryDetails.Country</b> fields in the response.
 * @subpackage Enumerations
 */
class CountryCodeType
{
    /**
     * Constant for value 'AF'
     * Meta information extracted from the WSDL
     * - documentation: Afghanistan.
     * @return string 'AF'
     */
    const VALUE_AF = 'AF';
    /**
     * Constant for value 'AL'
     * Meta information extracted from the WSDL
     * - documentation: Albania.
     * @return string 'AL'
     */
    const VALUE_AL = 'AL';
    /**
     * Constant for value 'DZ'
     * Meta information extracted from the WSDL
     * - documentation: Algeria.
     * @return string 'DZ'
     */
    const VALUE_DZ = 'DZ';
    /**
     * Constant for value 'AS'
     * Meta information extracted from the WSDL
     * - documentation: American Samoa.
     * @return string 'AS'
     */
    const VALUE_AS = 'AS';
    /**
     * Constant for value 'AD'
     * Meta information extracted from the WSDL
     * - documentation: Andorra.
     * @return string 'AD'
     */
    const VALUE_AD = 'AD';
    /**
     * Constant for value 'AO'
     * Meta information extracted from the WSDL
     * - documentation: Angola.
     * @return string 'AO'
     */
    const VALUE_AO = 'AO';
    /**
     * Constant for value 'AI'
     * Meta information extracted from the WSDL
     * - documentation: Anguilla.
     * @return string 'AI'
     */
    const VALUE_AI = 'AI';
    /**
     * Constant for value 'AQ'
     * Meta information extracted from the WSDL
     * - documentation: Antarctica.
     * @return string 'AQ'
     */
    const VALUE_AQ = 'AQ';
    /**
     * Constant for value 'AG'
     * Meta information extracted from the WSDL
     * - documentation: Antigua and Barbuda.
     * @return string 'AG'
     */
    const VALUE_AG = 'AG';
    /**
     * Constant for value 'AR'
     * Meta information extracted from the WSDL
     * - documentation: Argentina.
     * @return string 'AR'
     */
    const VALUE_AR = 'AR';
    /**
     * Constant for value 'AM'
     * Meta information extracted from the WSDL
     * - documentation: Armenia.
     * @return string 'AM'
     */
    const VALUE_AM = 'AM';
    /**
     * Constant for value 'AW'
     * Meta information extracted from the WSDL
     * - documentation: Aruba.
     * @return string 'AW'
     */
    const VALUE_AW = 'AW';
    /**
     * Constant for value 'AU'
     * Meta information extracted from the WSDL
     * - documentation: Australia.
     * @return string 'AU'
     */
    const VALUE_AU = 'AU';
    /**
     * Constant for value 'AT'
     * Meta information extracted from the WSDL
     * - documentation: Austria.
     * @return string 'AT'
     */
    const VALUE_AT = 'AT';
    /**
     * Constant for value 'AZ'
     * Meta information extracted from the WSDL
     * - documentation: Azerbaijan.
     * @return string 'AZ'
     */
    const VALUE_AZ = 'AZ';
    /**
     * Constant for value 'BS'
     * Meta information extracted from the WSDL
     * - documentation: Bahamas.
     * @return string 'BS'
     */
    const VALUE_BS = 'BS';
    /**
     * Constant for value 'BH'
     * Meta information extracted from the WSDL
     * - documentation: Bahrain.
     * @return string 'BH'
     */
    const VALUE_BH = 'BH';
    /**
     * Constant for value 'BD'
     * Meta information extracted from the WSDL
     * - documentation: Bangladesh.
     * @return string 'BD'
     */
    const VALUE_BD = 'BD';
    /**
     * Constant for value 'BB'
     * Meta information extracted from the WSDL
     * - documentation: Barbados.
     * @return string 'BB'
     */
    const VALUE_BB = 'BB';
    /**
     * Constant for value 'BY'
     * Meta information extracted from the WSDL
     * - documentation: Belarus.
     * @return string 'BY'
     */
    const VALUE_BY = 'BY';
    /**
     * Constant for value 'BE'
     * Meta information extracted from the WSDL
     * - documentation: Belgium.
     * @return string 'BE'
     */
    const VALUE_BE = 'BE';
    /**
     * Constant for value 'BZ'
     * Meta information extracted from the WSDL
     * - documentation: Belize.
     * @return string 'BZ'
     */
    const VALUE_BZ = 'BZ';
    /**
     * Constant for value 'BJ'
     * Meta information extracted from the WSDL
     * - documentation: Benin.
     * @return string 'BJ'
     */
    const VALUE_BJ = 'BJ';
    /**
     * Constant for value 'BM'
     * Meta information extracted from the WSDL
     * - documentation: Bermuda.
     * @return string 'BM'
     */
    const VALUE_BM = 'BM';
    /**
     * Constant for value 'BT'
     * Meta information extracted from the WSDL
     * - documentation: Bhutan.
     * @return string 'BT'
     */
    const VALUE_BT = 'BT';
    /**
     * Constant for value 'BO'
     * Meta information extracted from the WSDL
     * - documentation: Bolivia.
     * @return string 'BO'
     */
    const VALUE_BO = 'BO';
    /**
     * Constant for value 'BA'
     * Meta information extracted from the WSDL
     * - documentation: Bosnia and Herzegovina.
     * @return string 'BA'
     */
    const VALUE_BA = 'BA';
    /**
     * Constant for value 'BW'
     * Meta information extracted from the WSDL
     * - documentation: Botswana.
     * @return string 'BW'
     */
    const VALUE_BW = 'BW';
    /**
     * Constant for value 'BV'
     * Meta information extracted from the WSDL
     * - documentation: Bouvet Island.
     * @return string 'BV'
     */
    const VALUE_BV = 'BV';
    /**
     * Constant for value 'BR'
     * Meta information extracted from the WSDL
     * - documentation: Brazil.
     * @return string 'BR'
     */
    const VALUE_BR = 'BR';
    /**
     * Constant for value 'IO'
     * Meta information extracted from the WSDL
     * - documentation: British Indian Ocean Territory.
     * @return string 'IO'
     */
    const VALUE_IO = 'IO';
    /**
     * Constant for value 'BN'
     * Meta information extracted from the WSDL
     * - documentation: Brunei Darussalam.
     * @return string 'BN'
     */
    const VALUE_BN = 'BN';
    /**
     * Constant for value 'BG'
     * Meta information extracted from the WSDL
     * - documentation: Bulgaria.
     * @return string 'BG'
     */
    const VALUE_BG = 'BG';
    /**
     * Constant for value 'BF'
     * Meta information extracted from the WSDL
     * - documentation: Burkina Faso.
     * @return string 'BF'
     */
    const VALUE_BF = 'BF';
    /**
     * Constant for value 'BI'
     * Meta information extracted from the WSDL
     * - documentation: Burundi.
     * @return string 'BI'
     */
    const VALUE_BI = 'BI';
    /**
     * Constant for value 'KH'
     * Meta information extracted from the WSDL
     * - documentation: Cambodia.
     * @return string 'KH'
     */
    const VALUE_KH = 'KH';
    /**
     * Constant for value 'CM'
     * Meta information extracted from the WSDL
     * - documentation: Cameroon.
     * @return string 'CM'
     */
    const VALUE_CM = 'CM';
    /**
     * Constant for value 'CA'
     * Meta information extracted from the WSDL
     * - documentation: Canada.
     * @return string 'CA'
     */
    const VALUE_CA = 'CA';
    /**
     * Constant for value 'CV'
     * Meta information extracted from the WSDL
     * - documentation: Cape Verde.
     * @return string 'CV'
     */
    const VALUE_CV = 'CV';
    /**
     * Constant for value 'KY'
     * Meta information extracted from the WSDL
     * - documentation: Cayman Islands.
     * @return string 'KY'
     */
    const VALUE_KY = 'KY';
    /**
     * Constant for value 'CF'
     * Meta information extracted from the WSDL
     * - documentation: Central African Republic.
     * @return string 'CF'
     */
    const VALUE_CF = 'CF';
    /**
     * Constant for value 'TD'
     * Meta information extracted from the WSDL
     * - documentation: Chad.
     * @return string 'TD'
     */
    const VALUE_TD = 'TD';
    /**
     * Constant for value 'CL'
     * Meta information extracted from the WSDL
     * - documentation: Chile.
     * @return string 'CL'
     */
    const VALUE_CL = 'CL';
    /**
     * Constant for value 'CN'
     * Meta information extracted from the WSDL
     * - documentation: China.
     * @return string 'CN'
     */
    const VALUE_CN = 'CN';
    /**
     * Constant for value 'CX'
     * Meta information extracted from the WSDL
     * - documentation: Christmas Island.
     * @return string 'CX'
     */
    const VALUE_CX = 'CX';
    /**
     * Constant for value 'CC'
     * Meta information extracted from the WSDL
     * - documentation: Cocos (Keeling) Islands.
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Constant for value 'CO'
     * Meta information extracted from the WSDL
     * - documentation: Colombia.
     * @return string 'CO'
     */
    const VALUE_CO = 'CO';
    /**
     * Constant for value 'KM'
     * Meta information extracted from the WSDL
     * - documentation: Comoros.
     * @return string 'KM'
     */
    const VALUE_KM = 'KM';
    /**
     * Constant for value 'CG'
     * Meta information extracted from the WSDL
     * - documentation: Congo.
     * @return string 'CG'
     */
    const VALUE_CG = 'CG';
    /**
     * Constant for value 'CD'
     * Meta information extracted from the WSDL
     * - documentation: Congo, The Democratic Republic of the.
     * @return string 'CD'
     */
    const VALUE_CD = 'CD';
    /**
     * Constant for value 'CK'
     * Meta information extracted from the WSDL
     * - documentation: Cook Islands.
     * @return string 'CK'
     */
    const VALUE_CK = 'CK';
    /**
     * Constant for value 'CR'
     * Meta information extracted from the WSDL
     * - documentation: Costa Rica.
     * @return string 'CR'
     */
    const VALUE_CR = 'CR';
    /**
     * Constant for value 'CI'
     * Meta information extracted from the WSDL
     * - documentation: Cote d'Ivoire.
     * @return string 'CI'
     */
    const VALUE_CI = 'CI';
    /**
     * Constant for value 'HR'
     * Meta information extracted from the WSDL
     * - documentation: Croatia.
     * @return string 'HR'
     */
    const VALUE_HR = 'HR';
    /**
     * Constant for value 'CU'
     * Meta information extracted from the WSDL
     * - documentation: Cuba.
     * @return string 'CU'
     */
    const VALUE_CU = 'CU';
    /**
     * Constant for value 'CY'
     * Meta information extracted from the WSDL
     * - documentation: Cyprus.
     * @return string 'CY'
     */
    const VALUE_CY = 'CY';
    /**
     * Constant for value 'CZ'
     * Meta information extracted from the WSDL
     * - documentation: Czech Republic.
     * @return string 'CZ'
     */
    const VALUE_CZ = 'CZ';
    /**
     * Constant for value 'DK'
     * Meta information extracted from the WSDL
     * - documentation: Denmark.
     * @return string 'DK'
     */
    const VALUE_DK = 'DK';
    /**
     * Constant for value 'DJ'
     * Meta information extracted from the WSDL
     * - documentation: Djibouti.
     * @return string 'DJ'
     */
    const VALUE_DJ = 'DJ';
    /**
     * Constant for value 'DM'
     * Meta information extracted from the WSDL
     * - documentation: Dominica.
     * @return string 'DM'
     */
    const VALUE_DM = 'DM';
    /**
     * Constant for value 'DO'
     * Meta information extracted from the WSDL
     * - documentation: Dominican Republic.
     * @return string 'DO'
     */
    const VALUE_DO = 'DO';
    /**
     * Constant for value 'TP'
     * Meta information extracted from the WSDL
     * - documentation: No longer in use.
     * @return string 'TP'
     */
    const VALUE_TP = 'TP';
    /**
     * Constant for value 'EC'
     * Meta information extracted from the WSDL
     * - documentation: Ecuador.
     * @return string 'EC'
     */
    const VALUE_EC = 'EC';
    /**
     * Constant for value 'EG'
     * Meta information extracted from the WSDL
     * - documentation: Egypt.
     * @return string 'EG'
     */
    const VALUE_EG = 'EG';
    /**
     * Constant for value 'SV'
     * Meta information extracted from the WSDL
     * - documentation: El Salvador.
     * @return string 'SV'
     */
    const VALUE_SV = 'SV';
    /**
     * Constant for value 'GQ'
     * Meta information extracted from the WSDL
     * - documentation: Equatorial Guinea.
     * @return string 'GQ'
     */
    const VALUE_GQ = 'GQ';
    /**
     * Constant for value 'ER'
     * Meta information extracted from the WSDL
     * - documentation: Eritrea.
     * @return string 'ER'
     */
    const VALUE_ER = 'ER';
    /**
     * Constant for value 'EE'
     * Meta information extracted from the WSDL
     * - documentation: Estonia.
     * @return string 'EE'
     */
    const VALUE_EE = 'EE';
    /**
     * Constant for value 'ET'
     * Meta information extracted from the WSDL
     * - documentation: Ethiopia.
     * @return string 'ET'
     */
    const VALUE_ET = 'ET';
    /**
     * Constant for value 'FK'
     * Meta information extracted from the WSDL
     * - documentation: Falkland Islands (Malvinas).
     * @return string 'FK'
     */
    const VALUE_FK = 'FK';
    /**
     * Constant for value 'FO'
     * Meta information extracted from the WSDL
     * - documentation: Faroe Islands.
     * @return string 'FO'
     */
    const VALUE_FO = 'FO';
    /**
     * Constant for value 'FJ'
     * Meta information extracted from the WSDL
     * - documentation: Fiji.
     * @return string 'FJ'
     */
    const VALUE_FJ = 'FJ';
    /**
     * Constant for value 'FI'
     * Meta information extracted from the WSDL
     * - documentation: Finland.
     * @return string 'FI'
     */
    const VALUE_FI = 'FI';
    /**
     * Constant for value 'FR'
     * Meta information extracted from the WSDL
     * - documentation: France.
     * @return string 'FR'
     */
    const VALUE_FR = 'FR';
    /**
     * Constant for value 'GF'
     * Meta information extracted from the WSDL
     * - documentation: French Guiana.
     * @return string 'GF'
     */
    const VALUE_GF = 'GF';
    /**
     * Constant for value 'PF'
     * Meta information extracted from the WSDL
     * - documentation: French Polynesia. Includes Tahiti.
     * @return string 'PF'
     */
    const VALUE_PF = 'PF';
    /**
     * Constant for value 'TF'
     * Meta information extracted from the WSDL
     * - documentation: French Southern Territories.
     * @return string 'TF'
     */
    const VALUE_TF = 'TF';
    /**
     * Constant for value 'GA'
     * Meta information extracted from the WSDL
     * - documentation: Gabon.
     * @return string 'GA'
     */
    const VALUE_GA = 'GA';
    /**
     * Constant for value 'GM'
     * Meta information extracted from the WSDL
     * - documentation: Gambia.
     * @return string 'GM'
     */
    const VALUE_GM = 'GM';
    /**
     * Constant for value 'GE'
     * Meta information extracted from the WSDL
     * - documentation: Georgia.
     * @return string 'GE'
     */
    const VALUE_GE = 'GE';
    /**
     * Constant for value 'DE'
     * Meta information extracted from the WSDL
     * - documentation: Germany.
     * @return string 'DE'
     */
    const VALUE_DE = 'DE';
    /**
     * Constant for value 'GH'
     * Meta information extracted from the WSDL
     * - documentation: Ghana.
     * @return string 'GH'
     */
    const VALUE_GH = 'GH';
    /**
     * Constant for value 'GI'
     * Meta information extracted from the WSDL
     * - documentation: Gibraltar.
     * @return string 'GI'
     */
    const VALUE_GI = 'GI';
    /**
     * Constant for value 'GR'
     * Meta information extracted from the WSDL
     * - documentation: Greece.
     * @return string 'GR'
     */
    const VALUE_GR = 'GR';
    /**
     * Constant for value 'GL'
     * Meta information extracted from the WSDL
     * - documentation: Greenland.
     * @return string 'GL'
     */
    const VALUE_GL = 'GL';
    /**
     * Constant for value 'GD'
     * Meta information extracted from the WSDL
     * - documentation: Grenada.
     * @return string 'GD'
     */
    const VALUE_GD = 'GD';
    /**
     * Constant for value 'GP'
     * Meta information extracted from the WSDL
     * - documentation: Guadeloupe.
     * @return string 'GP'
     */
    const VALUE_GP = 'GP';
    /**
     * Constant for value 'GU'
     * Meta information extracted from the WSDL
     * - documentation: Guam.
     * @return string 'GU'
     */
    const VALUE_GU = 'GU';
    /**
     * Constant for value 'GT'
     * Meta information extracted from the WSDL
     * - documentation: Guatemala.
     * @return string 'GT'
     */
    const VALUE_GT = 'GT';
    /**
     * Constant for value 'GN'
     * Meta information extracted from the WSDL
     * - documentation: Guinea.
     * @return string 'GN'
     */
    const VALUE_GN = 'GN';
    /**
     * Constant for value 'GW'
     * Meta information extracted from the WSDL
     * - documentation: Guinea-Bissau.
     * @return string 'GW'
     */
    const VALUE_GW = 'GW';
    /**
     * Constant for value 'GY'
     * Meta information extracted from the WSDL
     * - documentation: Guyana.
     * @return string 'GY'
     */
    const VALUE_GY = 'GY';
    /**
     * Constant for value 'HT'
     * Meta information extracted from the WSDL
     * - documentation: Haiti.
     * @return string 'HT'
     */
    const VALUE_HT = 'HT';
    /**
     * Constant for value 'HM'
     * Meta information extracted from the WSDL
     * - documentation: Heard Island and McDonald Islands.
     * @return string 'HM'
     */
    const VALUE_HM = 'HM';
    /**
     * Constant for value 'VA'
     * Meta information extracted from the WSDL
     * - documentation: Holy See (Vatican City state).
     * @return string 'VA'
     */
    const VALUE_VA = 'VA';
    /**
     * Constant for value 'HN'
     * Meta information extracted from the WSDL
     * - documentation: Honduras.
     * @return string 'HN'
     */
    const VALUE_HN = 'HN';
    /**
     * Constant for value 'HK'
     * Meta information extracted from the WSDL
     * - documentation: Hong Kong.
     * @return string 'HK'
     */
    const VALUE_HK = 'HK';
    /**
     * Constant for value 'HU'
     * Meta information extracted from the WSDL
     * - documentation: Hungary.
     * @return string 'HU'
     */
    const VALUE_HU = 'HU';
    /**
     * Constant for value 'IS'
     * Meta information extracted from the WSDL
     * - documentation: Iceland.
     * @return string 'IS'
     */
    const VALUE_IS = 'IS';
    /**
     * Constant for value 'IN'
     * Meta information extracted from the WSDL
     * - documentation: India.
     * @return string 'IN'
     */
    const VALUE_IN = 'IN';
    /**
     * Constant for value 'ID'
     * Meta information extracted from the WSDL
     * - documentation: Indonesia.
     * @return string 'ID'
     */
    const VALUE_ID = 'ID';
    /**
     * Constant for value 'IR'
     * Meta information extracted from the WSDL
     * - documentation: Islamic Republic of Iran.
     * @return string 'IR'
     */
    const VALUE_IR = 'IR';
    /**
     * Constant for value 'IQ'
     * Meta information extracted from the WSDL
     * - documentation: Iraq.
     * @return string 'IQ'
     */
    const VALUE_IQ = 'IQ';
    /**
     * Constant for value 'IE'
     * Meta information extracted from the WSDL
     * - documentation: Ireland.
     * @return string 'IE'
     */
    const VALUE_IE = 'IE';
    /**
     * Constant for value 'IL'
     * Meta information extracted from the WSDL
     * - documentation: Israel.
     * @return string 'IL'
     */
    const VALUE_IL = 'IL';
    /**
     * Constant for value 'IT'
     * Meta information extracted from the WSDL
     * - documentation: Italy.
     * @return string 'IT'
     */
    const VALUE_IT = 'IT';
    /**
     * Constant for value 'JM'
     * Meta information extracted from the WSDL
     * - documentation: Jamaica.
     * @return string 'JM'
     */
    const VALUE_JM = 'JM';
    /**
     * Constant for value 'JP'
     * Meta information extracted from the WSDL
     * - documentation: Japan.
     * @return string 'JP'
     */
    const VALUE_JP = 'JP';
    /**
     * Constant for value 'JO'
     * Meta information extracted from the WSDL
     * - documentation: Jordan.
     * @return string 'JO'
     */
    const VALUE_JO = 'JO';
    /**
     * Constant for value 'KZ'
     * Meta information extracted from the WSDL
     * - documentation: Kazakhstan.
     * @return string 'KZ'
     */
    const VALUE_KZ = 'KZ';
    /**
     * Constant for value 'KE'
     * Meta information extracted from the WSDL
     * - documentation: Kenya.
     * @return string 'KE'
     */
    const VALUE_KE = 'KE';
    /**
     * Constant for value 'KI'
     * Meta information extracted from the WSDL
     * - documentation: Kiribati.
     * @return string 'KI'
     */
    const VALUE_KI = 'KI';
    /**
     * Constant for value 'KP'
     * Meta information extracted from the WSDL
     * - documentation: Democratic People's Republic of Korea.
     * @return string 'KP'
     */
    const VALUE_KP = 'KP';
    /**
     * Constant for value 'KR'
     * Meta information extracted from the WSDL
     * - documentation: Republic of Korea.
     * @return string 'KR'
     */
    const VALUE_KR = 'KR';
    /**
     * Constant for value 'KW'
     * Meta information extracted from the WSDL
     * - documentation: Kuwait.
     * @return string 'KW'
     */
    const VALUE_KW = 'KW';
    /**
     * Constant for value 'KG'
     * Meta information extracted from the WSDL
     * - documentation: Kyrgyzstan.
     * @return string 'KG'
     */
    const VALUE_KG = 'KG';
    /**
     * Constant for value 'LA'
     * Meta information extracted from the WSDL
     * - documentation: Lao People's Democratic Republic.
     * @return string 'LA'
     */
    const VALUE_LA = 'LA';
    /**
     * Constant for value 'LV'
     * Meta information extracted from the WSDL
     * - documentation: Latvia.
     * @return string 'LV'
     */
    const VALUE_LV = 'LV';
    /**
     * Constant for value 'LB'
     * Meta information extracted from the WSDL
     * - documentation: Lebanon.
     * @return string 'LB'
     */
    const VALUE_LB = 'LB';
    /**
     * Constant for value 'LS'
     * Meta information extracted from the WSDL
     * - documentation: Lesotho.
     * @return string 'LS'
     */
    const VALUE_LS = 'LS';
    /**
     * Constant for value 'LR'
     * Meta information extracted from the WSDL
     * - documentation: Liberia.
     * @return string 'LR'
     */
    const VALUE_LR = 'LR';
    /**
     * Constant for value 'LY'
     * Meta information extracted from the WSDL
     * - documentation: Libyan Arab Jamahiriya.
     * @return string 'LY'
     */
    const VALUE_LY = 'LY';
    /**
     * Constant for value 'LI'
     * Meta information extracted from the WSDL
     * - documentation: Liechtenstein.
     * @return string 'LI'
     */
    const VALUE_LI = 'LI';
    /**
     * Constant for value 'LT'
     * Meta information extracted from the WSDL
     * - documentation: Lithuania.
     * @return string 'LT'
     */
    const VALUE_LT = 'LT';
    /**
     * Constant for value 'LU'
     * Meta information extracted from the WSDL
     * - documentation: Luxembourg.
     * @return string 'LU'
     */
    const VALUE_LU = 'LU';
    /**
     * Constant for value 'MO'
     * Meta information extracted from the WSDL
     * - documentation: Macao.
     * @return string 'MO'
     */
    const VALUE_MO = 'MO';
    /**
     * Constant for value 'MK'
     * Meta information extracted from the WSDL
     * - documentation: The Former Yugoslav Republic of Macedonia.
     * @return string 'MK'
     */
    const VALUE_MK = 'MK';
    /**
     * Constant for value 'MG'
     * Meta information extracted from the WSDL
     * - documentation: Madagascar.
     * @return string 'MG'
     */
    const VALUE_MG = 'MG';
    /**
     * Constant for value 'MW'
     * Meta information extracted from the WSDL
     * - documentation: Malawi.
     * @return string 'MW'
     */
    const VALUE_MW = 'MW';
    /**
     * Constant for value 'MY'
     * Meta information extracted from the WSDL
     * - documentation: Malaysia.
     * @return string 'MY'
     */
    const VALUE_MY = 'MY';
    /**
     * Constant for value 'MV'
     * Meta information extracted from the WSDL
     * - documentation: Maldives.
     * @return string 'MV'
     */
    const VALUE_MV = 'MV';
    /**
     * Constant for value 'ML'
     * Meta information extracted from the WSDL
     * - documentation: Mali.
     * @return string 'ML'
     */
    const VALUE_ML = 'ML';
    /**
     * Constant for value 'MT'
     * Meta information extracted from the WSDL
     * - documentation: Malta.
     * @return string 'MT'
     */
    const VALUE_MT = 'MT';
    /**
     * Constant for value 'MH'
     * Meta information extracted from the WSDL
     * - documentation: Marshall Islands.
     * @return string 'MH'
     */
    const VALUE_MH = 'MH';
    /**
     * Constant for value 'MQ'
     * Meta information extracted from the WSDL
     * - documentation: Martinique.
     * @return string 'MQ'
     */
    const VALUE_MQ = 'MQ';
    /**
     * Constant for value 'MR'
     * Meta information extracted from the WSDL
     * - documentation: Mauritania.
     * @return string 'MR'
     */
    const VALUE_MR = 'MR';
    /**
     * Constant for value 'MU'
     * Meta information extracted from the WSDL
     * - documentation: Mauritius.
     * @return string 'MU'
     */
    const VALUE_MU = 'MU';
    /**
     * Constant for value 'YT'
     * Meta information extracted from the WSDL
     * - documentation: Mayotte.
     * @return string 'YT'
     */
    const VALUE_YT = 'YT';
    /**
     * Constant for value 'MX'
     * Meta information extracted from the WSDL
     * - documentation: Mexico.
     * @return string 'MX'
     */
    const VALUE_MX = 'MX';
    /**
     * Constant for value 'FM'
     * Meta information extracted from the WSDL
     * - documentation: Federated States of Micronesia.
     * @return string 'FM'
     */
    const VALUE_FM = 'FM';
    /**
     * Constant for value 'MD'
     * Meta information extracted from the WSDL
     * - documentation: Republic of Moldova.
     * @return string 'MD'
     */
    const VALUE_MD = 'MD';
    /**
     * Constant for value 'MC'
     * Meta information extracted from the WSDL
     * - documentation: Monaco.
     * @return string 'MC'
     */
    const VALUE_MC = 'MC';
    /**
     * Constant for value 'MN'
     * Meta information extracted from the WSDL
     * - documentation: Mongolia.
     * @return string 'MN'
     */
    const VALUE_MN = 'MN';
    /**
     * Constant for value 'MS'
     * Meta information extracted from the WSDL
     * - documentation: Montserrat.
     * @return string 'MS'
     */
    const VALUE_MS = 'MS';
    /**
     * Constant for value 'MA'
     * Meta information extracted from the WSDL
     * - documentation: Morocco.
     * @return string 'MA'
     */
    const VALUE_MA = 'MA';
    /**
     * Constant for value 'MZ'
     * Meta information extracted from the WSDL
     * - documentation: Mozambique.
     * @return string 'MZ'
     */
    const VALUE_MZ = 'MZ';
    /**
     * Constant for value 'MM'
     * Meta information extracted from the WSDL
     * - documentation: Myanmar.
     * @return string 'MM'
     */
    const VALUE_MM = 'MM';
    /**
     * Constant for value 'NA'
     * Meta information extracted from the WSDL
     * - documentation: Namibia.
     * @return string 'NA'
     */
    const VALUE_NA = 'NA';
    /**
     * Constant for value 'NR'
     * Meta information extracted from the WSDL
     * - documentation: Nauru.
     * @return string 'NR'
     */
    const VALUE_NR = 'NR';
    /**
     * Constant for value 'NP'
     * Meta information extracted from the WSDL
     * - documentation: Nepal.
     * @return string 'NP'
     */
    const VALUE_NP = 'NP';
    /**
     * Constant for value 'NL'
     * Meta information extracted from the WSDL
     * - documentation: Netherlands.
     * @return string 'NL'
     */
    const VALUE_NL = 'NL';
    /**
     * Constant for value 'AN'
     * Meta information extracted from the WSDL
     * - documentation: Netherlands Antilles.
     * @return string 'AN'
     */
    const VALUE_AN = 'AN';
    /**
     * Constant for value 'NC'
     * Meta information extracted from the WSDL
     * - documentation: New Caledonia.
     * @return string 'NC'
     */
    const VALUE_NC = 'NC';
    /**
     * Constant for value 'NZ'
     * Meta information extracted from the WSDL
     * - documentation: New Zealand.
     * @return string 'NZ'
     */
    const VALUE_NZ = 'NZ';
    /**
     * Constant for value 'NI'
     * Meta information extracted from the WSDL
     * - documentation: Nicaragua.
     * @return string 'NI'
     */
    const VALUE_NI = 'NI';
    /**
     * Constant for value 'NE'
     * Meta information extracted from the WSDL
     * - documentation: Niger.
     * @return string 'NE'
     */
    const VALUE_NE = 'NE';
    /**
     * Constant for value 'NG'
     * Meta information extracted from the WSDL
     * - documentation: Nigeria.
     * @return string 'NG'
     */
    const VALUE_NG = 'NG';
    /**
     * Constant for value 'NU'
     * Meta information extracted from the WSDL
     * - documentation: Niue.
     * @return string 'NU'
     */
    const VALUE_NU = 'NU';
    /**
     * Constant for value 'NF'
     * Meta information extracted from the WSDL
     * - documentation: Norfolk Island.
     * @return string 'NF'
     */
    const VALUE_NF = 'NF';
    /**
     * Constant for value 'MP'
     * Meta information extracted from the WSDL
     * - documentation: Northern Mariana Islands.
     * @return string 'MP'
     */
    const VALUE_MP = 'MP';
    /**
     * Constant for value 'NO'
     * Meta information extracted from the WSDL
     * - documentation: Norway.
     * @return string 'NO'
     */
    const VALUE_NO = 'NO';
    /**
     * Constant for value 'OM'
     * Meta information extracted from the WSDL
     * - documentation: Oman.
     * @return string 'OM'
     */
    const VALUE_OM = 'OM';
    /**
     * Constant for value 'PK'
     * Meta information extracted from the WSDL
     * - documentation: Pakistan.
     * @return string 'PK'
     */
    const VALUE_PK = 'PK';
    /**
     * Constant for value 'PW'
     * Meta information extracted from the WSDL
     * - documentation: Palau.
     * @return string 'PW'
     */
    const VALUE_PW = 'PW';
    /**
     * Constant for value 'PS'
     * Meta information extracted from the WSDL
     * - documentation: Palestinian territory, Occupied.
     * @return string 'PS'
     */
    const VALUE_PS = 'PS';
    /**
     * Constant for value 'PA'
     * Meta information extracted from the WSDL
     * - documentation: Panama.
     * @return string 'PA'
     */
    const VALUE_PA = 'PA';
    /**
     * Constant for value 'PG'
     * Meta information extracted from the WSDL
     * - documentation: Papua New Guinea.
     * @return string 'PG'
     */
    const VALUE_PG = 'PG';
    /**
     * Constant for value 'PY'
     * Meta information extracted from the WSDL
     * - documentation: Paraguay.
     * @return string 'PY'
     */
    const VALUE_PY = 'PY';
    /**
     * Constant for value 'PE'
     * Meta information extracted from the WSDL
     * - documentation: Peru.
     * @return string 'PE'
     */
    const VALUE_PE = 'PE';
    /**
     * Constant for value 'PH'
     * Meta information extracted from the WSDL
     * - documentation: Philippines.
     * @return string 'PH'
     */
    const VALUE_PH = 'PH';
    /**
     * Constant for value 'PN'
     * Meta information extracted from the WSDL
     * - documentation: Pitcairn.
     * @return string 'PN'
     */
    const VALUE_PN = 'PN';
    /**
     * Constant for value 'PL'
     * Meta information extracted from the WSDL
     * - documentation: Poland.
     * @return string 'PL'
     */
    const VALUE_PL = 'PL';
    /**
     * Constant for value 'PT'
     * Meta information extracted from the WSDL
     * - documentation: Portugal.
     * @return string 'PT'
     */
    const VALUE_PT = 'PT';
    /**
     * Constant for value 'PR'
     * Meta information extracted from the WSDL
     * - documentation: Puerto Rico.
     * @return string 'PR'
     */
    const VALUE_PR = 'PR';
    /**
     * Constant for value 'QA'
     * Meta information extracted from the WSDL
     * - documentation: Qatar.
     * @return string 'QA'
     */
    const VALUE_QA = 'QA';
    /**
     * Constant for value 'RE'
     * Meta information extracted from the WSDL
     * - documentation: Reunion.
     * @return string 'RE'
     */
    const VALUE_RE = 'RE';
    /**
     * Constant for value 'RO'
     * Meta information extracted from the WSDL
     * - documentation: Romania.
     * @return string 'RO'
     */
    const VALUE_RO = 'RO';
    /**
     * Constant for value 'RU'
     * Meta information extracted from the WSDL
     * - documentation: Russian Federation.
     * @return string 'RU'
     */
    const VALUE_RU = 'RU';
    /**
     * Constant for value 'RW'
     * Meta information extracted from the WSDL
     * - documentation: Rwanda.
     * @return string 'RW'
     */
    const VALUE_RW = 'RW';
    /**
     * Constant for value 'SH'
     * Meta information extracted from the WSDL
     * - documentation: Saint Helena.
     * @return string 'SH'
     */
    const VALUE_SH = 'SH';
    /**
     * Constant for value 'KN'
     * Meta information extracted from the WSDL
     * - documentation: Saint Kitts and Nevis.
     * @return string 'KN'
     */
    const VALUE_KN = 'KN';
    /**
     * Constant for value 'LC'
     * Meta information extracted from the WSDL
     * - documentation: Saint Lucia.
     * @return string 'LC'
     */
    const VALUE_LC = 'LC';
    /**
     * Constant for value 'PM'
     * Meta information extracted from the WSDL
     * - documentation: Saint Pierre and Miquelon.
     * @return string 'PM'
     */
    const VALUE_PM = 'PM';
    /**
     * Constant for value 'VC'
     * Meta information extracted from the WSDL
     * - documentation: Saint Vincent and the Grenadines.
     * @return string 'VC'
     */
    const VALUE_VC = 'VC';
    /**
     * Constant for value 'WS'
     * Meta information extracted from the WSDL
     * - documentation: Samoa.
     * @return string 'WS'
     */
    const VALUE_WS = 'WS';
    /**
     * Constant for value 'SM'
     * Meta information extracted from the WSDL
     * - documentation: San Marino.
     * @return string 'SM'
     */
    const VALUE_SM = 'SM';
    /**
     * Constant for value 'ST'
     * Meta information extracted from the WSDL
     * - documentation: Sao Tome and Principe.
     * @return string 'ST'
     */
    const VALUE_ST = 'ST';
    /**
     * Constant for value 'SA'
     * Meta information extracted from the WSDL
     * - documentation: Saudi Arabia.
     * @return string 'SA'
     */
    const VALUE_SA = 'SA';
    /**
     * Constant for value 'SN'
     * Meta information extracted from the WSDL
     * - documentation: Senegal.
     * @return string 'SN'
     */
    const VALUE_SN = 'SN';
    /**
     * Constant for value 'SC'
     * Meta information extracted from the WSDL
     * - documentation: Seychelles.
     * @return string 'SC'
     */
    const VALUE_SC = 'SC';
    /**
     * Constant for value 'SL'
     * Meta information extracted from the WSDL
     * - documentation: Sierra Leone.
     * @return string 'SL'
     */
    const VALUE_SL = 'SL';
    /**
     * Constant for value 'SG'
     * Meta information extracted from the WSDL
     * - documentation: Singapore.
     * @return string 'SG'
     */
    const VALUE_SG = 'SG';
    /**
     * Constant for value 'SK'
     * Meta information extracted from the WSDL
     * - documentation: Slovakia.
     * @return string 'SK'
     */
    const VALUE_SK = 'SK';
    /**
     * Constant for value 'SI'
     * Meta information extracted from the WSDL
     * - documentation: Slovenia.
     * @return string 'SI'
     */
    const VALUE_SI = 'SI';
    /**
     * Constant for value 'SB'
     * Meta information extracted from the WSDL
     * - documentation: Solomon Islands.
     * @return string 'SB'
     */
    const VALUE_SB = 'SB';
    /**
     * Constant for value 'SO'
     * Meta information extracted from the WSDL
     * - documentation: Somalia.
     * @return string 'SO'
     */
    const VALUE_SO = 'SO';
    /**
     * Constant for value 'ZA'
     * Meta information extracted from the WSDL
     * - documentation: South Africa.
     * @return string 'ZA'
     */
    const VALUE_ZA = 'ZA';
    /**
     * Constant for value 'GS'
     * Meta information extracted from the WSDL
     * - documentation: South Georgia and the South Sandwich Islands.
     * @return string 'GS'
     */
    const VALUE_GS = 'GS';
    /**
     * Constant for value 'ES'
     * Meta information extracted from the WSDL
     * - documentation: Spain.
     * @return string 'ES'
     */
    const VALUE_ES = 'ES';
    /**
     * Constant for value 'LK'
     * Meta information extracted from the WSDL
     * - documentation: Sri Lanka.
     * @return string 'LK'
     */
    const VALUE_LK = 'LK';
    /**
     * Constant for value 'SD'
     * Meta information extracted from the WSDL
     * - documentation: Sudan.
     * @return string 'SD'
     */
    const VALUE_SD = 'SD';
    /**
     * Constant for value 'SR'
     * Meta information extracted from the WSDL
     * - documentation: Suriname.
     * @return string 'SR'
     */
    const VALUE_SR = 'SR';
    /**
     * Constant for value 'SJ'
     * Meta information extracted from the WSDL
     * - documentation: Svalbard and Jan Mayen.
     * @return string 'SJ'
     */
    const VALUE_SJ = 'SJ';
    /**
     * Constant for value 'SZ'
     * Meta information extracted from the WSDL
     * - documentation: Swaziland.
     * @return string 'SZ'
     */
    const VALUE_SZ = 'SZ';
    /**
     * Constant for value 'SE'
     * Meta information extracted from the WSDL
     * - documentation: Sweden.
     * @return string 'SE'
     */
    const VALUE_SE = 'SE';
    /**
     * Constant for value 'CH'
     * Meta information extracted from the WSDL
     * - documentation: Switzerland.
     * @return string 'CH'
     */
    const VALUE_CH = 'CH';
    /**
     * Constant for value 'SY'
     * Meta information extracted from the WSDL
     * - documentation: Syrian Arab Republic.
     * @return string 'SY'
     */
    const VALUE_SY = 'SY';
    /**
     * Constant for value 'TW'
     * Meta information extracted from the WSDL
     * - documentation: Taiwan, Province of China.
     * @return string 'TW'
     */
    const VALUE_TW = 'TW';
    /**
     * Constant for value 'TJ'
     * Meta information extracted from the WSDL
     * - documentation: Tajikistan.
     * @return string 'TJ'
     */
    const VALUE_TJ = 'TJ';
    /**
     * Constant for value 'TZ'
     * Meta information extracted from the WSDL
     * - documentation: Tanzania, United Republic of.
     * @return string 'TZ'
     */
    const VALUE_TZ = 'TZ';
    /**
     * Constant for value 'TH'
     * Meta information extracted from the WSDL
     * - documentation: Thailand.
     * @return string 'TH'
     */
    const VALUE_TH = 'TH';
    /**
     * Constant for value 'TG'
     * Meta information extracted from the WSDL
     * - documentation: Togo.
     * @return string 'TG'
     */
    const VALUE_TG = 'TG';
    /**
     * Constant for value 'TK'
     * Meta information extracted from the WSDL
     * - documentation: Tokelau.
     * @return string 'TK'
     */
    const VALUE_TK = 'TK';
    /**
     * Constant for value 'TO'
     * Meta information extracted from the WSDL
     * - documentation: Tonga.
     * @return string 'TO'
     */
    const VALUE_TO = 'TO';
    /**
     * Constant for value 'TT'
     * Meta information extracted from the WSDL
     * - documentation: Trinidad and Tobago.
     * @return string 'TT'
     */
    const VALUE_TT = 'TT';
    /**
     * Constant for value 'TN'
     * Meta information extracted from the WSDL
     * - documentation: Tunisia.
     * @return string 'TN'
     */
    const VALUE_TN = 'TN';
    /**
     * Constant for value 'TR'
     * Meta information extracted from the WSDL
     * - documentation: Turkey.
     * @return string 'TR'
     */
    const VALUE_TR = 'TR';
    /**
     * Constant for value 'TM'
     * Meta information extracted from the WSDL
     * - documentation: Turkmenistan.
     * @return string 'TM'
     */
    const VALUE_TM = 'TM';
    /**
     * Constant for value 'TC'
     * Meta information extracted from the WSDL
     * - documentation: Turks and Caicos Islands.
     * @return string 'TC'
     */
    const VALUE_TC = 'TC';
    /**
     * Constant for value 'TV'
     * Meta information extracted from the WSDL
     * - documentation: Tuvalu.
     * @return string 'TV'
     */
    const VALUE_TV = 'TV';
    /**
     * Constant for value 'UG'
     * Meta information extracted from the WSDL
     * - documentation: Uganda.
     * @return string 'UG'
     */
    const VALUE_UG = 'UG';
    /**
     * Constant for value 'UA'
     * Meta information extracted from the WSDL
     * - documentation: Ukraine.
     * @return string 'UA'
     */
    const VALUE_UA = 'UA';
    /**
     * Constant for value 'AE'
     * Meta information extracted from the WSDL
     * - documentation: United Arab Emirates.
     * @return string 'AE'
     */
    const VALUE_AE = 'AE';
    /**
     * Constant for value 'GB'
     * Meta information extracted from the WSDL
     * - documentation: United Kingdom.
     * @return string 'GB'
     */
    const VALUE_GB = 'GB';
    /**
     * Constant for value 'US'
     * Meta information extracted from the WSDL
     * - documentation: United States.
     * @return string 'US'
     */
    const VALUE_US = 'US';
    /**
     * Constant for value 'UM'
     * Meta information extracted from the WSDL
     * - documentation: NOTE: United States Minor Outlying Islands was defined in the eBay list previously but is no longer a viable option. This country will remain on eBay country list for backward compatibility. Use 'US' instead.
     * @return string 'UM'
     */
    const VALUE_UM = 'UM';
    /**
     * Constant for value 'UY'
     * Meta information extracted from the WSDL
     * - documentation: Uruguay.
     * @return string 'UY'
     */
    const VALUE_UY = 'UY';
    /**
     * Constant for value 'UZ'
     * Meta information extracted from the WSDL
     * - documentation: Uzbekistan.
     * @return string 'UZ'
     */
    const VALUE_UZ = 'UZ';
    /**
     * Constant for value 'VU'
     * Meta information extracted from the WSDL
     * - documentation: Vanuatu.
     * @return string 'VU'
     */
    const VALUE_VU = 'VU';
    /**
     * Constant for value 'VE'
     * Meta information extracted from the WSDL
     * - documentation: Venezuela.
     * @return string 'VE'
     */
    const VALUE_VE = 'VE';
    /**
     * Constant for value 'VN'
     * Meta information extracted from the WSDL
     * - documentation: Vietnam.
     * @return string 'VN'
     */
    const VALUE_VN = 'VN';
    /**
     * Constant for value 'VG'
     * Meta information extracted from the WSDL
     * - documentation: Virgin Islands, British.
     * @return string 'VG'
     */
    const VALUE_VG = 'VG';
    /**
     * Constant for value 'VI'
     * Meta information extracted from the WSDL
     * - documentation: Virgin Islands, U.S.
     * @return string 'VI'
     */
    const VALUE_VI = 'VI';
    /**
     * Constant for value 'WF'
     * Meta information extracted from the WSDL
     * - documentation: Wallis and Futuna.
     * @return string 'WF'
     */
    const VALUE_WF = 'WF';
    /**
     * Constant for value 'EH'
     * Meta information extracted from the WSDL
     * - documentation: Western Sahara.
     * @return string 'EH'
     */
    const VALUE_EH = 'EH';
    /**
     * Constant for value 'YE'
     * Meta information extracted from the WSDL
     * - documentation: Yemen.
     * @return string 'YE'
     */
    const VALUE_YE = 'YE';
    /**
     * Constant for value 'YU'
     * Meta information extracted from the WSDL
     * - documentation: No longer in use. See RS for Serbia and ME for Montenegro.
     * @return string 'YU'
     */
    const VALUE_YU = 'YU';
    /**
     * Constant for value 'ZM'
     * Meta information extracted from the WSDL
     * - documentation: Zambia.
     * @return string 'ZM'
     */
    const VALUE_ZM = 'ZM';
    /**
     * Constant for value 'ZW'
     * Meta information extracted from the WSDL
     * - documentation: Zimbabwe.
     * @return string 'ZW'
     */
    const VALUE_ZW = 'ZW';
    /**
     * Constant for value 'AA'
     * Meta information extracted from the WSDL
     * - documentation: NOTE: APO/FPO was defined in eBay list previously but they are not defined in ISO 3166. This country will remain on eBay country code list for backward compatibility.
     * @return string 'AA'
     */
    const VALUE_AA = 'AA';
    /**
     * Constant for value 'QM'
     * Meta information extracted from the WSDL
     * - documentation: NOTE : Guernsey was defined in eBay list previously but they are not defined in ISO 3166. This country will remain on eBay country list for backward compatibility.
     * @return string 'QM'
     */
    const VALUE_QM = 'QM';
    /**
     * Constant for value 'QN'
     * Meta information extracted from the WSDL
     * - documentation: NOTE: Jan Mayen was defined in eBay list previously but they are not defined in ISO 3166. This country will remain on eBay country list for backward compatibility.
     * @return string 'QN'
     */
    const VALUE_QN = 'QN';
    /**
     * Constant for value 'QO'
     * Meta information extracted from the WSDL
     * - documentation: NOTE: Jersey was defined in eBay list previously but they are not defined in ISO 3166. This country will remain on eBay country list for backward compatibility.
     * @return string 'QO'
     */
    const VALUE_QO = 'QO';
    /**
     * Constant for value 'QP'
     * @return string 'QP'
     */
    const VALUE_QP = 'QP';
    /**
     * Constant for value 'JE'
     * Meta information extracted from the WSDL
     * - documentation: Jersey
     * @return string 'JE'
     */
    const VALUE_JE = 'JE';
    /**
     * Constant for value 'GG'
     * Meta information extracted from the WSDL
     * - documentation: Guernsey
     * @return string 'GG'
     */
    const VALUE_GG = 'GG';
    /**
     * Constant for value 'ZZ'
     * Meta information extracted from the WSDL
     * - documentation: Unknown country
     * @return string 'ZZ'
     */
    const VALUE_ZZ = 'ZZ';
    /**
     * Constant for value 'RS'
     * Meta information extracted from the WSDL
     * - documentation: Serbia
     * @return string 'RS'
     */
    const VALUE_RS = 'RS';
    /**
     * Constant for value 'ME'
     * Meta information extracted from the WSDL
     * - documentation: Montenegro.
     * @return string 'ME'
     */
    const VALUE_ME = 'ME';
    /**
     * Constant for value 'CustomCode'
     * Meta information extracted from the WSDL
     * - documentation: (out) Reserved for internal or future use
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AF
     * @uses self::VALUE_AL
     * @uses self::VALUE_DZ
     * @uses self::VALUE_AS
     * @uses self::VALUE_AD
     * @uses self::VALUE_AO
     * @uses self::VALUE_AI
     * @uses self::VALUE_AQ
     * @uses self::VALUE_AG
     * @uses self::VALUE_AR
     * @uses self::VALUE_AM
     * @uses self::VALUE_AW
     * @uses self::VALUE_AU
     * @uses self::VALUE_AT
     * @uses self::VALUE_AZ
     * @uses self::VALUE_BS
     * @uses self::VALUE_BH
     * @uses self::VALUE_BD
     * @uses self::VALUE_BB
     * @uses self::VALUE_BY
     * @uses self::VALUE_BE
     * @uses self::VALUE_BZ
     * @uses self::VALUE_BJ
     * @uses self::VALUE_BM
     * @uses self::VALUE_BT
     * @uses self::VALUE_BO
     * @uses self::VALUE_BA
     * @uses self::VALUE_BW
     * @uses self::VALUE_BV
     * @uses self::VALUE_BR
     * @uses self::VALUE_IO
     * @uses self::VALUE_BN
     * @uses self::VALUE_BG
     * @uses self::VALUE_BF
     * @uses self::VALUE_BI
     * @uses self::VALUE_KH
     * @uses self::VALUE_CM
     * @uses self::VALUE_CA
     * @uses self::VALUE_CV
     * @uses self::VALUE_KY
     * @uses self::VALUE_CF
     * @uses self::VALUE_TD
     * @uses self::VALUE_CL
     * @uses self::VALUE_CN
     * @uses self::VALUE_CX
     * @uses self::VALUE_CC
     * @uses self::VALUE_CO
     * @uses self::VALUE_KM
     * @uses self::VALUE_CG
     * @uses self::VALUE_CD
     * @uses self::VALUE_CK
     * @uses self::VALUE_CR
     * @uses self::VALUE_CI
     * @uses self::VALUE_HR
     * @uses self::VALUE_CU
     * @uses self::VALUE_CY
     * @uses self::VALUE_CZ
     * @uses self::VALUE_DK
     * @uses self::VALUE_DJ
     * @uses self::VALUE_DM
     * @uses self::VALUE_DO
     * @uses self::VALUE_TP
     * @uses self::VALUE_EC
     * @uses self::VALUE_EG
     * @uses self::VALUE_SV
     * @uses self::VALUE_GQ
     * @uses self::VALUE_ER
     * @uses self::VALUE_EE
     * @uses self::VALUE_ET
     * @uses self::VALUE_FK
     * @uses self::VALUE_FO
     * @uses self::VALUE_FJ
     * @uses self::VALUE_FI
     * @uses self::VALUE_FR
     * @uses self::VALUE_GF
     * @uses self::VALUE_PF
     * @uses self::VALUE_TF
     * @uses self::VALUE_GA
     * @uses self::VALUE_GM
     * @uses self::VALUE_GE
     * @uses self::VALUE_DE
     * @uses self::VALUE_GH
     * @uses self::VALUE_GI
     * @uses self::VALUE_GR
     * @uses self::VALUE_GL
     * @uses self::VALUE_GD
     * @uses self::VALUE_GP
     * @uses self::VALUE_GU
     * @uses self::VALUE_GT
     * @uses self::VALUE_GN
     * @uses self::VALUE_GW
     * @uses self::VALUE_GY
     * @uses self::VALUE_HT
     * @uses self::VALUE_HM
     * @uses self::VALUE_VA
     * @uses self::VALUE_HN
     * @uses self::VALUE_HK
     * @uses self::VALUE_HU
     * @uses self::VALUE_IS
     * @uses self::VALUE_IN
     * @uses self::VALUE_ID
     * @uses self::VALUE_IR
     * @uses self::VALUE_IQ
     * @uses self::VALUE_IE
     * @uses self::VALUE_IL
     * @uses self::VALUE_IT
     * @uses self::VALUE_JM
     * @uses self::VALUE_JP
     * @uses self::VALUE_JO
     * @uses self::VALUE_KZ
     * @uses self::VALUE_KE
     * @uses self::VALUE_KI
     * @uses self::VALUE_KP
     * @uses self::VALUE_KR
     * @uses self::VALUE_KW
     * @uses self::VALUE_KG
     * @uses self::VALUE_LA
     * @uses self::VALUE_LV
     * @uses self::VALUE_LB
     * @uses self::VALUE_LS
     * @uses self::VALUE_LR
     * @uses self::VALUE_LY
     * @uses self::VALUE_LI
     * @uses self::VALUE_LT
     * @uses self::VALUE_LU
     * @uses self::VALUE_MO
     * @uses self::VALUE_MK
     * @uses self::VALUE_MG
     * @uses self::VALUE_MW
     * @uses self::VALUE_MY
     * @uses self::VALUE_MV
     * @uses self::VALUE_ML
     * @uses self::VALUE_MT
     * @uses self::VALUE_MH
     * @uses self::VALUE_MQ
     * @uses self::VALUE_MR
     * @uses self::VALUE_MU
     * @uses self::VALUE_YT
     * @uses self::VALUE_MX
     * @uses self::VALUE_FM
     * @uses self::VALUE_MD
     * @uses self::VALUE_MC
     * @uses self::VALUE_MN
     * @uses self::VALUE_MS
     * @uses self::VALUE_MA
     * @uses self::VALUE_MZ
     * @uses self::VALUE_MM
     * @uses self::VALUE_NA
     * @uses self::VALUE_NR
     * @uses self::VALUE_NP
     * @uses self::VALUE_NL
     * @uses self::VALUE_AN
     * @uses self::VALUE_NC
     * @uses self::VALUE_NZ
     * @uses self::VALUE_NI
     * @uses self::VALUE_NE
     * @uses self::VALUE_NG
     * @uses self::VALUE_NU
     * @uses self::VALUE_NF
     * @uses self::VALUE_MP
     * @uses self::VALUE_NO
     * @uses self::VALUE_OM
     * @uses self::VALUE_PK
     * @uses self::VALUE_PW
     * @uses self::VALUE_PS
     * @uses self::VALUE_PA
     * @uses self::VALUE_PG
     * @uses self::VALUE_PY
     * @uses self::VALUE_PE
     * @uses self::VALUE_PH
     * @uses self::VALUE_PN
     * @uses self::VALUE_PL
     * @uses self::VALUE_PT
     * @uses self::VALUE_PR
     * @uses self::VALUE_QA
     * @uses self::VALUE_RE
     * @uses self::VALUE_RO
     * @uses self::VALUE_RU
     * @uses self::VALUE_RW
     * @uses self::VALUE_SH
     * @uses self::VALUE_KN
     * @uses self::VALUE_LC
     * @uses self::VALUE_PM
     * @uses self::VALUE_VC
     * @uses self::VALUE_WS
     * @uses self::VALUE_SM
     * @uses self::VALUE_ST
     * @uses self::VALUE_SA
     * @uses self::VALUE_SN
     * @uses self::VALUE_SC
     * @uses self::VALUE_SL
     * @uses self::VALUE_SG
     * @uses self::VALUE_SK
     * @uses self::VALUE_SI
     * @uses self::VALUE_SB
     * @uses self::VALUE_SO
     * @uses self::VALUE_ZA
     * @uses self::VALUE_GS
     * @uses self::VALUE_ES
     * @uses self::VALUE_LK
     * @uses self::VALUE_SD
     * @uses self::VALUE_SR
     * @uses self::VALUE_SJ
     * @uses self::VALUE_SZ
     * @uses self::VALUE_SE
     * @uses self::VALUE_CH
     * @uses self::VALUE_SY
     * @uses self::VALUE_TW
     * @uses self::VALUE_TJ
     * @uses self::VALUE_TZ
     * @uses self::VALUE_TH
     * @uses self::VALUE_TG
     * @uses self::VALUE_TK
     * @uses self::VALUE_TO
     * @uses self::VALUE_TT
     * @uses self::VALUE_TN
     * @uses self::VALUE_TR
     * @uses self::VALUE_TM
     * @uses self::VALUE_TC
     * @uses self::VALUE_TV
     * @uses self::VALUE_UG
     * @uses self::VALUE_UA
     * @uses self::VALUE_AE
     * @uses self::VALUE_GB
     * @uses self::VALUE_US
     * @uses self::VALUE_UM
     * @uses self::VALUE_UY
     * @uses self::VALUE_UZ
     * @uses self::VALUE_VU
     * @uses self::VALUE_VE
     * @uses self::VALUE_VN
     * @uses self::VALUE_VG
     * @uses self::VALUE_VI
     * @uses self::VALUE_WF
     * @uses self::VALUE_EH
     * @uses self::VALUE_YE
     * @uses self::VALUE_YU
     * @uses self::VALUE_ZM
     * @uses self::VALUE_ZW
     * @uses self::VALUE_AA
     * @uses self::VALUE_QM
     * @uses self::VALUE_QN
     * @uses self::VALUE_QO
     * @uses self::VALUE_QP
     * @uses self::VALUE_JE
     * @uses self::VALUE_GG
     * @uses self::VALUE_ZZ
     * @uses self::VALUE_RS
     * @uses self::VALUE_ME
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AF,
            self::VALUE_AL,
            self::VALUE_DZ,
            self::VALUE_AS,
            self::VALUE_AD,
            self::VALUE_AO,
            self::VALUE_AI,
            self::VALUE_AQ,
            self::VALUE_AG,
            self::VALUE_AR,
            self::VALUE_AM,
            self::VALUE_AW,
            self::VALUE_AU,
            self::VALUE_AT,
            self::VALUE_AZ,
            self::VALUE_BS,
            self::VALUE_BH,
            self::VALUE_BD,
            self::VALUE_BB,
            self::VALUE_BY,
            self::VALUE_BE,
            self::VALUE_BZ,
            self::VALUE_BJ,
            self::VALUE_BM,
            self::VALUE_BT,
            self::VALUE_BO,
            self::VALUE_BA,
            self::VALUE_BW,
            self::VALUE_BV,
            self::VALUE_BR,
            self::VALUE_IO,
            self::VALUE_BN,
            self::VALUE_BG,
            self::VALUE_BF,
            self::VALUE_BI,
            self::VALUE_KH,
            self::VALUE_CM,
            self::VALUE_CA,
            self::VALUE_CV,
            self::VALUE_KY,
            self::VALUE_CF,
            self::VALUE_TD,
            self::VALUE_CL,
            self::VALUE_CN,
            self::VALUE_CX,
            self::VALUE_CC,
            self::VALUE_CO,
            self::VALUE_KM,
            self::VALUE_CG,
            self::VALUE_CD,
            self::VALUE_CK,
            self::VALUE_CR,
            self::VALUE_CI,
            self::VALUE_HR,
            self::VALUE_CU,
            self::VALUE_CY,
            self::VALUE_CZ,
            self::VALUE_DK,
            self::VALUE_DJ,
            self::VALUE_DM,
            self::VALUE_DO,
            self::VALUE_TP,
            self::VALUE_EC,
            self::VALUE_EG,
            self::VALUE_SV,
            self::VALUE_GQ,
            self::VALUE_ER,
            self::VALUE_EE,
            self::VALUE_ET,
            self::VALUE_FK,
            self::VALUE_FO,
            self::VALUE_FJ,
            self::VALUE_FI,
            self::VALUE_FR,
            self::VALUE_GF,
            self::VALUE_PF,
            self::VALUE_TF,
            self::VALUE_GA,
            self::VALUE_GM,
            self::VALUE_GE,
            self::VALUE_DE,
            self::VALUE_GH,
            self::VALUE_GI,
            self::VALUE_GR,
            self::VALUE_GL,
            self::VALUE_GD,
            self::VALUE_GP,
            self::VALUE_GU,
            self::VALUE_GT,
            self::VALUE_GN,
            self::VALUE_GW,
            self::VALUE_GY,
            self::VALUE_HT,
            self::VALUE_HM,
            self::VALUE_VA,
            self::VALUE_HN,
            self::VALUE_HK,
            self::VALUE_HU,
            self::VALUE_IS,
            self::VALUE_IN,
            self::VALUE_ID,
            self::VALUE_IR,
            self::VALUE_IQ,
            self::VALUE_IE,
            self::VALUE_IL,
            self::VALUE_IT,
            self::VALUE_JM,
            self::VALUE_JP,
            self::VALUE_JO,
            self::VALUE_KZ,
            self::VALUE_KE,
            self::VALUE_KI,
            self::VALUE_KP,
            self::VALUE_KR,
            self::VALUE_KW,
            self::VALUE_KG,
            self::VALUE_LA,
            self::VALUE_LV,
            self::VALUE_LB,
            self::VALUE_LS,
            self::VALUE_LR,
            self::VALUE_LY,
            self::VALUE_LI,
            self::VALUE_LT,
            self::VALUE_LU,
            self::VALUE_MO,
            self::VALUE_MK,
            self::VALUE_MG,
            self::VALUE_MW,
            self::VALUE_MY,
            self::VALUE_MV,
            self::VALUE_ML,
            self::VALUE_MT,
            self::VALUE_MH,
            self::VALUE_MQ,
            self::VALUE_MR,
            self::VALUE_MU,
            self::VALUE_YT,
            self::VALUE_MX,
            self::VALUE_FM,
            self::VALUE_MD,
            self::VALUE_MC,
            self::VALUE_MN,
            self::VALUE_MS,
            self::VALUE_MA,
            self::VALUE_MZ,
            self::VALUE_MM,
            self::VALUE_NA,
            self::VALUE_NR,
            self::VALUE_NP,
            self::VALUE_NL,
            self::VALUE_AN,
            self::VALUE_NC,
            self::VALUE_NZ,
            self::VALUE_NI,
            self::VALUE_NE,
            self::VALUE_NG,
            self::VALUE_NU,
            self::VALUE_NF,
            self::VALUE_MP,
            self::VALUE_NO,
            self::VALUE_OM,
            self::VALUE_PK,
            self::VALUE_PW,
            self::VALUE_PS,
            self::VALUE_PA,
            self::VALUE_PG,
            self::VALUE_PY,
            self::VALUE_PE,
            self::VALUE_PH,
            self::VALUE_PN,
            self::VALUE_PL,
            self::VALUE_PT,
            self::VALUE_PR,
            self::VALUE_QA,
            self::VALUE_RE,
            self::VALUE_RO,
            self::VALUE_RU,
            self::VALUE_RW,
            self::VALUE_SH,
            self::VALUE_KN,
            self::VALUE_LC,
            self::VALUE_PM,
            self::VALUE_VC,
            self::VALUE_WS,
            self::VALUE_SM,
            self::VALUE_ST,
            self::VALUE_SA,
            self::VALUE_SN,
            self::VALUE_SC,
            self::VALUE_SL,
            self::VALUE_SG,
            self::VALUE_SK,
            self::VALUE_SI,
            self::VALUE_SB,
            self::VALUE_SO,
            self::VALUE_ZA,
            self::VALUE_GS,
            self::VALUE_ES,
            self::VALUE_LK,
            self::VALUE_SD,
            self::VALUE_SR,
            self::VALUE_SJ,
            self::VALUE_SZ,
            self::VALUE_SE,
            self::VALUE_CH,
            self::VALUE_SY,
            self::VALUE_TW,
            self::VALUE_TJ,
            self::VALUE_TZ,
            self::VALUE_TH,
            self::VALUE_TG,
            self::VALUE_TK,
            self::VALUE_TO,
            self::VALUE_TT,
            self::VALUE_TN,
            self::VALUE_TR,
            self::VALUE_TM,
            self::VALUE_TC,
            self::VALUE_TV,
            self::VALUE_UG,
            self::VALUE_UA,
            self::VALUE_AE,
            self::VALUE_GB,
            self::VALUE_US,
            self::VALUE_UM,
            self::VALUE_UY,
            self::VALUE_UZ,
            self::VALUE_VU,
            self::VALUE_VE,
            self::VALUE_VN,
            self::VALUE_VG,
            self::VALUE_VI,
            self::VALUE_WF,
            self::VALUE_EH,
            self::VALUE_YE,
            self::VALUE_YU,
            self::VALUE_ZM,
            self::VALUE_ZW,
            self::VALUE_AA,
            self::VALUE_QM,
            self::VALUE_QN,
            self::VALUE_QO,
            self::VALUE_QP,
            self::VALUE_JE,
            self::VALUE_GG,
            self::VALUE_ZZ,
            self::VALUE_RS,
            self::VALUE_ME,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
