<?php

namespace ebaySdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBaySellingRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Retrieves information regarding the user's selling activity, such as items that the user is currently selling (the Active list), auction listings that have bids, sold items, and unsold items.
 * @subpackage Structs
 */
class GetMyeBaySellingRequestType extends AbstractRequestType
{
    /**
     * The ScheduledList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>ScheduledList.Include</b> field to <code>true</code> to return the list of items that are scheduled to become active listings on eBay.com at a future date/time. <br><br> The user also has the
     * option of using pagination and sorting for the list of Scheduled listings that will be returned.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\ItemListCustomizationType
     */
    public $ScheduledList;
    /**
     * The ActiveList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>ActiveList.Include</b> field to <code>true</code> to return the list of active listings on eBay.com. <br><br> The user also has the option of using pagination and sorting for the list of active
     * listings that will be returned.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\ItemListCustomizationType
     */
    public $ActiveList;
    /**
     * The SoldList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>SoldList.Include</b> field to <code>true</code> to return the list of sold order line items. <br><br> The user also has the option of using pagination and sorting for the list of sold items that
     * will be returned.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\ItemListCustomizationType
     */
    public $SoldList;
    /**
     * The UnsoldList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>UnsoldList.Include</b> field to <code>true</code> to return the listings that have ended without a purchase. <br><br> The user also has the option of using pagination and sorting for the list of
     * unsold items that will be returned.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\ItemListCustomizationType
     */
    public $UnsoldList;
    /**
     * The BidList
     * Meta information extracted from the WSDL
     * - documentation: This container is deprecated as a Bid List is no longer returned in <b>GetMyeBaySelling</b>.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\ItemListCustomizationType
     */
    public $BidList;
    /**
     * The DeletedFromSoldList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>DeletedFromSoldList.Include</b> field to <code>true</code> to return the list of sold order line items that have since been deleted from the seller's My eBay page. <br><br> The user also has the
     * option of using pagination and sorting for the list of deleted, sold items that will be returned.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\ItemListCustomizationType
     */
    public $DeletedFromSoldList;
    /**
     * The DeletedFromUnsoldList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>DeletedFromUnsoldList.Include</b> field to <code>true</code> to return the list of unsold order line items that have since been deleted from the seller's My eBay page. <br><br> The user also has
     * the option of using pagination and sorting for the list of deleted, unsold items that will be returned.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\ItemListCustomizationType
     */
    public $DeletedFromUnsoldList;
    /**
     * The SellingSummary
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>SellingSummary.Include</b> field to <code>true</code> to return the <b>SellingSummary</b> container in the response. The <b>SellingSummary</b> container consists of selling activity counts and
     * values.
     * - minOccurs: 0
     * @var \ebaySdk\StructType\ItemListCustomizationType
     */
    public $SellingSummary;
    /**
     * The HideVariations
     * Meta information extracted from the WSDL
     * - documentation: If this field is included and set to <code>true</code>, the <b>Variations</b> node (and all variation data) is omitted for all multiple-variation listings in the response. If this field is omitted or set to <code>false</code>, the
     * <b>Variations</b> node is returned for all multiple-variation listings in the response. <br>
     * - minOccurs: 0
     * @var bool
     */
    public $HideVariations;
    /**
     * Constructor method for GetMyeBaySellingRequestType
     * @uses GetMyeBaySellingRequestType::setScheduledList()
     * @uses GetMyeBaySellingRequestType::setActiveList()
     * @uses GetMyeBaySellingRequestType::setSoldList()
     * @uses GetMyeBaySellingRequestType::setUnsoldList()
     * @uses GetMyeBaySellingRequestType::setBidList()
     * @uses GetMyeBaySellingRequestType::setDeletedFromSoldList()
     * @uses GetMyeBaySellingRequestType::setDeletedFromUnsoldList()
     * @uses GetMyeBaySellingRequestType::setSellingSummary()
     * @uses GetMyeBaySellingRequestType::setHideVariations()
     * @param \ebaySdk\StructType\ItemListCustomizationType $scheduledList
     * @param \ebaySdk\StructType\ItemListCustomizationType $activeList
     * @param \ebaySdk\StructType\ItemListCustomizationType $soldList
     * @param \ebaySdk\StructType\ItemListCustomizationType $unsoldList
     * @param \ebaySdk\StructType\ItemListCustomizationType $bidList
     * @param \ebaySdk\StructType\ItemListCustomizationType $deletedFromSoldList
     * @param \ebaySdk\StructType\ItemListCustomizationType $deletedFromUnsoldList
     * @param \ebaySdk\StructType\ItemListCustomizationType $sellingSummary
     * @param bool $hideVariations
     */
    public function __construct(\ebaySdk\StructType\ItemListCustomizationType $scheduledList = null, \ebaySdk\StructType\ItemListCustomizationType $activeList = null, \ebaySdk\StructType\ItemListCustomizationType $soldList = null, \ebaySdk\StructType\ItemListCustomizationType $unsoldList = null, \ebaySdk\StructType\ItemListCustomizationType $bidList = null, \ebaySdk\StructType\ItemListCustomizationType $deletedFromSoldList = null, \ebaySdk\StructType\ItemListCustomizationType $deletedFromUnsoldList = null, \ebaySdk\StructType\ItemListCustomizationType $sellingSummary = null, $hideVariations = null)
    {
        $this
            ->setScheduledList($scheduledList)
            ->setActiveList($activeList)
            ->setSoldList($soldList)
            ->setUnsoldList($unsoldList)
            ->setBidList($bidList)
            ->setDeletedFromSoldList($deletedFromSoldList)
            ->setDeletedFromUnsoldList($deletedFromUnsoldList)
            ->setSellingSummary($sellingSummary)
            ->setHideVariations($hideVariations);
    }
    /**
     * Get ScheduledList value
     * @return \ebaySdk\StructType\ItemListCustomizationType|null
     */
    public function getScheduledList()
    {
        return $this->ScheduledList;
    }
    /**
     * Set ScheduledList value
     * @param \ebaySdk\StructType\ItemListCustomizationType $scheduledList
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setScheduledList(\ebaySdk\StructType\ItemListCustomizationType $scheduledList = null)
    {
        $this->ScheduledList = $scheduledList;
        return $this;
    }
    /**
     * Get ActiveList value
     * @return \ebaySdk\StructType\ItemListCustomizationType|null
     */
    public function getActiveList()
    {
        return $this->ActiveList;
    }
    /**
     * Set ActiveList value
     * @param \ebaySdk\StructType\ItemListCustomizationType $activeList
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setActiveList(\ebaySdk\StructType\ItemListCustomizationType $activeList = null)
    {
        $this->ActiveList = $activeList;
        return $this;
    }
    /**
     * Get SoldList value
     * @return \ebaySdk\StructType\ItemListCustomizationType|null
     */
    public function getSoldList()
    {
        return $this->SoldList;
    }
    /**
     * Set SoldList value
     * @param \ebaySdk\StructType\ItemListCustomizationType $soldList
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setSoldList(\ebaySdk\StructType\ItemListCustomizationType $soldList = null)
    {
        $this->SoldList = $soldList;
        return $this;
    }
    /**
     * Get UnsoldList value
     * @return \ebaySdk\StructType\ItemListCustomizationType|null
     */
    public function getUnsoldList()
    {
        return $this->UnsoldList;
    }
    /**
     * Set UnsoldList value
     * @param \ebaySdk\StructType\ItemListCustomizationType $unsoldList
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setUnsoldList(\ebaySdk\StructType\ItemListCustomizationType $unsoldList = null)
    {
        $this->UnsoldList = $unsoldList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \ebaySdk\StructType\ItemListCustomizationType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \ebaySdk\StructType\ItemListCustomizationType $bidList
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setBidList(\ebaySdk\StructType\ItemListCustomizationType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get DeletedFromSoldList value
     * @return \ebaySdk\StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromSoldList()
    {
        return $this->DeletedFromSoldList;
    }
    /**
     * Set DeletedFromSoldList value
     * @param \ebaySdk\StructType\ItemListCustomizationType $deletedFromSoldList
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setDeletedFromSoldList(\ebaySdk\StructType\ItemListCustomizationType $deletedFromSoldList = null)
    {
        $this->DeletedFromSoldList = $deletedFromSoldList;
        return $this;
    }
    /**
     * Get DeletedFromUnsoldList value
     * @return \ebaySdk\StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromUnsoldList()
    {
        return $this->DeletedFromUnsoldList;
    }
    /**
     * Set DeletedFromUnsoldList value
     * @param \ebaySdk\StructType\ItemListCustomizationType $deletedFromUnsoldList
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setDeletedFromUnsoldList(\ebaySdk\StructType\ItemListCustomizationType $deletedFromUnsoldList = null)
    {
        $this->DeletedFromUnsoldList = $deletedFromUnsoldList;
        return $this;
    }
    /**
     * Get SellingSummary value
     * @return \ebaySdk\StructType\ItemListCustomizationType|null
     */
    public function getSellingSummary()
    {
        return $this->SellingSummary;
    }
    /**
     * Set SellingSummary value
     * @param \ebaySdk\StructType\ItemListCustomizationType $sellingSummary
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setSellingSummary(\ebaySdk\StructType\ItemListCustomizationType $sellingSummary = null)
    {
        $this->SellingSummary = $sellingSummary;
        return $this;
    }
    /**
     * Get HideVariations value
     * @return bool|null
     */
    public function getHideVariations()
    {
        return $this->HideVariations;
    }
    /**
     * Set HideVariations value
     * @param bool $hideVariations
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public function setHideVariations($hideVariations = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideVariations) && !is_bool($hideVariations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideVariations, true), gettype($hideVariations)), __LINE__);
        }
        $this->HideVariations = $hideVariations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebaySdk\StructType\GetMyeBaySellingRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
