<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://developer.ebay.com/webservices/latest/ebaySvc.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://developer.ebay.com/webservices/latest/ebaySvc.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \EbaySdk\ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \EbaySdk\ServiceType\Add($options);
$add->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for AddDispute operation/method
 */
if ($add->AddDispute(new \EbaySdk\StructType\AddDisputeRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDisputeResponse operation/method
 */
if ($add->AddDisputeResponse(new \EbaySdk\StructType\AddDisputeResponseRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddFixedPriceItem operation/method
 */
if ($add->AddFixedPriceItem(new \EbaySdk\StructType\AddFixedPriceItemRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItem operation/method
 */
if ($add->AddItem(new \EbaySdk\StructType\AddItemRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItemFromSellingManagerTemplate operation/method
 */
if ($add->AddItemFromSellingManagerTemplate(new \EbaySdk\StructType\AddItemFromSellingManagerTemplateRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItems operation/method
 */
if ($add->AddItems(new \EbaySdk\StructType\AddItemsRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMemberMessageAAQToPartner operation/method
 */
if ($add->AddMemberMessageAAQToPartner(new \EbaySdk\StructType\AddMemberMessageAAQToPartnerRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMemberMessageRTQ operation/method
 */
if ($add->AddMemberMessageRTQ(new \EbaySdk\StructType\AddMemberMessageRTQRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMemberMessagesAAQToBidder operation/method
 */
if ($add->AddMemberMessagesAAQToBidder(new \EbaySdk\StructType\AddMemberMessagesAAQToBidderRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddOrder operation/method
 */
if ($add->AddOrder(new \EbaySdk\StructType\AddOrderRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSecondChanceItem operation/method
 */
if ($add->AddSecondChanceItem(new \EbaySdk\StructType\AddSecondChanceItemRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSellingManagerInventoryFolder operation/method
 */
if ($add->AddSellingManagerInventoryFolder(new \EbaySdk\StructType\AddSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSellingManagerProduct operation/method
 */
if ($add->AddSellingManagerProduct(new \EbaySdk\StructType\AddSellingManagerProductRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSellingManagerTemplate operation/method
 */
if ($add->AddSellingManagerTemplate(new \EbaySdk\StructType\AddSellingManagerTemplateRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddToItemDescription operation/method
 */
if ($add->AddToItemDescription(new \EbaySdk\StructType\AddToItemDescriptionRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddToWatchList operation/method
 */
if ($add->AddToWatchList(new \EbaySdk\StructType\AddToWatchListRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTransactionConfirmationItem operation/method
 */
if ($add->AddTransactionConfirmationItem(new \EbaySdk\StructType\AddTransactionConfirmationItemRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Complete ServiceType
 */
$complete = new \EbaySdk\ServiceType\Complete($options);
$complete->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for CompleteSale operation/method
 */
if ($complete->CompleteSale(new \EbaySdk\StructType\CompleteSaleRequestType()) !== false) {
    print_r($complete->getResult());
} else {
    print_r($complete->getLastError());
}
/**
 * Samples for Confirm ServiceType
 */
$confirm = new \EbaySdk\ServiceType\Confirm($options);
$confirm->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for ConfirmIdentity operation/method
 */
if ($confirm->ConfirmIdentity(new \EbaySdk\StructType\ConfirmIdentityRequestType()) !== false) {
    print_r($confirm->getResult());
} else {
    print_r($confirm->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \EbaySdk\ServiceType\Delete($options);
$delete->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for DeleteMyMessages operation/method
 */
if ($delete->DeleteMyMessages(new \EbaySdk\StructType\DeleteMyMessagesRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerInventoryFolder operation/method
 */
if ($delete->DeleteSellingManagerInventoryFolder(new \EbaySdk\StructType\DeleteSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerItemAutomationRule operation/method
 */
if ($delete->DeleteSellingManagerItemAutomationRule(new \EbaySdk\StructType\DeleteSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerProduct operation/method
 */
if ($delete->DeleteSellingManagerProduct(new \EbaySdk\StructType\DeleteSellingManagerProductRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerTemplate operation/method
 */
if ($delete->DeleteSellingManagerTemplate(new \EbaySdk\StructType\DeleteSellingManagerTemplateRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerTemplateAutomationRule operation/method
 */
if ($delete->DeleteSellingManagerTemplateAutomationRule(new \EbaySdk\StructType\DeleteSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Disable ServiceType
 */
$disable = new \EbaySdk\ServiceType\Disable($options);
$disable->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for DisableUnpaidItemAssistance operation/method
 */
if ($disable->DisableUnpaidItemAssistance(new \EbaySdk\StructType\DisableUnpaidItemAssistanceRequestType()) !== false) {
    print_r($disable->getResult());
} else {
    print_r($disable->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \EbaySdk\ServiceType\End($options);
$end->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for EndFixedPriceItem operation/method
 */
if ($end->EndFixedPriceItem(new \EbaySdk\StructType\EndFixedPriceItemRequestType()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Sample call for EndItem operation/method
 */
if ($end->EndItem(new \EbaySdk\StructType\EndItemRequestType()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Sample call for EndItems operation/method
 */
if ($end->EndItems(new \EbaySdk\StructType\EndItemsRequestType()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Extend ServiceType
 */
$extend = new \EbaySdk\ServiceType\Extend($options);
$extend->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for ExtendSiteHostedPictures operation/method
 */
if ($extend->ExtendSiteHostedPictures(new \EbaySdk\StructType\ExtendSiteHostedPicturesRequestType()) !== false) {
    print_r($extend->getResult());
} else {
    print_r($extend->getLastError());
}
/**
 * Samples for Fetch ServiceType
 */
$fetch = new \EbaySdk\ServiceType\Fetch($options);
$fetch->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for FetchToken operation/method
 */
if ($fetch->FetchToken(new \EbaySdk\StructType\FetchTokenRequestType()) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \EbaySdk\ServiceType\Get($options);
$get->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for GetAccount operation/method
 */
if ($get->GetAccount(new \EbaySdk\StructType\GetAccountRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdFormatLeads operation/method
 */
if ($get->GetAdFormatLeads(new \EbaySdk\StructType\GetAdFormatLeadsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllBidders operation/method
 */
if ($get->GetAllBidders(new \EbaySdk\StructType\GetAllBiddersRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetApiAccessRules operation/method
 */
if ($get->GetApiAccessRules(new \EbaySdk\StructType\GetApiAccessRulesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBestOffers operation/method
 */
if ($get->GetBestOffers(new \EbaySdk\StructType\GetBestOffersRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBidderList operation/method
 */
if ($get->GetBidderList(new \EbaySdk\StructType\GetBidderListRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategories operation/method
 */
if ($get->GetCategories(new \EbaySdk\StructType\GetCategoriesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategoryFeatures operation/method
 */
if ($get->GetCategoryFeatures(new \EbaySdk\StructType\GetCategoryFeaturesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategoryMappings operation/method
 */
if ($get->GetCategoryMappings(new \EbaySdk\StructType\GetCategoryMappingsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategorySpecifics operation/method
 */
if ($get->GetCategorySpecifics(new \EbaySdk\StructType\GetCategorySpecificsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetChallengeToken operation/method
 */
if ($get->GetChallengeToken(new \EbaySdk\StructType\GetChallengeTokenRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCharities operation/method
 */
if ($get->GetCharities(new \EbaySdk\StructType\GetCharitiesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientAlertsAuthToken operation/method
 */
if ($get->GetClientAlertsAuthToken(new \EbaySdk\StructType\GetClientAlertsAuthTokenRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContextualKeywords operation/method
 */
if ($get->GetContextualKeywords(new \EbaySdk\StructType\GetContextualKeywordsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDescriptionTemplates operation/method
 */
if ($get->GetDescriptionTemplates(new \EbaySdk\StructType\GetDescriptionTemplatesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDispute operation/method
 */
if ($get->GetDispute(new \EbaySdk\StructType\GetDisputeRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFeedback operation/method
 */
if ($get->GetFeedback(new \EbaySdk\StructType\GetFeedbackRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItem operation/method
 */
if ($get->GetItem(new \EbaySdk\StructType\GetItemRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemShipping operation/method
 */
if ($get->GetItemShipping(new \EbaySdk\StructType\GetItemShippingRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemTransactions operation/method
 */
if ($get->GetItemTransactions(new \EbaySdk\StructType\GetItemTransactionsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemsAwaitingFeedback operation/method
 */
if ($get->GetItemsAwaitingFeedback(new \EbaySdk\StructType\GetItemsAwaitingFeedbackRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMemberMessages operation/method
 */
if ($get->GetMemberMessages(new \EbaySdk\StructType\GetMemberMessagesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMessagePreferences operation/method
 */
if ($get->GetMessagePreferences(new \EbaySdk\StructType\GetMessagePreferencesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyMessages operation/method
 */
if ($get->GetMyMessages(new \EbaySdk\StructType\GetMyMessagesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyeBayBuying operation/method
 */
if ($get->GetMyeBayBuying(new \EbaySdk\StructType\GetMyeBayBuyingRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyeBayReminders operation/method
 */
if ($get->GetMyeBayReminders(new \EbaySdk\StructType\GetMyeBayRemindersRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyeBaySelling operation/method
 */
if ($get->GetMyeBaySelling(new \EbaySdk\StructType\GetMyeBaySellingRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNotificationPreferences operation/method
 */
if ($get->GetNotificationPreferences(new \EbaySdk\StructType\GetNotificationPreferencesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNotificationsUsage operation/method
 */
if ($get->GetNotificationsUsage(new \EbaySdk\StructType\GetNotificationsUsageRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderTransactions operation/method
 */
if ($get->GetOrderTransactions(new \EbaySdk\StructType\GetOrderTransactionsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrders operation/method
 */
if ($get->GetOrders(new \EbaySdk\StructType\GetOrdersRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPromotionalSaleDetails operation/method
 */
if ($get->GetPromotionalSaleDetails(new \EbaySdk\StructType\GetPromotionalSaleDetailsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerDashboard operation/method
 */
if ($get->GetSellerDashboard(new \EbaySdk\StructType\GetSellerDashboardRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerEvents operation/method
 */
if ($get->GetSellerEvents(new \EbaySdk\StructType\GetSellerEventsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerList operation/method
 */
if ($get->GetSellerList(new \EbaySdk\StructType\GetSellerListRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerTransactions operation/method
 */
if ($get->GetSellerTransactions(new \EbaySdk\StructType\GetSellerTransactionsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerAlerts operation/method
 */
if ($get->GetSellingManagerAlerts(new \EbaySdk\StructType\GetSellingManagerAlertsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerEmailLog operation/method
 */
if ($get->GetSellingManagerEmailLog(new \EbaySdk\StructType\GetSellingManagerEmailLogRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerInventory operation/method
 */
if ($get->GetSellingManagerInventory(new \EbaySdk\StructType\GetSellingManagerInventoryRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerInventoryFolder operation/method
 */
if ($get->GetSellingManagerInventoryFolder(new \EbaySdk\StructType\GetSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerItemAutomationRule operation/method
 */
if ($get->GetSellingManagerItemAutomationRule(new \EbaySdk\StructType\GetSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerSaleRecord operation/method
 */
if ($get->GetSellingManagerSaleRecord(new \EbaySdk\StructType\GetSellingManagerSaleRecordRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerSoldListings operation/method
 */
if ($get->GetSellingManagerSoldListings(new \EbaySdk\StructType\GetSellingManagerSoldListingsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerTemplateAutomationRule operation/method
 */
if ($get->GetSellingManagerTemplateAutomationRule(new \EbaySdk\StructType\GetSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerTemplates operation/method
 */
if ($get->GetSellingManagerTemplates(new \EbaySdk\StructType\GetSellingManagerTemplatesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSessionID operation/method
 */
if ($get->GetSessionID(new \EbaySdk\StructType\GetSessionIDRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShippingDiscountProfiles operation/method
 */
if ($get->GetShippingDiscountProfiles(new \EbaySdk\StructType\GetShippingDiscountProfilesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStore operation/method
 */
if ($get->GetStore(new \EbaySdk\StructType\GetStoreRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreCategoryUpdateStatus operation/method
 */
if ($get->GetStoreCategoryUpdateStatus(new \EbaySdk\StructType\GetStoreCategoryUpdateStatusRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreCustomPage operation/method
 */
if ($get->GetStoreCustomPage(new \EbaySdk\StructType\GetStoreCustomPageRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreOptions operation/method
 */
if ($get->GetStoreOptions(new \EbaySdk\StructType\GetStoreOptionsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStorePreferences operation/method
 */
if ($get->GetStorePreferences(new \EbaySdk\StructType\GetStorePreferencesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSuggestedCategories operation/method
 */
if ($get->GetSuggestedCategories(new \EbaySdk\StructType\GetSuggestedCategoriesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTaxTable operation/method
 */
if ($get->GetTaxTable(new \EbaySdk\StructType\GetTaxTableRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTokenStatus operation/method
 */
if ($get->GetTokenStatus(new \EbaySdk\StructType\GetTokenStatusRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUser operation/method
 */
if ($get->GetUser(new \EbaySdk\StructType\GetUserRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserContactDetails operation/method
 */
if ($get->GetUserContactDetails(new \EbaySdk\StructType\GetUserContactDetailsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserDisputes operation/method
 */
if ($get->GetUserDisputes(new \EbaySdk\StructType\GetUserDisputesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserPreferences operation/method
 */
if ($get->GetUserPreferences(new \EbaySdk\StructType\GetUserPreferencesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVeROReasonCodeDetails operation/method
 */
if ($get->GetVeROReasonCodeDetails(new \EbaySdk\StructType\GetVeROReasonCodeDetailsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVeROReportStatus operation/method
 */
if ($get->GetVeROReportStatus(new \EbaySdk\StructType\GetVeROReportStatusRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Gete ServiceType
 */
$gete = new \EbaySdk\ServiceType\Gete($options);
$gete->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for GeteBayDetails operation/method
 */
if ($gete->GeteBayDetails(new \EbaySdk\StructType\GeteBayDetailsRequestType()) !== false) {
    print_r($gete->getResult());
} else {
    print_r($gete->getLastError());
}
/**
 * Sample call for GeteBayOfficialTime operation/method
 */
if ($gete->GeteBayOfficialTime(new \EbaySdk\StructType\GeteBayOfficialTimeRequestType()) !== false) {
    print_r($gete->getResult());
} else {
    print_r($gete->getLastError());
}
/**
 * Samples for Leave ServiceType
 */
$leave = new \EbaySdk\ServiceType\Leave($options);
$leave->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for LeaveFeedback operation/method
 */
if ($leave->LeaveFeedback(new \EbaySdk\StructType\LeaveFeedbackRequestType()) !== false) {
    print_r($leave->getResult());
} else {
    print_r($leave->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \EbaySdk\ServiceType\Move($options);
$move->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for MoveSellingManagerInventoryFolder operation/method
 */
if ($move->MoveSellingManagerInventoryFolder(new \EbaySdk\StructType\MoveSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Place ServiceType
 */
$place = new \EbaySdk\ServiceType\Place($options);
$place->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for PlaceOffer operation/method
 */
if ($place->PlaceOffer(new \EbaySdk\StructType\PlaceOfferRequestType()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Samples for Relist ServiceType
 */
$relist = new \EbaySdk\ServiceType\Relist($options);
$relist->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for RelistFixedPriceItem operation/method
 */
if ($relist->RelistFixedPriceItem(new \EbaySdk\StructType\RelistFixedPriceItemRequestType()) !== false) {
    print_r($relist->getResult());
} else {
    print_r($relist->getLastError());
}
/**
 * Sample call for RelistItem operation/method
 */
if ($relist->RelistItem(new \EbaySdk\StructType\RelistItemRequestType()) !== false) {
    print_r($relist->getResult());
} else {
    print_r($relist->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \EbaySdk\ServiceType\Remove($options);
$remove->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for RemoveFromWatchList operation/method
 */
if ($remove->RemoveFromWatchList(new \EbaySdk\StructType\RemoveFromWatchListRequestType()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Respond ServiceType
 */
$respond = new \EbaySdk\ServiceType\Respond($options);
$respond->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for RespondToBestOffer operation/method
 */
if ($respond->RespondToBestOffer(new \EbaySdk\StructType\RespondToBestOfferRequestType()) !== false) {
    print_r($respond->getResult());
} else {
    print_r($respond->getLastError());
}
/**
 * Sample call for RespondToFeedback operation/method
 */
if ($respond->RespondToFeedback(new \EbaySdk\StructType\RespondToFeedbackRequestType()) !== false) {
    print_r($respond->getResult());
} else {
    print_r($respond->getLastError());
}
/**
 * Samples for Revise ServiceType
 */
$revise = new \EbaySdk\ServiceType\Revise($options);
$revise->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for ReviseCheckoutStatus operation/method
 */
if ($revise->ReviseCheckoutStatus(new \EbaySdk\StructType\ReviseCheckoutStatusRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseFixedPriceItem operation/method
 */
if ($revise->ReviseFixedPriceItem(new \EbaySdk\StructType\ReviseFixedPriceItemRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseInventoryStatus operation/method
 */
if ($revise->ReviseInventoryStatus(new \EbaySdk\StructType\ReviseInventoryStatusRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseItem operation/method
 */
if ($revise->ReviseItem(new \EbaySdk\StructType\ReviseItemRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseMyMessages operation/method
 */
if ($revise->ReviseMyMessages(new \EbaySdk\StructType\ReviseMyMessagesRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseMyMessagesFolders operation/method
 */
if ($revise->ReviseMyMessagesFolders(new \EbaySdk\StructType\ReviseMyMessagesFoldersRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseSellingManagerInventoryFolder operation/method
 */
if ($revise->ReviseSellingManagerInventoryFolder(new \EbaySdk\StructType\ReviseSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseSellingManagerProduct operation/method
 */
if ($revise->ReviseSellingManagerProduct(new \EbaySdk\StructType\ReviseSellingManagerProductRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseSellingManagerSaleRecord operation/method
 */
if ($revise->ReviseSellingManagerSaleRecord(new \EbaySdk\StructType\ReviseSellingManagerSaleRecordRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseSellingManagerTemplate operation/method
 */
if ($revise->ReviseSellingManagerTemplate(new \EbaySdk\StructType\ReviseSellingManagerTemplateRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Samples for Revoke ServiceType
 */
$revoke = new \EbaySdk\ServiceType\Revoke($options);
$revoke->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for RevokeToken operation/method
 */
if ($revoke->RevokeToken(new \EbaySdk\StructType\RevokeTokenRequestType()) !== false) {
    print_r($revoke->getResult());
} else {
    print_r($revoke->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \EbaySdk\ServiceType\Save($options);
$save->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for SaveItemToSellingManagerTemplate operation/method
 */
if ($save->SaveItemToSellingManagerTemplate(new \EbaySdk\StructType\SaveItemToSellingManagerTemplateRequestType()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Seller ServiceType
 */
$seller = new \EbaySdk\ServiceType\Seller($options);
$seller->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for SellerReverseDispute operation/method
 */
if ($seller->SellerReverseDispute(new \EbaySdk\StructType\SellerReverseDisputeRequestType()) !== false) {
    print_r($seller->getResult());
} else {
    print_r($seller->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \EbaySdk\ServiceType\Send($options);
$send->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for SendInvoice operation/method
 */
if ($send->SendInvoice(new \EbaySdk\StructType\SendInvoiceRequestType()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \EbaySdk\ServiceType\Set($options);
$set->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for SetMessagePreferences operation/method
 */
if ($set->SetMessagePreferences(new \EbaySdk\StructType\SetMessagePreferencesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetNotificationPreferences operation/method
 */
if ($set->SetNotificationPreferences(new \EbaySdk\StructType\SetNotificationPreferencesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPromotionalSale operation/method
 */
if ($set->SetPromotionalSale(new \EbaySdk\StructType\SetPromotionalSaleRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPromotionalSaleListings operation/method
 */
if ($set->SetPromotionalSaleListings(new \EbaySdk\StructType\SetPromotionalSaleListingsRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSellingManagerFeedbackOptions operation/method
 */
if ($set->SetSellingManagerFeedbackOptions(new \EbaySdk\StructType\SetSellingManagerFeedbackOptionsRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSellingManagerItemAutomationRule operation/method
 */
if ($set->SetSellingManagerItemAutomationRule(new \EbaySdk\StructType\SetSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSellingManagerTemplateAutomationRule operation/method
 */
if ($set->SetSellingManagerTemplateAutomationRule(new \EbaySdk\StructType\SetSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetShippingDiscountProfiles operation/method
 */
if ($set->SetShippingDiscountProfiles(new \EbaySdk\StructType\SetShippingDiscountProfilesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStore operation/method
 */
if ($set->SetStore(new \EbaySdk\StructType\SetStoreRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStoreCategories operation/method
 */
if ($set->SetStoreCategories(new \EbaySdk\StructType\SetStoreCategoriesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStoreCustomPage operation/method
 */
if ($set->SetStoreCustomPage(new \EbaySdk\StructType\SetStoreCustomPageRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStorePreferences operation/method
 */
if ($set->SetStorePreferences(new \EbaySdk\StructType\SetStorePreferencesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetTaxTable operation/method
 */
if ($set->SetTaxTable(new \EbaySdk\StructType\SetTaxTableRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUserNotes operation/method
 */
if ($set->SetUserNotes(new \EbaySdk\StructType\SetUserNotesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUserPreferences operation/method
 */
if ($set->SetUserPreferences(new \EbaySdk\StructType\SetUserPreferencesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \EbaySdk\ServiceType\Upload($options);
$upload->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for UploadSiteHostedPictures operation/method
 */
if ($upload->UploadSiteHostedPictures(new \EbaySdk\StructType\UploadSiteHostedPicturesRequestType()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \EbaySdk\ServiceType\Validate($options);
$validate->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for ValidateChallengeInput operation/method
 */
if ($validate->ValidateChallengeInput(new \EbaySdk\StructType\ValidateChallengeInputRequestType()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateTestUserRegistration operation/method
 */
if ($validate->ValidateTestUserRegistration(new \EbaySdk\StructType\ValidateTestUserRegistrationRequestType()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Ve ServiceType
 */
$ve = new \EbaySdk\ServiceType\Ve($options);
$ve->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for VeROReportItems operation/method
 */
if ($ve->VeROReportItems(new \EbaySdk\StructType\VeROReportItemsRequestType()) !== false) {
    print_r($ve->getResult());
} else {
    print_r($ve->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \EbaySdk\ServiceType\Verify($options);
$verify->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for VerifyAddFixedPriceItem operation/method
 */
if ($verify->VerifyAddFixedPriceItem(new \EbaySdk\StructType\VerifyAddFixedPriceItemRequestType()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyAddItem operation/method
 */
if ($verify->VerifyAddItem(new \EbaySdk\StructType\VerifyAddItemRequestType()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyAddSecondChanceItem operation/method
 */
if ($verify->VerifyAddSecondChanceItem(new \EbaySdk\StructType\VerifyAddSecondChanceItemRequestType()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyRelistItem operation/method
 */
if ($verify->VerifyRelistItem(new \EbaySdk\StructType\VerifyRelistItemRequestType()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
