<?php

namespace EbaySdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiLegShippingDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type provides information about the domestic leg of a Global Shipping Program shipment. <br/><br/> <span class="tablenote"> <strong>Note:</strong> The <strong>LogisticsProviderShipmentToBuyer</strong> field is reserved for the
 * exclusive use of the international shipping provider. </span>
 * @subpackage Structs
 */
class MultiLegShippingDetailsType extends AbstractStructBase
{
    /**
     * The SellerShipmentToLogisticsProvider
     * Meta information extracted from the WSDL
     * - documentation: Contains information about the domestic leg of a Global Shipping Programn shipment, including the seller-selected shipping service, the domestic shipping cost, the domestic address of the international shipping provider, and the
     * estimated shipping time range.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \EbaySdk\StructType\MultiLegShipmentType
     */
    public $SellerShipmentToLogisticsProvider;
    /**
     * The LogisticsProviderShipmentToBuyer
     * Meta information extracted from the WSDL
     * - documentation: Reserved for use by the international shipping provider.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \EbaySdk\StructType\MultiLegShipmentType
     */
    public $LogisticsProviderShipmentToBuyer;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for MultiLegShippingDetailsType
     * @uses MultiLegShippingDetailsType::setSellerShipmentToLogisticsProvider()
     * @uses MultiLegShippingDetailsType::setLogisticsProviderShipmentToBuyer()
     * @uses MultiLegShippingDetailsType::setAny()
     * @param \EbaySdk\StructType\MultiLegShipmentType $sellerShipmentToLogisticsProvider
     * @param \EbaySdk\StructType\MultiLegShipmentType $logisticsProviderShipmentToBuyer
     * @param \DOMDocument $any
     */
    public function __construct(\EbaySdk\StructType\MultiLegShipmentType $sellerShipmentToLogisticsProvider = null, \EbaySdk\StructType\MultiLegShipmentType $logisticsProviderShipmentToBuyer = null, \DOMDocument $any = null)
    {
        $this
            ->setSellerShipmentToLogisticsProvider($sellerShipmentToLogisticsProvider)
            ->setLogisticsProviderShipmentToBuyer($logisticsProviderShipmentToBuyer)
            ->setAny($any);
    }
    /**
     * Get SellerShipmentToLogisticsProvider value
     * @return \EbaySdk\StructType\MultiLegShipmentType|null
     */
    public function getSellerShipmentToLogisticsProvider()
    {
        return $this->SellerShipmentToLogisticsProvider;
    }
    /**
     * Set SellerShipmentToLogisticsProvider value
     * @param \EbaySdk\StructType\MultiLegShipmentType $sellerShipmentToLogisticsProvider
     * @return \EbaySdk\StructType\MultiLegShippingDetailsType
     */
    public function setSellerShipmentToLogisticsProvider(\EbaySdk\StructType\MultiLegShipmentType $sellerShipmentToLogisticsProvider = null)
    {
        $this->SellerShipmentToLogisticsProvider = $sellerShipmentToLogisticsProvider;
        return $this;
    }
    /**
     * Get LogisticsProviderShipmentToBuyer value
     * @return \EbaySdk\StructType\MultiLegShipmentType|null
     */
    public function getLogisticsProviderShipmentToBuyer()
    {
        return $this->LogisticsProviderShipmentToBuyer;
    }
    /**
     * Set LogisticsProviderShipmentToBuyer value
     * @param \EbaySdk\StructType\MultiLegShipmentType $logisticsProviderShipmentToBuyer
     * @return \EbaySdk\StructType\MultiLegShippingDetailsType
     */
    public function setLogisticsProviderShipmentToBuyer(\EbaySdk\StructType\MultiLegShipmentType $logisticsProviderShipmentToBuyer = null)
    {
        $this->LogisticsProviderShipmentToBuyer = $logisticsProviderShipmentToBuyer;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \EbaySdk\StructType\MultiLegShippingDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EbaySdk\StructType\MultiLegShippingDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
