<?php

namespace EbaySdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSellingManagerItemAutomationRuleResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the set of automation rules associated with the specified item.
 * @subpackage Structs
 */
class SetSellingManagerItemAutomationRuleResponseType extends AbstractResponseType
{
    /**
     * The AutomatedListingRule
     * Meta information extracted from the WSDL
     * - documentation: Contains the automated listing rule associated with this item.
     * - minOccurs: 0
     * @var \EbaySdk\StructType\SellingManagerAutoListType
     */
    public $AutomatedListingRule;
    /**
     * The AutomatedRelistingRule
     * Meta information extracted from the WSDL
     * - documentation: Contains the automated relisting rule associated with this item.
     * - minOccurs: 0
     * @var \EbaySdk\StructType\SellingManagerAutoRelistType
     */
    public $AutomatedRelistingRule;
    /**
     * The AutomatedSecondChanceOfferRule
     * Meta information extracted from the WSDL
     * - documentation: Contains the automated Second Chance Offer rule associated with this item.
     * - minOccurs: 0
     * @var \EbaySdk\StructType\SellingManagerAutoSecondChanceOfferType
     */
    public $AutomatedSecondChanceOfferRule;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Contains fees that may be incurred when items are listed using the automation rules (e.g., a scheduled listing fee). Use of an automation rule does not in itself have a fee, but use can result in a fee.
     * - minOccurs: 0
     * @var \EbaySdk\StructType\FeesType
     */
    public $Fees;
    /**
     * Constructor method for SetSellingManagerItemAutomationRuleResponseType
     * @uses SetSellingManagerItemAutomationRuleResponseType::setAutomatedListingRule()
     * @uses SetSellingManagerItemAutomationRuleResponseType::setAutomatedRelistingRule()
     * @uses SetSellingManagerItemAutomationRuleResponseType::setAutomatedSecondChanceOfferRule()
     * @uses SetSellingManagerItemAutomationRuleResponseType::setFees()
     * @param \EbaySdk\StructType\SellingManagerAutoListType $automatedListingRule
     * @param \EbaySdk\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @param \EbaySdk\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @param \EbaySdk\StructType\FeesType $fees
     */
    public function __construct(\EbaySdk\StructType\SellingManagerAutoListType $automatedListingRule = null, \EbaySdk\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null, \EbaySdk\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null, \EbaySdk\StructType\FeesType $fees = null)
    {
        $this
            ->setAutomatedListingRule($automatedListingRule)
            ->setAutomatedRelistingRule($automatedRelistingRule)
            ->setAutomatedSecondChanceOfferRule($automatedSecondChanceOfferRule)
            ->setFees($fees);
    }
    /**
     * Get AutomatedListingRule value
     * @return \EbaySdk\StructType\SellingManagerAutoListType|null
     */
    public function getAutomatedListingRule()
    {
        return $this->AutomatedListingRule;
    }
    /**
     * Set AutomatedListingRule value
     * @param \EbaySdk\StructType\SellingManagerAutoListType $automatedListingRule
     * @return \EbaySdk\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public function setAutomatedListingRule(\EbaySdk\StructType\SellingManagerAutoListType $automatedListingRule = null)
    {
        $this->AutomatedListingRule = $automatedListingRule;
        return $this;
    }
    /**
     * Get AutomatedRelistingRule value
     * @return \EbaySdk\StructType\SellingManagerAutoRelistType|null
     */
    public function getAutomatedRelistingRule()
    {
        return $this->AutomatedRelistingRule;
    }
    /**
     * Set AutomatedRelistingRule value
     * @param \EbaySdk\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @return \EbaySdk\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public function setAutomatedRelistingRule(\EbaySdk\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null)
    {
        $this->AutomatedRelistingRule = $automatedRelistingRule;
        return $this;
    }
    /**
     * Get AutomatedSecondChanceOfferRule value
     * @return \EbaySdk\StructType\SellingManagerAutoSecondChanceOfferType|null
     */
    public function getAutomatedSecondChanceOfferRule()
    {
        return $this->AutomatedSecondChanceOfferRule;
    }
    /**
     * Set AutomatedSecondChanceOfferRule value
     * @param \EbaySdk\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @return \EbaySdk\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public function setAutomatedSecondChanceOfferRule(\EbaySdk\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null)
    {
        $this->AutomatedSecondChanceOfferRule = $automatedSecondChanceOfferRule;
        return $this;
    }
    /**
     * Get Fees value
     * @return \EbaySdk\StructType\FeesType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \EbaySdk\StructType\FeesType $fees
     * @return \EbaySdk\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public function setFees(\EbaySdk\StructType\FeesType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EbaySdk\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
