<?php

namespace EbaySdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetItemShippingResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the base response type of the <b>GetItemShipping</b> call. This call takes an <b>ItemID</b> value for an item that has yet to be shipped, and then returns estimated shipping costs for every shipping service that the seller
 * has offered with the listing. This call will also return the <b>PickUpInStoreDetails.EligibleForPickupInStore</b> flag if the item is available for buyer pick-up through the In-Store Pickup feature.
 * @subpackage Structs
 */
class GetItemShippingResponseType extends AbstractResponseType
{
    /**
     * The ShippingDetails
     * Meta information extracted from the WSDL
     * - documentation: This container will be returned if at least one domestic or international shipping service option is available for the item. A <b>ShippingServiceOptions</b> (for domestic shipping) and/or an <b>InternationalShippingServiceOptions</b>
     * container (for international shipping) is returned for each available calculated shipping service option. These shipping service option containers consists of estimated shipping cost and estimated shipping times. <br> <br> Any error about shipping
     * services (returned by a vendor of eBay's who calculates shipping costs) is returned in <b>ShippingRateErrorMessage</b>. Errors from a shipping service are likely to be related to issues with shipping specifications, such as package size and the
     * selected shipping method not supported by a particular shipping service.
     * - minOccurs: 0
     * @var \EbaySdk\StructType\ShippingDetailsType
     */
    public $ShippingDetails;
    /**
     * The PickUpInStoreDetails
     * Meta information extracted from the WSDL
     * - documentation: This container is only returned in <b>GetItemShipping</b> if the In-Store Pickup feature is enabled for the listing. In-Store Pickup as a fulfillment method is only available to a limited number of large retail merchants in the US,
     * Canada, UK, Germany, and Australia marketplaces. The In-Store Pickup feature can only be applied to multiple-quantity, fixed-price listings, and the merchant must have quantity of the item available in a store that is near the prospective buyer, in
     * order for In-Store Pickup to be an available fulfillment option for that buyer.
     * - minOccurs: 0
     * @var \EbaySdk\StructType\PickupInStoreDetailsType
     */
    public $PickUpInStoreDetails;
    /**
     * Constructor method for GetItemShippingResponseType
     * @uses GetItemShippingResponseType::setShippingDetails()
     * @uses GetItemShippingResponseType::setPickUpInStoreDetails()
     * @param \EbaySdk\StructType\ShippingDetailsType $shippingDetails
     * @param \EbaySdk\StructType\PickupInStoreDetailsType $pickUpInStoreDetails
     */
    public function __construct(\EbaySdk\StructType\ShippingDetailsType $shippingDetails = null, \EbaySdk\StructType\PickupInStoreDetailsType $pickUpInStoreDetails = null)
    {
        $this
            ->setShippingDetails($shippingDetails)
            ->setPickUpInStoreDetails($pickUpInStoreDetails);
    }
    /**
     * Get ShippingDetails value
     * @return \EbaySdk\StructType\ShippingDetailsType|null
     */
    public function getShippingDetails()
    {
        return $this->ShippingDetails;
    }
    /**
     * Set ShippingDetails value
     * @param \EbaySdk\StructType\ShippingDetailsType $shippingDetails
     * @return \EbaySdk\StructType\GetItemShippingResponseType
     */
    public function setShippingDetails(\EbaySdk\StructType\ShippingDetailsType $shippingDetails = null)
    {
        $this->ShippingDetails = $shippingDetails;
        return $this;
    }
    /**
     * Get PickUpInStoreDetails value
     * @return \EbaySdk\StructType\PickupInStoreDetailsType|null
     */
    public function getPickUpInStoreDetails()
    {
        return $this->PickUpInStoreDetails;
    }
    /**
     * Set PickUpInStoreDetails value
     * @param \EbaySdk\StructType\PickupInStoreDetailsType $pickUpInStoreDetails
     * @return \EbaySdk\StructType\GetItemShippingResponseType
     */
    public function setPickUpInStoreDetails(\EbaySdk\StructType\PickupInStoreDetailsType $pickUpInStoreDetails = null)
    {
        $this->PickUpInStoreDetails = $pickUpInStoreDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EbaySdk\StructType\GetItemShippingResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
