<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fahrenheit ServiceType
 * @subpackage Services
 */
class Fahrenheit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FahrenheitToCelsius
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FahrenheitToCelsius $parameters
     * @return \StructType\FahrenheitToCelsiusResponse|bool
     */
    public function FahrenheitToCelsius(\StructType\FahrenheitToCelsius $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FahrenheitToCelsius($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FahrenheitToCelsiusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
