<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayRemindersResponseType Structs
 * Meta information extracted from the WSDL
 * - documentation: This is the base response type of the <b>GetMyeBayReminders</b> call. This call returns the total counts for My eBay Buying and/or My eBay Selling Reminders for a user.
 * @subpackage Structs
 */
class GetMyeBayRemindersResponseType extends AbstractResponseType
{
    /**
     * The BuyingReminders
     * Meta information extracted from the WSDL
     * - documentation: This container is returned if the user included the <b>BuyingReminders</b> container in the call request and set the <b>BuyingReminders.Include</b> value to <code>true</code>. Counts will only be retrieved for My eBay Buying
     * Reminders that the user received during the number of days specified in the <b>BuyingReminders.DurationInDays</b> field in the call request.
     * - minOccurs: 0
     * @var \Structs\RemindersType
     */
    public $BuyingReminders;
    /**
     * The SellingReminders
     * Meta information extracted from the WSDL
     * - documentation: This container is returned if the user included the <b>SellingReminders</b> container in the call request and set the <b>SellingReminders.Include</b> value to <code>true</code>. Counts will only be retrieved for My eBay Selling
     * Reminders that the user received during the number of days specified in the <b>SellingReminders.DurationInDays</b> field in the call request.
     * - minOccurs: 0
     * @var \Structs\RemindersType
     */
    public $SellingReminders;
    /**
     * Constructor method for GetMyeBayRemindersResponseType
     * @uses GetMyeBayRemindersResponseType::setBuyingReminders()
     * @uses GetMyeBayRemindersResponseType::setSellingReminders()
     * @param \Structs\RemindersType $buyingReminders
     * @param \Structs\RemindersType $sellingReminders
     */
    public function __construct(\Structs\RemindersType $buyingReminders = null, \Structs\RemindersType $sellingReminders = null)
    {
        $this
            ->setBuyingReminders($buyingReminders)
            ->setSellingReminders($sellingReminders);
    }
    /**
     * Get BuyingReminders value
     * @return \Structs\RemindersType|null
     */
    public function getBuyingReminders()
    {
        return $this->BuyingReminders;
    }
    /**
     * Set BuyingReminders value
     * @param \Structs\RemindersType $buyingReminders
     * @return \Structs\GetMyeBayRemindersResponseType
     */
    public function setBuyingReminders(\Structs\RemindersType $buyingReminders = null)
    {
        $this->BuyingReminders = $buyingReminders;
        return $this;
    }
    /**
     * Get SellingReminders value
     * @return \Structs\RemindersType|null
     */
    public function getSellingReminders()
    {
        return $this->SellingReminders;
    }
    /**
     * Set SellingReminders value
     * @param \Structs\RemindersType $sellingReminders
     * @return \Structs\GetMyeBayRemindersResponseType
     */
    public function setSellingReminders(\Structs\RemindersType $sellingReminders = null)
    {
        $this->SellingReminders = $sellingReminders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Structs\GetMyeBayRemindersResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
