<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayBuyingResponseType Structs
 * Meta information extracted from the WSDL
 * - documentation: Returns information regarding a user's buying activity, such as items they are watching, bidding on, have won, did not win, and have made Best Offers on.
 * @subpackage Structs
 */
class GetMyeBayBuyingResponseType extends AbstractResponseType
{
    /**
     * The BuyingSummary
     * Meta information extracted from the WSDL
     * - documentation: This container consists of buying/bidding activity counts and values. For this container to be returned, the user must include the <b>BuyingSummary.Include</b> field in the request and set its value to <code>true</code>.
     * - minOccurs: 0
     * @var \Structs\BuyingSummaryType
     */
    public $BuyingSummary;
    /**
     * The WatchList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the items on the eBay user's Watch List. This container will be returned if the eBay user has one or more items on their Watch List. <br><br> This container will not be returned in the response (even if
     * there are items on the Watch List) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>WatchList.Include</b> field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \Structs\PaginatedItemArrayType
     */
    public $WatchList;
    /**
     * The BidList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the auction items on which the eBay user has bid. This container will be returned if the eBay user has bid on one or more auction items. <br><br> This container will not be returned in the response (even if
     * there are items on the Bid List) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>BidList.Include</b> field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \Structs\PaginatedItemArrayType
     */
    public $BidList;
    /**
     * The BestOfferList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the items on which the eBay user has made Best Offers. This container will be returned if the eBay user has made one or more Best Offers. <br><br> This container will not be returned in the response (even
     * if user has made Best Offers) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>BestOfferList.Include</b> field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \Structs\PaginatedItemArrayType
     */
    public $BestOfferList;
    /**
     * The WonList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the auction items on which the eBay user has won. This container will be returned if the eBay user has won one or more auction items. <br><br> This container will not be returned in the response (even if
     * there are items on the Won List) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>WonList.Include</b> field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \Structs\PaginatedOrderTransactionArrayType
     */
    public $WonList;
    /**
     * The LostList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the auction items on which the eBay user has bid on but lost. This container will be returned if the eBay user has lost one or more auction items. <br><br> This container will not be returned in the
     * response (even if the buyer has lost one or more auction items) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>LostList.Include</b> field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \Structs\PaginatedItemArrayType
     */
    public $LostList;
    /**
     * The FavoriteSearches
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the eBay user's saved searches. This container will be returned if the eBay user has one or more saved searches. <br><br> This container will not be returned in the response (even if the user has saved
     * searches) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>FavoriteSearches.Include</b> field is omitted or set to <code>false</code>. <br><br> This container consists of the search name, search query, and other search
     * elements. The user can copy and paste the URL in the <b>SearchQuery</b> field into a browser to view the search results again.
     * - minOccurs: 0
     * @var \Structs\MyeBayFavoriteSearchListType
     */
    public $FavoriteSearches;
    /**
     * The FavoriteSellers
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the eBay user's saved sellers. This container will be returned if the eBay user has one or more saved sellers. <br><br> This container will not be returned in the response (even if the user has saved
     * sellers) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>FavoriteSellers.Include</b> field is omitted or set to <code>false</code>. <br><br> This container consists of the saved sellers' user IDs and eBay Store names
     * (if applicable).
     * - minOccurs: 0
     * @var \Structs\MyeBayFavoriteSellerListType
     */
    public $FavoriteSellers;
    /**
     * The SecondChanceOffer
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the items on which the eBay user has received a Second Chance Offer. This container will be returned if the eBay user has made one or more Second Chance Offers. <br><br> This container will not be returned
     * in the response (even if user has received Second Chance Offers) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>SecondChanceOffer.Include</b> field is omitted or set to <code>false</code>.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Structs\ItemType[]
     */
    public $SecondChanceOffer;
    /**
     * The BidAssistantList
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ArrayType\BidGroupArrayType
     */
    public $BidAssistantList;
    /**
     * The DeletedFromWonList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the auction items on which the eBay user has won but deleted from their My eBay page. This container will be returned if the eBay user has won one or more auction items but have deleted these items from My
     * eBay. <br><br> This container will not be returned in the response (even if they have won and then deleted one or more items) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>DeletedFromWonList.Include</b> field is
     * omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \Structs\PaginatedOrderTransactionArrayType
     */
    public $DeletedFromWonList;
    /**
     * The DeletedFromLostList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the auction items on which the eBay user has lost and then deleted from their My eBay page. This container will be returned if the eBay user has lost one or more auction items and then deleted those items
     * from My eBay. <br><br> This container will not be returned in the response (even if they have lost and then deleted one or more items) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>DeletedFromLostList.Include</b>
     * field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \Structs\PaginatedItemArrayType
     */
    public $DeletedFromLostList;
    /**
     * The UserDefinedList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of data for a user-defined list that was created by the user in My eBay. User-defined lists consists of a combination of items, saved sellers, and/or saved searches. <br><br> This container will not be
     * returned in the response (even if one or more user-defined lists exist) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>UserDefinedList.Include</b> field is omitted or set to <code>false</code>.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Structs\UserDefinedListType[]
     */
    public $UserDefinedList;
    /**
     * Constructor method for GetMyeBayBuyingResponseType
     * @uses GetMyeBayBuyingResponseType::setBuyingSummary()
     * @uses GetMyeBayBuyingResponseType::setWatchList()
     * @uses GetMyeBayBuyingResponseType::setBidList()
     * @uses GetMyeBayBuyingResponseType::setBestOfferList()
     * @uses GetMyeBayBuyingResponseType::setWonList()
     * @uses GetMyeBayBuyingResponseType::setLostList()
     * @uses GetMyeBayBuyingResponseType::setFavoriteSearches()
     * @uses GetMyeBayBuyingResponseType::setFavoriteSellers()
     * @uses GetMyeBayBuyingResponseType::setSecondChanceOffer()
     * @uses GetMyeBayBuyingResponseType::setBidAssistantList()
     * @uses GetMyeBayBuyingResponseType::setDeletedFromWonList()
     * @uses GetMyeBayBuyingResponseType::setDeletedFromLostList()
     * @uses GetMyeBayBuyingResponseType::setUserDefinedList()
     * @param \Structs\BuyingSummaryType $buyingSummary
     * @param \Structs\PaginatedItemArrayType $watchList
     * @param \Structs\PaginatedItemArrayType $bidList
     * @param \Structs\PaginatedItemArrayType $bestOfferList
     * @param \Structs\PaginatedOrderTransactionArrayType $wonList
     * @param \Structs\PaginatedItemArrayType $lostList
     * @param \Structs\MyeBayFavoriteSearchListType $favoriteSearches
     * @param \Structs\MyeBayFavoriteSellerListType $favoriteSellers
     * @param \Structs\ItemType[] $secondChanceOffer
     * @param \ArrayType\BidGroupArrayType $bidAssistantList
     * @param \Structs\PaginatedOrderTransactionArrayType $deletedFromWonList
     * @param \Structs\PaginatedItemArrayType $deletedFromLostList
     * @param \Structs\UserDefinedListType[] $userDefinedList
     */
    public function __construct(\Structs\BuyingSummaryType $buyingSummary = null, \Structs\PaginatedItemArrayType $watchList = null, \Structs\PaginatedItemArrayType $bidList = null, \Structs\PaginatedItemArrayType $bestOfferList = null, \Structs\PaginatedOrderTransactionArrayType $wonList = null, \Structs\PaginatedItemArrayType $lostList = null, \Structs\MyeBayFavoriteSearchListType $favoriteSearches = null, \Structs\MyeBayFavoriteSellerListType $favoriteSellers = null, array $secondChanceOffer = array(), \ArrayType\BidGroupArrayType $bidAssistantList = null, \Structs\PaginatedOrderTransactionArrayType $deletedFromWonList = null, \Structs\PaginatedItemArrayType $deletedFromLostList = null, array $userDefinedList = array())
    {
        $this
            ->setBuyingSummary($buyingSummary)
            ->setWatchList($watchList)
            ->setBidList($bidList)
            ->setBestOfferList($bestOfferList)
            ->setWonList($wonList)
            ->setLostList($lostList)
            ->setFavoriteSearches($favoriteSearches)
            ->setFavoriteSellers($favoriteSellers)
            ->setSecondChanceOffer($secondChanceOffer)
            ->setBidAssistantList($bidAssistantList)
            ->setDeletedFromWonList($deletedFromWonList)
            ->setDeletedFromLostList($deletedFromLostList)
            ->setUserDefinedList($userDefinedList);
    }
    /**
     * Get BuyingSummary value
     * @return \Structs\BuyingSummaryType|null
     */
    public function getBuyingSummary()
    {
        return $this->BuyingSummary;
    }
    /**
     * Set BuyingSummary value
     * @param \Structs\BuyingSummaryType $buyingSummary
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setBuyingSummary(\Structs\BuyingSummaryType $buyingSummary = null)
    {
        $this->BuyingSummary = $buyingSummary;
        return $this;
    }
    /**
     * Get WatchList value
     * @return \Structs\PaginatedItemArrayType|null
     */
    public function getWatchList()
    {
        return $this->WatchList;
    }
    /**
     * Set WatchList value
     * @param \Structs\PaginatedItemArrayType $watchList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setWatchList(\Structs\PaginatedItemArrayType $watchList = null)
    {
        $this->WatchList = $watchList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \Structs\PaginatedItemArrayType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \Structs\PaginatedItemArrayType $bidList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setBidList(\Structs\PaginatedItemArrayType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get BestOfferList value
     * @return \Structs\PaginatedItemArrayType|null
     */
    public function getBestOfferList()
    {
        return $this->BestOfferList;
    }
    /**
     * Set BestOfferList value
     * @param \Structs\PaginatedItemArrayType $bestOfferList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setBestOfferList(\Structs\PaginatedItemArrayType $bestOfferList = null)
    {
        $this->BestOfferList = $bestOfferList;
        return $this;
    }
    /**
     * Get WonList value
     * @return \Structs\PaginatedOrderTransactionArrayType|null
     */
    public function getWonList()
    {
        return $this->WonList;
    }
    /**
     * Set WonList value
     * @param \Structs\PaginatedOrderTransactionArrayType $wonList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setWonList(\Structs\PaginatedOrderTransactionArrayType $wonList = null)
    {
        $this->WonList = $wonList;
        return $this;
    }
    /**
     * Get LostList value
     * @return \Structs\PaginatedItemArrayType|null
     */
    public function getLostList()
    {
        return $this->LostList;
    }
    /**
     * Set LostList value
     * @param \Structs\PaginatedItemArrayType $lostList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setLostList(\Structs\PaginatedItemArrayType $lostList = null)
    {
        $this->LostList = $lostList;
        return $this;
    }
    /**
     * Get FavoriteSearches value
     * @return \Structs\MyeBayFavoriteSearchListType|null
     */
    public function getFavoriteSearches()
    {
        return $this->FavoriteSearches;
    }
    /**
     * Set FavoriteSearches value
     * @param \Structs\MyeBayFavoriteSearchListType $favoriteSearches
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setFavoriteSearches(\Structs\MyeBayFavoriteSearchListType $favoriteSearches = null)
    {
        $this->FavoriteSearches = $favoriteSearches;
        return $this;
    }
    /**
     * Get FavoriteSellers value
     * @return \Structs\MyeBayFavoriteSellerListType|null
     */
    public function getFavoriteSellers()
    {
        return $this->FavoriteSellers;
    }
    /**
     * Set FavoriteSellers value
     * @param \Structs\MyeBayFavoriteSellerListType $favoriteSellers
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setFavoriteSellers(\Structs\MyeBayFavoriteSellerListType $favoriteSellers = null)
    {
        $this->FavoriteSellers = $favoriteSellers;
        return $this;
    }
    /**
     * Get SecondChanceOffer value
     * @return \Structs\ItemType[]|null
     */
    public function getSecondChanceOffer()
    {
        return $this->SecondChanceOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setSecondChanceOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSecondChanceOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSecondChanceOfferForArrayConstraintsFromSetSecondChanceOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getMyeBayBuyingResponseTypeSecondChanceOfferItem) {
            // validation for constraint: itemType
            if (!$getMyeBayBuyingResponseTypeSecondChanceOfferItem instanceof \Structs\ItemType) {
                $invalidValues[] = is_object($getMyeBayBuyingResponseTypeSecondChanceOfferItem) ? get_class($getMyeBayBuyingResponseTypeSecondChanceOfferItem) : sprintf('%s(%s)', gettype($getMyeBayBuyingResponseTypeSecondChanceOfferItem), var_export($getMyeBayBuyingResponseTypeSecondChanceOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SecondChanceOffer property can only contain items of type \Structs\ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SecondChanceOffer value
     * @throws \InvalidArgumentException
     * @param \Structs\ItemType[] $secondChanceOffer
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setSecondChanceOffer(array $secondChanceOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($secondChanceOfferArrayErrorMessage = self::validateSecondChanceOfferForArrayConstraintsFromSetSecondChanceOffer($secondChanceOffer))) {
            throw new \InvalidArgumentException($secondChanceOfferArrayErrorMessage, __LINE__);
        }
        $this->SecondChanceOffer = $secondChanceOffer;
        return $this;
    }
    /**
     * Add item to SecondChanceOffer value
     * @throws \InvalidArgumentException
     * @param \Structs\ItemType $item
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function addToSecondChanceOffer(\Structs\ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Structs\ItemType) {
            throw new \InvalidArgumentException(sprintf('The SecondChanceOffer property can only contain items of type \Structs\ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SecondChanceOffer[] = $item;
        return $this;
    }
    /**
     * Get BidAssistantList value
     * @return \ArrayType\BidGroupArrayType|null
     */
    public function getBidAssistantList()
    {
        return $this->BidAssistantList;
    }
    /**
     * Set BidAssistantList value
     * @param \ArrayType\BidGroupArrayType $bidAssistantList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setBidAssistantList(\ArrayType\BidGroupArrayType $bidAssistantList = null)
    {
        $this->BidAssistantList = $bidAssistantList;
        return $this;
    }
    /**
     * Get DeletedFromWonList value
     * @return \Structs\PaginatedOrderTransactionArrayType|null
     */
    public function getDeletedFromWonList()
    {
        return $this->DeletedFromWonList;
    }
    /**
     * Set DeletedFromWonList value
     * @param \Structs\PaginatedOrderTransactionArrayType $deletedFromWonList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setDeletedFromWonList(\Structs\PaginatedOrderTransactionArrayType $deletedFromWonList = null)
    {
        $this->DeletedFromWonList = $deletedFromWonList;
        return $this;
    }
    /**
     * Get DeletedFromLostList value
     * @return \Structs\PaginatedItemArrayType|null
     */
    public function getDeletedFromLostList()
    {
        return $this->DeletedFromLostList;
    }
    /**
     * Set DeletedFromLostList value
     * @param \Structs\PaginatedItemArrayType $deletedFromLostList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setDeletedFromLostList(\Structs\PaginatedItemArrayType $deletedFromLostList = null)
    {
        $this->DeletedFromLostList = $deletedFromLostList;
        return $this;
    }
    /**
     * Get UserDefinedList value
     * @return \Structs\UserDefinedListType[]|null
     */
    public function getUserDefinedList()
    {
        return $this->UserDefinedList;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedListForArrayConstraintsFromSetUserDefinedList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getMyeBayBuyingResponseTypeUserDefinedListItem) {
            // validation for constraint: itemType
            if (!$getMyeBayBuyingResponseTypeUserDefinedListItem instanceof \Structs\UserDefinedListType) {
                $invalidValues[] = is_object($getMyeBayBuyingResponseTypeUserDefinedListItem) ? get_class($getMyeBayBuyingResponseTypeUserDefinedListItem) : sprintf('%s(%s)', gettype($getMyeBayBuyingResponseTypeUserDefinedListItem), var_export($getMyeBayBuyingResponseTypeUserDefinedListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedList property can only contain items of type \Structs\UserDefinedListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedList value
     * @throws \InvalidArgumentException
     * @param \Structs\UserDefinedListType[] $userDefinedList
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function setUserDefinedList(array $userDefinedList = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedListArrayErrorMessage = self::validateUserDefinedListForArrayConstraintsFromSetUserDefinedList($userDefinedList))) {
            throw new \InvalidArgumentException($userDefinedListArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedList = $userDefinedList;
        return $this;
    }
    /**
     * Add item to UserDefinedList value
     * @throws \InvalidArgumentException
     * @param \Structs\UserDefinedListType $item
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public function addToUserDefinedList(\Structs\UserDefinedListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Structs\UserDefinedListType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedList property can only contain items of type \Structs\UserDefinedListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Structs\GetMyeBayBuyingResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
