<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddItemRequestType Structs
 * Meta information extracted from the WSDL
 * - documentation: Base request type for the <b>AddItem</b> call, which is used to create a fixed-price, auction, or classified ad listing.
 * @subpackage Structs
 */
class AddItemRequestType extends AbstractRequestType
{
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - documentation: This container is used to specify all of the values and settings that define a new listing.
     * - minOccurs: 0
     * @var \Structs\ItemType
     */
    public $Item;
    /**
     * Constructor method for AddItemRequestType
     * @uses AddItemRequestType::setItem()
     * @param \Structs\ItemType $item
     */
    public function __construct(\Structs\ItemType $item = null)
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * @return \Structs\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \Structs\ItemType $item
     * @return \Structs\AddItemRequestType
     */
    public function setItem(\Structs\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Structs\AddItemRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
