<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Structs\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\Structs\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named DeleteMyMessages
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\DeleteMyMessagesRequestType $deleteMyMessagesRequest
     * @return \Structs\DeleteMyMessagesResponseType|bool
     */
    public function DeleteMyMessages(\Structs\DeleteMyMessagesRequestType $deleteMyMessagesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMyMessages($deleteMyMessagesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DeleteSellingManagerInventoryFolder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\DeleteSellingManagerInventoryFolderRequestType $deleteSellingManagerInventoryFolderRequest
     * @return \Structs\DeleteSellingManagerInventoryFolderResponseType|bool
     */
    public function DeleteSellingManagerInventoryFolder(\Structs\DeleteSellingManagerInventoryFolderRequestType $deleteSellingManagerInventoryFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerInventoryFolder($deleteSellingManagerInventoryFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DeleteSellingManagerItemAutomationRule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\DeleteSellingManagerItemAutomationRuleRequestType $deleteSellingManagerItemAutomationRuleRequest
     * @return \Structs\DeleteSellingManagerItemAutomationRuleResponseType|bool
     */
    public function DeleteSellingManagerItemAutomationRule(\Structs\DeleteSellingManagerItemAutomationRuleRequestType $deleteSellingManagerItemAutomationRuleRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerItemAutomationRule($deleteSellingManagerItemAutomationRuleRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteSellingManagerProduct
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\DeleteSellingManagerProductRequestType $deleteSellingManagerProductRequest
     * @return \Structs\DeleteSellingManagerProductResponseType|bool
     */
    public function DeleteSellingManagerProduct(\Structs\DeleteSellingManagerProductRequestType $deleteSellingManagerProductRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerProduct($deleteSellingManagerProductRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteSellingManagerTemplate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\DeleteSellingManagerTemplateRequestType $deleteSellingManagerTemplateRequest
     * @return \Structs\DeleteSellingManagerTemplateResponseType|bool
     */
    public function DeleteSellingManagerTemplate(\Structs\DeleteSellingManagerTemplateRequestType $deleteSellingManagerTemplateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerTemplate($deleteSellingManagerTemplateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DeleteSellingManagerTemplateAutomationRule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\DeleteSellingManagerTemplateAutomationRuleRequestType $deleteSellingManagerTemplateAutomationRuleRequest
     * @return \Structs\DeleteSellingManagerTemplateAutomationRuleResponseType|bool
     */
    public function DeleteSellingManagerTemplateAutomationRule(\Structs\DeleteSellingManagerTemplateAutomationRuleRequestType $deleteSellingManagerTemplateAutomationRuleRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSellingManagerTemplateAutomationRule($deleteSellingManagerTemplateAutomationRuleRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\DeleteMyMessagesResponseType|\Structs\DeleteSellingManagerInventoryFolderResponseType|\Structs\DeleteSellingManagerItemAutomationRuleResponseType|\Structs\DeleteSellingManagerProductResponseType|\Structs\DeleteSellingManagerTemplateAutomationRuleResponseType|\Structs\DeleteSellingManagerTemplateResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
