<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTransactionCodeType Structs
 * Meta information extracted from the WSDL
 * - documentation: This type is deprecated.
 * @subpackage Structs
 */
class PaymentTransactionCodeType extends AbstractStructBase
{
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatus;
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \Structs\UserIdentityType
     */
    public $Payer;
    /**
     * The Payee
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \Structs\UserIdentityType
     */
    public $Payee;
    /**
     * The PaymentTime
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTime;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \Structs\AmountType
     */
    public $PaymentAmount;
    /**
     * The ReferenceID
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \Structs\TransactionReferenceType
     */
    public $ReferenceID;
    /**
     * The FeeOrCreditAmount
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \Structs\AmountType
     */
    public $FeeOrCreditAmount;
    /**
     * The PaymentReferenceID
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Structs\TransactionReferenceType[]
     */
    public $PaymentReferenceID;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for PaymentTransactionCodeType
     * @uses PaymentTransactionCodeType::setPaymentStatus()
     * @uses PaymentTransactionCodeType::setPayer()
     * @uses PaymentTransactionCodeType::setPayee()
     * @uses PaymentTransactionCodeType::setPaymentTime()
     * @uses PaymentTransactionCodeType::setPaymentAmount()
     * @uses PaymentTransactionCodeType::setReferenceID()
     * @uses PaymentTransactionCodeType::setFeeOrCreditAmount()
     * @uses PaymentTransactionCodeType::setPaymentReferenceID()
     * @uses PaymentTransactionCodeType::setAny()
     * @param string $paymentStatus
     * @param \Structs\UserIdentityType $payer
     * @param \Structs\UserIdentityType $payee
     * @param string $paymentTime
     * @param \Structs\AmountType $paymentAmount
     * @param \Structs\TransactionReferenceType $referenceID
     * @param \Structs\AmountType $feeOrCreditAmount
     * @param \Structs\TransactionReferenceType[] $paymentReferenceID
     * @param \DOMDocument $any
     */
    public function __construct($paymentStatus = null, \Structs\UserIdentityType $payer = null, \Structs\UserIdentityType $payee = null, $paymentTime = null, \Structs\AmountType $paymentAmount = null, \Structs\TransactionReferenceType $referenceID = null, \Structs\AmountType $feeOrCreditAmount = null, array $paymentReferenceID = array(), \DOMDocument $any = null)
    {
        $this
            ->setPaymentStatus($paymentStatus)
            ->setPayer($payer)
            ->setPayee($payee)
            ->setPaymentTime($paymentTime)
            ->setPaymentAmount($paymentAmount)
            ->setReferenceID($referenceID)
            ->setFeeOrCreditAmount($feeOrCreditAmount)
            ->setPaymentReferenceID($paymentReferenceID)
            ->setAny($any);
    }
    /**
     * Get PaymentStatus value
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->PaymentStatus;
    }
    /**
     * Set PaymentStatus value
     * @uses \EnumType\PaymentTransactionStatusCodeType::valueIsValid()
     * @uses \EnumType\PaymentTransactionStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentTransactionStatusCodeType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentTransactionStatusCodeType', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \EnumType\PaymentTransactionStatusCodeType::getValidValues())), __LINE__);
        }
        $this->PaymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get Payer value
     * @return \Structs\UserIdentityType|null
     */
    public function getPayer()
    {
        return $this->Payer;
    }
    /**
     * Set Payer value
     * @param \Structs\UserIdentityType $payer
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setPayer(\Structs\UserIdentityType $payer = null)
    {
        $this->Payer = $payer;
        return $this;
    }
    /**
     * Get Payee value
     * @return \Structs\UserIdentityType|null
     */
    public function getPayee()
    {
        return $this->Payee;
    }
    /**
     * Set Payee value
     * @param \Structs\UserIdentityType $payee
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setPayee(\Structs\UserIdentityType $payee = null)
    {
        $this->Payee = $payee;
        return $this;
    }
    /**
     * Get PaymentTime value
     * @return string|null
     */
    public function getPaymentTime()
    {
        return $this->PaymentTime;
    }
    /**
     * Set PaymentTime value
     * @param string $paymentTime
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setPaymentTime($paymentTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTime) && !is_string($paymentTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTime, true), gettype($paymentTime)), __LINE__);
        }
        $this->PaymentTime = $paymentTime;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return \Structs\AmountType|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param \Structs\AmountType $paymentAmount
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setPaymentAmount(\Structs\AmountType $paymentAmount = null)
    {
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get ReferenceID value
     * @return \Structs\TransactionReferenceType|null
     */
    public function getReferenceID()
    {
        return $this->ReferenceID;
    }
    /**
     * Set ReferenceID value
     * @param \Structs\TransactionReferenceType $referenceID
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setReferenceID(\Structs\TransactionReferenceType $referenceID = null)
    {
        $this->ReferenceID = $referenceID;
        return $this;
    }
    /**
     * Get FeeOrCreditAmount value
     * @return \Structs\AmountType|null
     */
    public function getFeeOrCreditAmount()
    {
        return $this->FeeOrCreditAmount;
    }
    /**
     * Set FeeOrCreditAmount value
     * @param \Structs\AmountType $feeOrCreditAmount
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setFeeOrCreditAmount(\Structs\AmountType $feeOrCreditAmount = null)
    {
        $this->FeeOrCreditAmount = $feeOrCreditAmount;
        return $this;
    }
    /**
     * Get PaymentReferenceID value
     * @return \Structs\TransactionReferenceType[]|null
     */
    public function getPaymentReferenceID()
    {
        return $this->PaymentReferenceID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentReferenceID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentReferenceID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentReferenceIDForArrayConstraintsFromSetPaymentReferenceID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentTransactionCodeTypePaymentReferenceIDItem) {
            // validation for constraint: itemType
            if (!$paymentTransactionCodeTypePaymentReferenceIDItem instanceof \Structs\TransactionReferenceType) {
                $invalidValues[] = is_object($paymentTransactionCodeTypePaymentReferenceIDItem) ? get_class($paymentTransactionCodeTypePaymentReferenceIDItem) : sprintf('%s(%s)', gettype($paymentTransactionCodeTypePaymentReferenceIDItem), var_export($paymentTransactionCodeTypePaymentReferenceIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentReferenceID property can only contain items of type \Structs\TransactionReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentReferenceID value
     * @throws \InvalidArgumentException
     * @param \Structs\TransactionReferenceType[] $paymentReferenceID
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setPaymentReferenceID(array $paymentReferenceID = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentReferenceIDArrayErrorMessage = self::validatePaymentReferenceIDForArrayConstraintsFromSetPaymentReferenceID($paymentReferenceID))) {
            throw new \InvalidArgumentException($paymentReferenceIDArrayErrorMessage, __LINE__);
        }
        $this->PaymentReferenceID = $paymentReferenceID;
        return $this;
    }
    /**
     * Add item to PaymentReferenceID value
     * @throws \InvalidArgumentException
     * @param \Structs\TransactionReferenceType $item
     * @return \Structs\PaymentTransactionCodeType
     */
    public function addToPaymentReferenceID(\Structs\TransactionReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Structs\TransactionReferenceType) {
            throw new \InvalidArgumentException(sprintf('The PaymentReferenceID property can only contain items of type \Structs\TransactionReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentReferenceID[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Structs\PaymentTransactionCodeType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Structs\PaymentTransactionCodeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
