<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Revise ServiceType
 * @subpackage Services
 */
class Revise extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Structs\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\Structs\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReviseCheckoutStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseCheckoutStatusRequestType $reviseCheckoutStatusRequest
     * @return \Structs\ReviseCheckoutStatusResponseType|bool
     */
    public function ReviseCheckoutStatus(\Structs\ReviseCheckoutStatusRequestType $reviseCheckoutStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseCheckoutStatus($reviseCheckoutStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReviseFixedPriceItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseFixedPriceItemRequestType $reviseFixedPriceItemRequest
     * @return \Structs\ReviseFixedPriceItemResponseType|bool
     */
    public function ReviseFixedPriceItem(\Structs\ReviseFixedPriceItemRequestType $reviseFixedPriceItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseFixedPriceItem($reviseFixedPriceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReviseInventoryStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseInventoryStatusRequestType $reviseInventoryStatusRequest
     * @return \Structs\ReviseInventoryStatusResponseType|bool
     */
    public function ReviseInventoryStatus(\Structs\ReviseInventoryStatusRequestType $reviseInventoryStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseInventoryStatus($reviseInventoryStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReviseItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseItemRequestType $reviseItemRequest
     * @return \Structs\ReviseItemResponseType|bool
     */
    public function ReviseItem(\Structs\ReviseItemRequestType $reviseItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseItem($reviseItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReviseMyMessages
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseMyMessagesRequestType $reviseMyMessagesRequest
     * @return \Structs\ReviseMyMessagesResponseType|bool
     */
    public function ReviseMyMessages(\Structs\ReviseMyMessagesRequestType $reviseMyMessagesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseMyMessages($reviseMyMessagesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReviseMyMessagesFolders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseMyMessagesFoldersRequestType $reviseMyMessagesFoldersRequest
     * @return \Structs\ReviseMyMessagesFoldersResponseType|bool
     */
    public function ReviseMyMessagesFolders(\Structs\ReviseMyMessagesFoldersRequestType $reviseMyMessagesFoldersRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseMyMessagesFolders($reviseMyMessagesFoldersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReviseSellingManagerInventoryFolder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseSellingManagerInventoryFolderRequestType $reviseSellingManagerInventoryFolderRequest
     * @return \Structs\ReviseSellingManagerInventoryFolderResponseType|bool
     */
    public function ReviseSellingManagerInventoryFolder(\Structs\ReviseSellingManagerInventoryFolderRequestType $reviseSellingManagerInventoryFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseSellingManagerInventoryFolder($reviseSellingManagerInventoryFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReviseSellingManagerProduct
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseSellingManagerProductRequestType $reviseSellingManagerProductRequest
     * @return \Structs\ReviseSellingManagerProductResponseType|bool
     */
    public function ReviseSellingManagerProduct(\Structs\ReviseSellingManagerProductRequestType $reviseSellingManagerProductRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseSellingManagerProduct($reviseSellingManagerProductRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReviseSellingManagerSaleRecord
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseSellingManagerSaleRecordRequestType $reviseSellingManagerSaleRecordRequest
     * @return \Structs\ReviseSellingManagerSaleRecordResponseType|bool
     */
    public function ReviseSellingManagerSaleRecord(\Structs\ReviseSellingManagerSaleRecordRequestType $reviseSellingManagerSaleRecordRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseSellingManagerSaleRecord($reviseSellingManagerSaleRecordRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReviseSellingManagerTemplate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ReviseSellingManagerTemplateRequestType $reviseSellingManagerTemplateRequest
     * @return \Structs\ReviseSellingManagerTemplateResponseType|bool
     */
    public function ReviseSellingManagerTemplate(\Structs\ReviseSellingManagerTemplateRequestType $reviseSellingManagerTemplateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReviseSellingManagerTemplate($reviseSellingManagerTemplateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\ReviseCheckoutStatusResponseType|\Structs\ReviseFixedPriceItemResponseType|\Structs\ReviseInventoryStatusResponseType|\Structs\ReviseItemResponseType|\Structs\ReviseMyMessagesFoldersResponseType|\Structs\ReviseMyMessagesResponseType|\Structs\ReviseSellingManagerInventoryFolderResponseType|\Structs\ReviseSellingManagerProductResponseType|\Structs\ReviseSellingManagerSaleRecordResponseType|\Structs\ReviseSellingManagerTemplateResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
