<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Structs\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\Structs\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetAccountRequestType $getAccountRequest
     * @return \Structs\GetAccountResponseType|bool
     */
    public function GetAccount(\Structs\GetAccountRequestType $getAccountRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccount($getAccountRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdFormatLeads
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetAdFormatLeadsRequestType $getAdFormatLeadsRequest
     * @return \Structs\GetAdFormatLeadsResponseType|bool
     */
    public function GetAdFormatLeads(\Structs\GetAdFormatLeadsRequestType $getAdFormatLeadsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdFormatLeads($getAdFormatLeadsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllBidders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetAllBiddersRequestType $getAllBiddersRequest
     * @return \Structs\GetAllBiddersResponseType|bool
     */
    public function GetAllBidders(\Structs\GetAllBiddersRequestType $getAllBiddersRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllBidders($getAllBiddersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApiAccessRules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetApiAccessRulesRequestType $getApiAccessRulesRequest
     * @return \Structs\GetApiAccessRulesResponseType|bool
     */
    public function GetApiAccessRules(\Structs\GetApiAccessRulesRequestType $getApiAccessRulesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApiAccessRules($getApiAccessRulesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBestOffers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetBestOffersRequestType $getBestOffersRequest
     * @return \Structs\GetBestOffersResponseType|bool
     */
    public function GetBestOffers(\Structs\GetBestOffersRequestType $getBestOffersRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBestOffers($getBestOffersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBidderList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetBidderListRequestType $getBidderListRequest
     * @return \Structs\GetBidderListResponseType|bool
     */
    public function GetBidderList(\Structs\GetBidderListRequestType $getBidderListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBidderList($getBidderListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetCategoriesRequestType $getCategoriesRequest
     * @return \Structs\GetCategoriesResponseType|bool
     */
    public function GetCategories(\Structs\GetCategoriesRequestType $getCategoriesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategories($getCategoriesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategoryFeatures
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetCategoryFeaturesRequestType $getCategoryFeaturesRequest
     * @return \Structs\GetCategoryFeaturesResponseType|bool
     */
    public function GetCategoryFeatures(\Structs\GetCategoryFeaturesRequestType $getCategoryFeaturesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategoryFeatures($getCategoryFeaturesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategoryMappings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetCategoryMappingsRequestType $getCategoryMappingsRequest
     * @return \Structs\GetCategoryMappingsResponseType|bool
     */
    public function GetCategoryMappings(\Structs\GetCategoryMappingsRequestType $getCategoryMappingsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategoryMappings($getCategoryMappingsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategorySpecifics
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetCategorySpecificsRequestType $getCategorySpecificsRequest
     * @return \Structs\GetCategorySpecificsResponseType|bool
     */
    public function GetCategorySpecifics(\Structs\GetCategorySpecificsRequestType $getCategorySpecificsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategorySpecifics($getCategorySpecificsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetChallengeToken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetChallengeTokenRequestType $getChallengeTokenRequest
     * @return \Structs\GetChallengeTokenResponseType|bool
     */
    public function GetChallengeToken(\Structs\GetChallengeTokenRequestType $getChallengeTokenRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetChallengeToken($getChallengeTokenRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCharities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetCharitiesRequestType $getCharitiesRequest
     * @return \Structs\GetCharitiesResponseType|bool
     */
    public function GetCharities(\Structs\GetCharitiesRequestType $getCharitiesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCharities($getCharitiesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientAlertsAuthToken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetClientAlertsAuthTokenRequestType $getClientAlertsAuthTokenRequest
     * @return \Structs\GetClientAlertsAuthTokenResponseType|bool
     */
    public function GetClientAlertsAuthToken(\Structs\GetClientAlertsAuthTokenRequestType $getClientAlertsAuthTokenRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClientAlertsAuthToken($getClientAlertsAuthTokenRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContextualKeywords
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetContextualKeywordsRequestType $getContextualKeywordsRequest
     * @return \Structs\GetContextualKeywordsResponseType|bool
     */
    public function GetContextualKeywords(\Structs\GetContextualKeywordsRequestType $getContextualKeywordsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetContextualKeywords($getContextualKeywordsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDescriptionTemplates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetDescriptionTemplatesRequestType $getDescriptionTemplatesRequest
     * @return \Structs\GetDescriptionTemplatesResponseType|bool
     */
    public function GetDescriptionTemplates(\Structs\GetDescriptionTemplatesRequestType $getDescriptionTemplatesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDescriptionTemplates($getDescriptionTemplatesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDispute
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetDisputeRequestType $getDisputeRequest
     * @return \Structs\GetDisputeResponseType|bool
     */
    public function GetDispute(\Structs\GetDisputeRequestType $getDisputeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDispute($getDisputeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFeedback
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetFeedbackRequestType $getFeedbackRequest
     * @return \Structs\GetFeedbackResponseType|bool
     */
    public function GetFeedback(\Structs\GetFeedbackRequestType $getFeedbackRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFeedback($getFeedbackRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetItemRequestType $getItemRequest
     * @return \Structs\GetItemResponseType|bool
     */
    public function GetItem(\Structs\GetItemRequestType $getItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItem($getItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemShipping
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetItemShippingRequestType $getItemShippingRequest
     * @return \Structs\GetItemShippingResponseType|bool
     */
    public function GetItemShipping(\Structs\GetItemShippingRequestType $getItemShippingRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemShipping($getItemShippingRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemTransactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetItemTransactionsRequestType $getItemTransactionsRequest
     * @return \Structs\GetItemTransactionsResponseType|bool
     */
    public function GetItemTransactions(\Structs\GetItemTransactionsRequestType $getItemTransactionsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemTransactions($getItemTransactionsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemsAwaitingFeedback
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetItemsAwaitingFeedbackRequestType $getItemsAwaitingFeedbackRequest
     * @return \Structs\GetItemsAwaitingFeedbackResponseType|bool
     */
    public function GetItemsAwaitingFeedback(\Structs\GetItemsAwaitingFeedbackRequestType $getItemsAwaitingFeedbackRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemsAwaitingFeedback($getItemsAwaitingFeedbackRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMemberMessages
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetMemberMessagesRequestType $getMemberMessagesRequest
     * @return \Structs\GetMemberMessagesResponseType|bool
     */
    public function GetMemberMessages(\Structs\GetMemberMessagesRequestType $getMemberMessagesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMemberMessages($getMemberMessagesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessagePreferences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetMessagePreferencesRequestType $getMessagePreferencesRequest
     * @return \Structs\GetMessagePreferencesResponseType|bool
     */
    public function GetMessagePreferences(\Structs\GetMessagePreferencesRequestType $getMessagePreferencesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMessagePreferences($getMessagePreferencesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMyMessages
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetMyMessagesRequestType $getMyMessagesRequest
     * @return \Structs\GetMyMessagesResponseType|bool
     */
    public function GetMyMessages(\Structs\GetMyMessagesRequestType $getMyMessagesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyMessages($getMyMessagesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMyeBayBuying
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetMyeBayBuyingRequestType $getMyeBayBuyingRequest
     * @return \Structs\GetMyeBayBuyingResponseType|bool
     */
    public function GetMyeBayBuying(\Structs\GetMyeBayBuyingRequestType $getMyeBayBuyingRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyeBayBuying($getMyeBayBuyingRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMyeBayReminders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetMyeBayRemindersRequestType $getMyeBayRemindersRequest
     * @return \Structs\GetMyeBayRemindersResponseType|bool
     */
    public function GetMyeBayReminders(\Structs\GetMyeBayRemindersRequestType $getMyeBayRemindersRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyeBayReminders($getMyeBayRemindersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMyeBaySelling
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetMyeBaySellingRequestType $getMyeBaySellingRequest
     * @return \Structs\GetMyeBaySellingResponseType|bool
     */
    public function GetMyeBaySelling(\Structs\GetMyeBaySellingRequestType $getMyeBaySellingRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyeBaySelling($getMyeBaySellingRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotificationPreferences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetNotificationPreferencesRequestType $getNotificationPreferencesRequest
     * @return \Structs\GetNotificationPreferencesResponseType|bool
     */
    public function GetNotificationPreferences(\Structs\GetNotificationPreferencesRequestType $getNotificationPreferencesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNotificationPreferences($getNotificationPreferencesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotificationsUsage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetNotificationsUsageRequestType $getNotificationsUsageRequest
     * @return \Structs\GetNotificationsUsageResponseType|bool
     */
    public function GetNotificationsUsage(\Structs\GetNotificationsUsageRequestType $getNotificationsUsageRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNotificationsUsage($getNotificationsUsageRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderTransactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetOrderTransactionsRequestType $getOrderTransactionsRequest
     * @return \Structs\GetOrderTransactionsResponseType|bool
     */
    public function GetOrderTransactions(\Structs\GetOrderTransactionsRequestType $getOrderTransactionsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderTransactions($getOrderTransactionsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetOrdersRequestType $getOrdersRequest
     * @return \Structs\GetOrdersResponseType|bool
     */
    public function GetOrders(\Structs\GetOrdersRequestType $getOrdersRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrders($getOrdersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPromotionalSaleDetails
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetPromotionalSaleDetailsRequestType $getPromotionalSaleDetailsRequest
     * @return \Structs\GetPromotionalSaleDetailsResponseType|bool
     */
    public function GetPromotionalSaleDetails(\Structs\GetPromotionalSaleDetailsRequestType $getPromotionalSaleDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPromotionalSaleDetails($getPromotionalSaleDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellerDashboard
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellerDashboardRequestType $getSellerDashboardRequest
     * @return \Structs\GetSellerDashboardResponseType|bool
     */
    public function GetSellerDashboard(\Structs\GetSellerDashboardRequestType $getSellerDashboardRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellerDashboard($getSellerDashboardRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellerEvents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellerEventsRequestType $getSellerEventsRequest
     * @return \Structs\GetSellerEventsResponseType|bool
     */
    public function GetSellerEvents(\Structs\GetSellerEventsRequestType $getSellerEventsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellerEvents($getSellerEventsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellerList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellerListRequestType $getSellerListRequest
     * @return \Structs\GetSellerListResponseType|bool
     */
    public function GetSellerList(\Structs\GetSellerListRequestType $getSellerListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellerList($getSellerListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellerTransactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellerTransactionsRequestType $getSellerTransactionsRequest
     * @return \Structs\GetSellerTransactionsResponseType|bool
     */
    public function GetSellerTransactions(\Structs\GetSellerTransactionsRequestType $getSellerTransactionsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellerTransactions($getSellerTransactionsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellingManagerAlerts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerAlertsRequestType $getSellingManagerAlertsRequest
     * @return \Structs\GetSellingManagerAlertsResponseType|bool
     */
    public function GetSellingManagerAlerts(\Structs\GetSellingManagerAlertsRequestType $getSellingManagerAlertsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerAlerts($getSellingManagerAlertsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellingManagerEmailLog
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerEmailLogRequestType $getSellingManagerEmailLogRequest
     * @return \Structs\GetSellingManagerEmailLogResponseType|bool
     */
    public function GetSellingManagerEmailLog(\Structs\GetSellingManagerEmailLogRequestType $getSellingManagerEmailLogRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerEmailLog($getSellingManagerEmailLogRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellingManagerInventory
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerInventoryRequestType $getSellingManagerInventoryRequest
     * @return \Structs\GetSellingManagerInventoryResponseType|bool
     */
    public function GetSellingManagerInventory(\Structs\GetSellingManagerInventoryRequestType $getSellingManagerInventoryRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerInventory($getSellingManagerInventoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellingManagerInventoryFolder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerInventoryFolderRequestType $getSellingManagerInventoryFolderRequest
     * @return \Structs\GetSellingManagerInventoryFolderResponseType|bool
     */
    public function GetSellingManagerInventoryFolder(\Structs\GetSellingManagerInventoryFolderRequestType $getSellingManagerInventoryFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerInventoryFolder($getSellingManagerInventoryFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetSellingManagerItemAutomationRule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerItemAutomationRuleRequestType $getSellingManagerItemAutomationRuleRequest
     * @return \Structs\GetSellingManagerItemAutomationRuleResponseType|bool
     */
    public function GetSellingManagerItemAutomationRule(\Structs\GetSellingManagerItemAutomationRuleRequestType $getSellingManagerItemAutomationRuleRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerItemAutomationRule($getSellingManagerItemAutomationRuleRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellingManagerSaleRecord
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerSaleRecordRequestType $getSellingManagerSaleRecordRequest
     * @return \Structs\GetSellingManagerSaleRecordResponseType|bool
     */
    public function GetSellingManagerSaleRecord(\Structs\GetSellingManagerSaleRecordRequestType $getSellingManagerSaleRecordRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerSaleRecord($getSellingManagerSaleRecordRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellingManagerSoldListings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerSoldListingsRequestType $getSellingManagerSoldListingsRequest
     * @return \Structs\GetSellingManagerSoldListingsResponseType|bool
     */
    public function GetSellingManagerSoldListings(\Structs\GetSellingManagerSoldListingsRequestType $getSellingManagerSoldListingsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerSoldListings($getSellingManagerSoldListingsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetSellingManagerTemplateAutomationRule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerTemplateAutomationRuleRequestType $getSellingManagerTemplateAutomationRuleRequest
     * @return \Structs\GetSellingManagerTemplateAutomationRuleResponseType|bool
     */
    public function GetSellingManagerTemplateAutomationRule(\Structs\GetSellingManagerTemplateAutomationRuleRequestType $getSellingManagerTemplateAutomationRuleRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerTemplateAutomationRule($getSellingManagerTemplateAutomationRuleRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellingManagerTemplates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSellingManagerTemplatesRequestType $getSellingManagerTemplatesRequest
     * @return \Structs\GetSellingManagerTemplatesResponseType|bool
     */
    public function GetSellingManagerTemplates(\Structs\GetSellingManagerTemplatesRequestType $getSellingManagerTemplatesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellingManagerTemplates($getSellingManagerTemplatesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSessionID
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSessionIDRequestType $getSessionIDRequest
     * @return \Structs\GetSessionIDResponseType|bool
     */
    public function GetSessionID(\Structs\GetSessionIDRequestType $getSessionIDRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSessionID($getSessionIDRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShippingDiscountProfiles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetShippingDiscountProfilesRequestType $getShippingDiscountProfilesRequest
     * @return \Structs\GetShippingDiscountProfilesResponseType|bool
     */
    public function GetShippingDiscountProfiles(\Structs\GetShippingDiscountProfilesRequestType $getShippingDiscountProfilesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShippingDiscountProfiles($getShippingDiscountProfilesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStore
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetStoreRequestType $getStoreRequest
     * @return \Structs\GetStoreResponseType|bool
     */
    public function GetStore(\Structs\GetStoreRequestType $getStoreRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStore($getStoreRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreCategoryUpdateStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetStoreCategoryUpdateStatusRequestType $getStoreCategoryUpdateStatusRequest
     * @return \Structs\GetStoreCategoryUpdateStatusResponseType|bool
     */
    public function GetStoreCategoryUpdateStatus(\Structs\GetStoreCategoryUpdateStatusRequestType $getStoreCategoryUpdateStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStoreCategoryUpdateStatus($getStoreCategoryUpdateStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreCustomPage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetStoreCustomPageRequestType $getStoreCustomPageRequest
     * @return \Structs\GetStoreCustomPageResponseType|bool
     */
    public function GetStoreCustomPage(\Structs\GetStoreCustomPageRequestType $getStoreCustomPageRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStoreCustomPage($getStoreCustomPageRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreOptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetStoreOptionsRequestType $getStoreOptionsRequest
     * @return \Structs\GetStoreOptionsResponseType|bool
     */
    public function GetStoreOptions(\Structs\GetStoreOptionsRequestType $getStoreOptionsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStoreOptions($getStoreOptionsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStorePreferences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetStorePreferencesRequestType $getStorePreferencesRequest
     * @return \Structs\GetStorePreferencesResponseType|bool
     */
    public function GetStorePreferences(\Structs\GetStorePreferencesRequestType $getStorePreferencesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStorePreferences($getStorePreferencesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSuggestedCategories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetSuggestedCategoriesRequestType $getSuggestedCategoriesRequest
     * @return \Structs\GetSuggestedCategoriesResponseType|bool
     */
    public function GetSuggestedCategories(\Structs\GetSuggestedCategoriesRequestType $getSuggestedCategoriesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSuggestedCategories($getSuggestedCategoriesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTaxTable
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetTaxTableRequestType $getTaxTableRequest
     * @return \Structs\GetTaxTableResponseType|bool
     */
    public function GetTaxTable(\Structs\GetTaxTableRequestType $getTaxTableRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTaxTable($getTaxTableRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTokenStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetTokenStatusRequestType $getTokenStatusRequest
     * @return \Structs\GetTokenStatusResponseType|bool
     */
    public function GetTokenStatus(\Structs\GetTokenStatusRequestType $getTokenStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTokenStatus($getTokenStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUser
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetUserRequestType $getUserRequest
     * @return \Structs\GetUserResponseType|bool
     */
    public function GetUser(\Structs\GetUserRequestType $getUserRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUser($getUserRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserContactDetails
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetUserContactDetailsRequestType $getUserContactDetailsRequest
     * @return \Structs\GetUserContactDetailsResponseType|bool
     */
    public function GetUserContactDetails(\Structs\GetUserContactDetailsRequestType $getUserContactDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserContactDetails($getUserContactDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserDisputes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetUserDisputesRequestType $getUserDisputesRequest
     * @return \Structs\GetUserDisputesResponseType|bool
     */
    public function GetUserDisputes(\Structs\GetUserDisputesRequestType $getUserDisputesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserDisputes($getUserDisputesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserPreferences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetUserPreferencesRequestType $getUserPreferencesRequest
     * @return \Structs\GetUserPreferencesResponseType|bool
     */
    public function GetUserPreferences(\Structs\GetUserPreferencesRequestType $getUserPreferencesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserPreferences($getUserPreferencesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVeROReasonCodeDetails
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetVeROReasonCodeDetailsRequestType $getVeROReasonCodeDetailsRequest
     * @return \Structs\GetVeROReasonCodeDetailsResponseType|bool
     */
    public function GetVeROReasonCodeDetails(\Structs\GetVeROReasonCodeDetailsRequestType $getVeROReasonCodeDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVeROReasonCodeDetails($getVeROReasonCodeDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVeROReportStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \Structs\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetVeROReportStatusRequestType $getVeROReportStatusRequest
     * @return \Structs\GetVeROReportStatusResponseType|bool
     */
    public function GetVeROReportStatus(\Structs\GetVeROReportStatusRequestType $getVeROReportStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVeROReportStatus($getVeROReportStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\GetAccountResponseType|\Structs\GetAdFormatLeadsResponseType|\Structs\GetAllBiddersResponseType|\Structs\GetApiAccessRulesResponseType|\Structs\GetBestOffersResponseType|\Structs\GetBidderListResponseType|\Structs\GetCategoriesResponseType|\Structs\GetCategoryFeaturesResponseType|\Structs\GetCategoryMappingsResponseType|\Structs\GetCategorySpecificsResponseType|\Structs\GetChallengeTokenResponseType|\Structs\GetCharitiesResponseType|\Structs\GetClientAlertsAuthTokenResponseType|\Structs\GetContextualKeywordsResponseType|\Structs\GetDescriptionTemplatesResponseType|\Structs\GetDisputeResponseType|\Structs\GetFeedbackResponseType|\Structs\GetItemResponseType|\Structs\GetItemsAwaitingFeedbackResponseType|\Structs\GetItemShippingResponseType|\Structs\GetItemTransactionsResponseType|\Structs\GetMemberMessagesResponseType|\Structs\GetMessagePreferencesResponseType|\Structs\GetMyeBayBuyingResponseType|\Structs\GetMyeBayRemindersResponseType|\Structs\GetMyeBaySellingResponseType|\Structs\GetMyMessagesResponseType|\Structs\GetNotificationPreferencesResponseType|\Structs\GetNotificationsUsageResponseType|\Structs\GetOrdersResponseType|\Structs\GetOrderTransactionsResponseType|\Structs\GetPromotionalSaleDetailsResponseType|\Structs\GetSellerDashboardResponseType|\Structs\GetSellerEventsResponseType|\Structs\GetSellerListResponseType|\Structs\GetSellerTransactionsResponseType|\Structs\GetSellingManagerAlertsResponseType|\Structs\GetSellingManagerEmailLogResponseType|\Structs\GetSellingManagerInventoryFolderResponseType|\Structs\GetSellingManagerInventoryResponseType|\Structs\GetSellingManagerItemAutomationRuleResponseType|\Structs\GetSellingManagerSaleRecordResponseType|\Structs\GetSellingManagerSoldListingsResponseType|\Structs\GetSellingManagerTemplateAutomationRuleResponseType|\Structs\GetSellingManagerTemplatesResponseType|\Structs\GetSessionIDResponseType|\Structs\GetShippingDiscountProfilesResponseType|\Structs\GetStoreCategoryUpdateStatusResponseType|\Structs\GetStoreCustomPageResponseType|\Structs\GetStoreOptionsResponseType|\Structs\GetStorePreferencesResponseType|\Structs\GetStoreResponseType|\Structs\GetSuggestedCategoriesResponseType|\Structs\GetTaxTableResponseType|\Structs\GetTokenStatusResponseType|\Structs\GetUserContactDetailsResponseType|\Structs\GetUserDisputesResponseType|\Structs\GetUserPreferencesResponseType|\Structs\GetUserResponseType|\Structs\GetVeROReasonCodeDetailsResponseType|\Structs\GetVeROReportStatusResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
