<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayBuyingRequestType Structs
 * Meta information extracted from the WSDL
 * - documentation: Retrieves information regarding a user's buying activity, such as items they are watching, bidding on, have won, did not win, and have made Best Offers on.
 * @subpackage Structs
 */
class GetMyeBayBuyingRequestType extends AbstractRequestType
{
    /**
     * The WatchList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>WatchList.Include</b> field to <code>true</code> to return the list of items on the eBay user's Watch List. <br><br> The user also has the option of using pagination and sorting for the list of
     * watched items that will be returned.
     * - minOccurs: 0
     * @var \Structs\ItemListCustomizationType
     */
    public $WatchList;
    /**
     * The BidList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>BidList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid. <br><br> The user also has the option of using pagination and sorting for the
     * list of auction items that will be returned.
     * - minOccurs: 0
     * @var \Structs\ItemListCustomizationType
     */
    public $BidList;
    /**
     * The BestOfferList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>BestOfferList.Include</b> field to <code>true</code> to return the list of items on which the eBay user has made a Best Offer. <br><br> The user also has the option of using pagination and
     * sorting for the list of items that will be returned.
     * - minOccurs: 0
     * @var \Structs\ItemListCustomizationType
     */
    public $BestOfferList;
    /**
     * The WonList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>WonList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid on and won. <br><br> The user also has the option of using pagination and sorting
     * for the list of auction items that will be returned.
     * - minOccurs: 0
     * @var \Structs\ItemListCustomizationType
     */
    public $WonList;
    /**
     * The LostList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>LostList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid on and lost. <br><br> The user also has the option of using pagination and
     * sorting for the list of auction items that will be returned.
     * - minOccurs: 0
     * @var \Structs\ItemListCustomizationType
     */
    public $LostList;
    /**
     * The FavoriteSearches
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>FavoriteSearches.Include</b> field to <code>true</code> to return the list of the eBay user's saved searches.
     * - minOccurs: 0
     * @var \Structs\MyeBaySelectionType
     */
    public $FavoriteSearches;
    /**
     * The FavoriteSellers
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>FavoriteSellers.Include</b> field to <code>true</code> to return the list of the eBay user's saved sellers.
     * - minOccurs: 0
     * @var \Structs\MyeBaySelectionType
     */
    public $FavoriteSellers;
    /**
     * The SecondChanceOffer
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>SecondChanceOffer.Include</b> field to <code>true</code> to return any Second Chance Offers that the eBay user has received.
     * - minOccurs: 0
     * @var \Structs\MyeBaySelectionType
     */
    public $SecondChanceOffer;
    /**
     * The BidAssistantList
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \Structs\BidAssistantListType
     */
    public $BidAssistantList;
    /**
     * The DeletedFromWonList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>DeletedFromWonList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid on and won, but has deleted from their My eBay page. <br><br> The user
     * also has the option of using pagination and sorting for the list of auction items that will be returned.
     * - minOccurs: 0
     * @var \Structs\ItemListCustomizationType
     */
    public $DeletedFromWonList;
    /**
     * The DeletedFromLostList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>DeletedFromLostList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid on and lost, and has deleted from their My eBay page. <br><br> The
     * user also has the option of using pagination and sorting for the list of auction items that will be returned.
     * - minOccurs: 0
     * @var \Structs\ItemListCustomizationType
     */
    public $DeletedFromLostList;
    /**
     * The BuyingSummary
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>BuyingSummary.Include</b> field to <code>true</code> to return the <b>BuyingSummary</b> container in the response. The <b>BuyingSummary</b> container consists of buying/bidding activity counts
     * and values.
     * - minOccurs: 0
     * @var \Structs\ItemListCustomizationType
     */
    public $BuyingSummary;
    /**
     * The UserDefinedLists
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>UserDefinedLists.Include</b> field to <code>true</code> to return one or more user-defined lists. User-defined lists are lists created by the user in My eBay and consists of a combination of
     * items, saved sellers, and/or saved searches.
     * - minOccurs: 0
     * @var \Structs\MyeBaySelectionType
     */
    public $UserDefinedLists;
    /**
     * The HideVariations
     * Meta information extracted from the WSDL
     * - documentation: If this field is included and set to <code>true</code>, the <b>Variations</b> node (and all variation data) is omitted for all multiple-variation listings in the response. If this field is omitted or set to <code>false</code>, the
     * <b>Variations</b> node is returned for all multiple-variation listings in the response. <br>
     * - minOccurs: 0
     * @var bool
     */
    public $HideVariations;
    /**
     * Constructor method for GetMyeBayBuyingRequestType
     * @uses GetMyeBayBuyingRequestType::setWatchList()
     * @uses GetMyeBayBuyingRequestType::setBidList()
     * @uses GetMyeBayBuyingRequestType::setBestOfferList()
     * @uses GetMyeBayBuyingRequestType::setWonList()
     * @uses GetMyeBayBuyingRequestType::setLostList()
     * @uses GetMyeBayBuyingRequestType::setFavoriteSearches()
     * @uses GetMyeBayBuyingRequestType::setFavoriteSellers()
     * @uses GetMyeBayBuyingRequestType::setSecondChanceOffer()
     * @uses GetMyeBayBuyingRequestType::setBidAssistantList()
     * @uses GetMyeBayBuyingRequestType::setDeletedFromWonList()
     * @uses GetMyeBayBuyingRequestType::setDeletedFromLostList()
     * @uses GetMyeBayBuyingRequestType::setBuyingSummary()
     * @uses GetMyeBayBuyingRequestType::setUserDefinedLists()
     * @uses GetMyeBayBuyingRequestType::setHideVariations()
     * @param \Structs\ItemListCustomizationType $watchList
     * @param \Structs\ItemListCustomizationType $bidList
     * @param \Structs\ItemListCustomizationType $bestOfferList
     * @param \Structs\ItemListCustomizationType $wonList
     * @param \Structs\ItemListCustomizationType $lostList
     * @param \Structs\MyeBaySelectionType $favoriteSearches
     * @param \Structs\MyeBaySelectionType $favoriteSellers
     * @param \Structs\MyeBaySelectionType $secondChanceOffer
     * @param \Structs\BidAssistantListType $bidAssistantList
     * @param \Structs\ItemListCustomizationType $deletedFromWonList
     * @param \Structs\ItemListCustomizationType $deletedFromLostList
     * @param \Structs\ItemListCustomizationType $buyingSummary
     * @param \Structs\MyeBaySelectionType $userDefinedLists
     * @param bool $hideVariations
     */
    public function __construct(\Structs\ItemListCustomizationType $watchList = null, \Structs\ItemListCustomizationType $bidList = null, \Structs\ItemListCustomizationType $bestOfferList = null, \Structs\ItemListCustomizationType $wonList = null, \Structs\ItemListCustomizationType $lostList = null, \Structs\MyeBaySelectionType $favoriteSearches = null, \Structs\MyeBaySelectionType $favoriteSellers = null, \Structs\MyeBaySelectionType $secondChanceOffer = null, \Structs\BidAssistantListType $bidAssistantList = null, \Structs\ItemListCustomizationType $deletedFromWonList = null, \Structs\ItemListCustomizationType $deletedFromLostList = null, \Structs\ItemListCustomizationType $buyingSummary = null, \Structs\MyeBaySelectionType $userDefinedLists = null, $hideVariations = null)
    {
        $this
            ->setWatchList($watchList)
            ->setBidList($bidList)
            ->setBestOfferList($bestOfferList)
            ->setWonList($wonList)
            ->setLostList($lostList)
            ->setFavoriteSearches($favoriteSearches)
            ->setFavoriteSellers($favoriteSellers)
            ->setSecondChanceOffer($secondChanceOffer)
            ->setBidAssistantList($bidAssistantList)
            ->setDeletedFromWonList($deletedFromWonList)
            ->setDeletedFromLostList($deletedFromLostList)
            ->setBuyingSummary($buyingSummary)
            ->setUserDefinedLists($userDefinedLists)
            ->setHideVariations($hideVariations);
    }
    /**
     * Get WatchList value
     * @return \Structs\ItemListCustomizationType|null
     */
    public function getWatchList()
    {
        return $this->WatchList;
    }
    /**
     * Set WatchList value
     * @param \Structs\ItemListCustomizationType $watchList
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setWatchList(\Structs\ItemListCustomizationType $watchList = null)
    {
        $this->WatchList = $watchList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \Structs\ItemListCustomizationType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \Structs\ItemListCustomizationType $bidList
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setBidList(\Structs\ItemListCustomizationType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get BestOfferList value
     * @return \Structs\ItemListCustomizationType|null
     */
    public function getBestOfferList()
    {
        return $this->BestOfferList;
    }
    /**
     * Set BestOfferList value
     * @param \Structs\ItemListCustomizationType $bestOfferList
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setBestOfferList(\Structs\ItemListCustomizationType $bestOfferList = null)
    {
        $this->BestOfferList = $bestOfferList;
        return $this;
    }
    /**
     * Get WonList value
     * @return \Structs\ItemListCustomizationType|null
     */
    public function getWonList()
    {
        return $this->WonList;
    }
    /**
     * Set WonList value
     * @param \Structs\ItemListCustomizationType $wonList
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setWonList(\Structs\ItemListCustomizationType $wonList = null)
    {
        $this->WonList = $wonList;
        return $this;
    }
    /**
     * Get LostList value
     * @return \Structs\ItemListCustomizationType|null
     */
    public function getLostList()
    {
        return $this->LostList;
    }
    /**
     * Set LostList value
     * @param \Structs\ItemListCustomizationType $lostList
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setLostList(\Structs\ItemListCustomizationType $lostList = null)
    {
        $this->LostList = $lostList;
        return $this;
    }
    /**
     * Get FavoriteSearches value
     * @return \Structs\MyeBaySelectionType|null
     */
    public function getFavoriteSearches()
    {
        return $this->FavoriteSearches;
    }
    /**
     * Set FavoriteSearches value
     * @param \Structs\MyeBaySelectionType $favoriteSearches
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setFavoriteSearches(\Structs\MyeBaySelectionType $favoriteSearches = null)
    {
        $this->FavoriteSearches = $favoriteSearches;
        return $this;
    }
    /**
     * Get FavoriteSellers value
     * @return \Structs\MyeBaySelectionType|null
     */
    public function getFavoriteSellers()
    {
        return $this->FavoriteSellers;
    }
    /**
     * Set FavoriteSellers value
     * @param \Structs\MyeBaySelectionType $favoriteSellers
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setFavoriteSellers(\Structs\MyeBaySelectionType $favoriteSellers = null)
    {
        $this->FavoriteSellers = $favoriteSellers;
        return $this;
    }
    /**
     * Get SecondChanceOffer value
     * @return \Structs\MyeBaySelectionType|null
     */
    public function getSecondChanceOffer()
    {
        return $this->SecondChanceOffer;
    }
    /**
     * Set SecondChanceOffer value
     * @param \Structs\MyeBaySelectionType $secondChanceOffer
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setSecondChanceOffer(\Structs\MyeBaySelectionType $secondChanceOffer = null)
    {
        $this->SecondChanceOffer = $secondChanceOffer;
        return $this;
    }
    /**
     * Get BidAssistantList value
     * @return \Structs\BidAssistantListType|null
     */
    public function getBidAssistantList()
    {
        return $this->BidAssistantList;
    }
    /**
     * Set BidAssistantList value
     * @param \Structs\BidAssistantListType $bidAssistantList
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setBidAssistantList(\Structs\BidAssistantListType $bidAssistantList = null)
    {
        $this->BidAssistantList = $bidAssistantList;
        return $this;
    }
    /**
     * Get DeletedFromWonList value
     * @return \Structs\ItemListCustomizationType|null
     */
    public function getDeletedFromWonList()
    {
        return $this->DeletedFromWonList;
    }
    /**
     * Set DeletedFromWonList value
     * @param \Structs\ItemListCustomizationType $deletedFromWonList
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setDeletedFromWonList(\Structs\ItemListCustomizationType $deletedFromWonList = null)
    {
        $this->DeletedFromWonList = $deletedFromWonList;
        return $this;
    }
    /**
     * Get DeletedFromLostList value
     * @return \Structs\ItemListCustomizationType|null
     */
    public function getDeletedFromLostList()
    {
        return $this->DeletedFromLostList;
    }
    /**
     * Set DeletedFromLostList value
     * @param \Structs\ItemListCustomizationType $deletedFromLostList
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setDeletedFromLostList(\Structs\ItemListCustomizationType $deletedFromLostList = null)
    {
        $this->DeletedFromLostList = $deletedFromLostList;
        return $this;
    }
    /**
     * Get BuyingSummary value
     * @return \Structs\ItemListCustomizationType|null
     */
    public function getBuyingSummary()
    {
        return $this->BuyingSummary;
    }
    /**
     * Set BuyingSummary value
     * @param \Structs\ItemListCustomizationType $buyingSummary
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setBuyingSummary(\Structs\ItemListCustomizationType $buyingSummary = null)
    {
        $this->BuyingSummary = $buyingSummary;
        return $this;
    }
    /**
     * Get UserDefinedLists value
     * @return \Structs\MyeBaySelectionType|null
     */
    public function getUserDefinedLists()
    {
        return $this->UserDefinedLists;
    }
    /**
     * Set UserDefinedLists value
     * @param \Structs\MyeBaySelectionType $userDefinedLists
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setUserDefinedLists(\Structs\MyeBaySelectionType $userDefinedLists = null)
    {
        $this->UserDefinedLists = $userDefinedLists;
        return $this;
    }
    /**
     * Get HideVariations value
     * @return bool|null
     */
    public function getHideVariations()
    {
        return $this->HideVariations;
    }
    /**
     * Set HideVariations value
     * @param bool $hideVariations
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public function setHideVariations($hideVariations = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideVariations) && !is_bool($hideVariations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideVariations, true), gettype($hideVariations)), __LINE__);
        }
        $this->HideVariations = $hideVariations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Structs\GetMyeBayBuyingRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
