<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteSellingManagerTemplateAutomationRuleResponseType
 * Structs
 * Meta information extracted from the WSDL
 * - documentation: Contains the set of automation rules associated with the specified template.
 * @subpackage Structs
 */
class DeleteSellingManagerTemplateAutomationRuleResponseType extends AbstractResponseType
{
    /**
     * The AutomatedListingRule
     * Meta information extracted from the WSDL
     * - documentation: This container is returned if automated listing rules are set up for the Selling Manager template.
     * - minOccurs: 0
     * @var \Structs\SellingManagerAutoListType
     */
    public $AutomatedListingRule;
    /**
     * The AutomatedRelistingRule
     * Meta information extracted from the WSDL
     * - documentation: This container is returned if automated relisting rules are set up for the Selling Manager template.
     * - minOccurs: 0
     * @var \Structs\SellingManagerAutoRelistType
     */
    public $AutomatedRelistingRule;
    /**
     * The AutomatedSecondChanceOfferRule
     * Meta information extracted from the WSDL
     * - documentation: This container is returned if automated Second Chance Offer rules are set up for the Selling Manager template.
     * - minOccurs: 0
     * @var \Structs\SellingManagerAutoSecondChanceOfferType
     */
    public $AutomatedSecondChanceOfferRule;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Contains fees that may be incurred when items are listed using the automation rules (e.g., a scheduled listing fee). Use of an automation rule does not in itself have a fee, but use can result in a fee.
     * - minOccurs: 0
     * @var \Structs\FeesType
     */
    public $Fees;
    /**
     * Constructor method for DeleteSellingManagerTemplateAutomationRuleResponseType
     * @uses DeleteSellingManagerTemplateAutomationRuleResponseType::setAutomatedListingRule()
     * @uses DeleteSellingManagerTemplateAutomationRuleResponseType::setAutomatedRelistingRule()
     * @uses DeleteSellingManagerTemplateAutomationRuleResponseType::setAutomatedSecondChanceOfferRule()
     * @uses DeleteSellingManagerTemplateAutomationRuleResponseType::setFees()
     * @param \Structs\SellingManagerAutoListType $automatedListingRule
     * @param \Structs\SellingManagerAutoRelistType $automatedRelistingRule
     * @param \Structs\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @param \Structs\FeesType $fees
     */
    public function __construct(\Structs\SellingManagerAutoListType $automatedListingRule = null, \Structs\SellingManagerAutoRelistType $automatedRelistingRule = null, \Structs\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null, \Structs\FeesType $fees = null)
    {
        $this
            ->setAutomatedListingRule($automatedListingRule)
            ->setAutomatedRelistingRule($automatedRelistingRule)
            ->setAutomatedSecondChanceOfferRule($automatedSecondChanceOfferRule)
            ->setFees($fees);
    }
    /**
     * Get AutomatedListingRule value
     * @return \Structs\SellingManagerAutoListType|null
     */
    public function getAutomatedListingRule()
    {
        return $this->AutomatedListingRule;
    }
    /**
     * Set AutomatedListingRule value
     * @param \Structs\SellingManagerAutoListType $automatedListingRule
     * @return \Structs\DeleteSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedListingRule(\Structs\SellingManagerAutoListType $automatedListingRule = null)
    {
        $this->AutomatedListingRule = $automatedListingRule;
        return $this;
    }
    /**
     * Get AutomatedRelistingRule value
     * @return \Structs\SellingManagerAutoRelistType|null
     */
    public function getAutomatedRelistingRule()
    {
        return $this->AutomatedRelistingRule;
    }
    /**
     * Set AutomatedRelistingRule value
     * @param \Structs\SellingManagerAutoRelistType $automatedRelistingRule
     * @return \Structs\DeleteSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedRelistingRule(\Structs\SellingManagerAutoRelistType $automatedRelistingRule = null)
    {
        $this->AutomatedRelistingRule = $automatedRelistingRule;
        return $this;
    }
    /**
     * Get AutomatedSecondChanceOfferRule value
     * @return \Structs\SellingManagerAutoSecondChanceOfferType|null
     */
    public function getAutomatedSecondChanceOfferRule()
    {
        return $this->AutomatedSecondChanceOfferRule;
    }
    /**
     * Set AutomatedSecondChanceOfferRule value
     * @param \Structs\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @return \Structs\DeleteSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedSecondChanceOfferRule(\Structs\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null)
    {
        $this->AutomatedSecondChanceOfferRule = $automatedSecondChanceOfferRule;
        return $this;
    }
    /**
     * Get Fees value
     * @return \Structs\FeesType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \Structs\FeesType $fees
     * @return \Structs\DeleteSellingManagerTemplateAutomationRuleResponseType
     */
    public function setFees(\Structs\FeesType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Structs\DeleteSellingManagerTemplateAutomationRuleResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
