<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddItemsRequestType Structs
 * Meta information extracted from the WSDL
 * - documentation: Defines from one to five items and lists them on a specified eBay site.
 * @subpackage Structs
 */
class AddItemsRequestType extends AbstractRequestType
{
    /**
     * The AddItemRequestContainer
     * Meta information extracted from the WSDL
     * - documentation: Defines a single item to be listed on eBay. This container is similar to an <b>AddItem</b> request. Up to five of these containers can be included in one <b>AddItems</b> request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Structs\AddItemRequestContainerType[]
     */
    public $AddItemRequestContainer;
    /**
     * Constructor method for AddItemsRequestType
     * @uses AddItemsRequestType::setAddItemRequestContainer()
     * @param \Structs\AddItemRequestContainerType[] $addItemRequestContainer
     */
    public function __construct(array $addItemRequestContainer = array())
    {
        $this
            ->setAddItemRequestContainer($addItemRequestContainer);
    }
    /**
     * Get AddItemRequestContainer value
     * @return \Structs\AddItemRequestContainerType[]|null
     */
    public function getAddItemRequestContainer()
    {
        return $this->AddItemRequestContainer;
    }
    /**
     * This method is responsible for validating the values passed to the setAddItemRequestContainer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddItemRequestContainer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddItemRequestContainerForArrayConstraintsFromSetAddItemRequestContainer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addItemsRequestTypeAddItemRequestContainerItem) {
            // validation for constraint: itemType
            if (!$addItemsRequestTypeAddItemRequestContainerItem instanceof \Structs\AddItemRequestContainerType) {
                $invalidValues[] = is_object($addItemsRequestTypeAddItemRequestContainerItem) ? get_class($addItemsRequestTypeAddItemRequestContainerItem) : sprintf('%s(%s)', gettype($addItemsRequestTypeAddItemRequestContainerItem), var_export($addItemsRequestTypeAddItemRequestContainerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddItemRequestContainer property can only contain items of type \Structs\AddItemRequestContainerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddItemRequestContainer value
     * @throws \InvalidArgumentException
     * @param \Structs\AddItemRequestContainerType[] $addItemRequestContainer
     * @return \Structs\AddItemsRequestType
     */
    public function setAddItemRequestContainer(array $addItemRequestContainer = array())
    {
        // validation for constraint: array
        if ('' !== ($addItemRequestContainerArrayErrorMessage = self::validateAddItemRequestContainerForArrayConstraintsFromSetAddItemRequestContainer($addItemRequestContainer))) {
            throw new \InvalidArgumentException($addItemRequestContainerArrayErrorMessage, __LINE__);
        }
        $this->AddItemRequestContainer = $addItemRequestContainer;
        return $this;
    }
    /**
     * Add item to AddItemRequestContainer value
     * @throws \InvalidArgumentException
     * @param \Structs\AddItemRequestContainerType $item
     * @return \Structs\AddItemsRequestType
     */
    public function addToAddItemRequestContainer(\Structs\AddItemRequestContainerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Structs\AddItemRequestContainerType) {
            throw new \InvalidArgumentException(sprintf('The AddItemRequestContainer property can only contain items of type \Structs\AddItemRequestContainerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddItemRequestContainer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Structs\AddItemsRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
