<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getQuote StructType
 * @subpackage Structs
 */
class GetQuote extends AbstractStructBase
{
    /**
     * The ticker
     * @var string
     */
    public $ticker;
    /**
     * Constructor method for getQuote
     * @uses GetQuote::setTicker()
     * @param string $ticker
     */
    public function __construct($ticker = null)
    {
        $this
            ->setTicker($ticker);
    }
    /**
     * Get ticker value
     * @return string|null
     */
    public function getTicker()
    {
        return $this->ticker;
    }
    /**
     * Set ticker value
     * @param string $ticker
     * @return \StructType\GetQuote
     */
    public function setTicker($ticker = null)
    {
        // validation for constraint: string
        if (!is_null($ticker) && !is_string($ticker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticker, true), gettype($ticker)), __LINE__);
        }
        $this->ticker = $ticker;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQuote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
