<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInvoiceHeader StructType
 * @subpackage Structs
 */
class UpdateInvoiceHeader extends AbstractStructBase
{
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Inv
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Invoice
     */
    public $Inv;
    /**
     * Constructor method for UpdateInvoiceHeader
     * @uses UpdateInvoiceHeader::setUserName()
     * @uses UpdateInvoiceHeader::setPassword()
     * @uses UpdateInvoiceHeader::setInv()
     * @param string $userName
     * @param string $password
     * @param \StructType\Invoice $inv
     */
    public function __construct($userName = null, $password = null, \StructType\Invoice $inv = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setInv($inv);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\UpdateInvoiceHeader
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\UpdateInvoiceHeader
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Inv value
     * @return \StructType\Invoice|null
     */
    public function getInv()
    {
        return $this->Inv;
    }
    /**
     * Set Inv value
     * @param \StructType\Invoice $inv
     * @return \StructType\UpdateInvoiceHeader
     */
    public function setInv(\StructType\Invoice $inv = null)
    {
        $this->Inv = $inv;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateInvoiceHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
