<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionInformation StructType
 * @subpackage Structs
 */
class TransactionInformation extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The nomid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nomid;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Value;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Type;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $id;
    /**
     * The id2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $id2;
    /**
     * The id3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $id3;
    /**
     * The ProjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProjId;
    /**
     * The Ref1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ref1;
    /**
     * The Ref2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ref2;
    /**
     * The Ref3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ref3;
    /**
     * The Narrative
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Narrative;
    /**
     * Constructor method for TransactionInformation
     * @uses TransactionInformation::setDate()
     * @uses TransactionInformation::setNomid()
     * @uses TransactionInformation::setValue()
     * @uses TransactionInformation::setType()
     * @uses TransactionInformation::setId()
     * @uses TransactionInformation::setId2()
     * @uses TransactionInformation::setId3()
     * @uses TransactionInformation::setProjId()
     * @uses TransactionInformation::setRef1()
     * @uses TransactionInformation::setRef2()
     * @uses TransactionInformation::setRef3()
     * @uses TransactionInformation::setNarrative()
     * @param string $date
     * @param int $nomid
     * @param float $value
     * @param int $type
     * @param int $id
     * @param int $id2
     * @param int $id3
     * @param int $projId
     * @param string $ref1
     * @param string $ref2
     * @param string $ref3
     * @param string $narrative
     */
    public function __construct($date = null, $nomid = null, $value = null, $type = null, $id = null, $id2 = null, $id3 = null, $projId = null, $ref1 = null, $ref2 = null, $ref3 = null, $narrative = null)
    {
        $this
            ->setDate($date)
            ->setNomid($nomid)
            ->setValue($value)
            ->setType($type)
            ->setId($id)
            ->setId2($id2)
            ->setId3($id3)
            ->setProjId($projId)
            ->setRef1($ref1)
            ->setRef2($ref2)
            ->setRef3($ref3)
            ->setNarrative($narrative);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\TransactionInformation
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get nomid value
     * @return int
     */
    public function getNomid()
    {
        return $this->nomid;
    }
    /**
     * Set nomid value
     * @param int $nomid
     * @return \StructType\TransactionInformation
     */
    public function setNomid($nomid = null)
    {
        // validation for constraint: int
        if (!is_null($nomid) && !(is_int($nomid) || ctype_digit($nomid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nomid, true), gettype($nomid)), __LINE__);
        }
        $this->nomid = $nomid;
        return $this;
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\TransactionInformation
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Type value
     * @return int
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\TransactionInformation
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\TransactionInformation
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get id2 value
     * @return int
     */
    public function getId2()
    {
        return $this->id2;
    }
    /**
     * Set id2 value
     * @param int $id2
     * @return \StructType\TransactionInformation
     */
    public function setId2($id2 = null)
    {
        // validation for constraint: int
        if (!is_null($id2) && !(is_int($id2) || ctype_digit($id2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id2, true), gettype($id2)), __LINE__);
        }
        $this->id2 = $id2;
        return $this;
    }
    /**
     * Get id3 value
     * @return int
     */
    public function getId3()
    {
        return $this->id3;
    }
    /**
     * Set id3 value
     * @param int $id3
     * @return \StructType\TransactionInformation
     */
    public function setId3($id3 = null)
    {
        // validation for constraint: int
        if (!is_null($id3) && !(is_int($id3) || ctype_digit($id3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id3, true), gettype($id3)), __LINE__);
        }
        $this->id3 = $id3;
        return $this;
    }
    /**
     * Get ProjId value
     * @return int
     */
    public function getProjId()
    {
        return $this->ProjId;
    }
    /**
     * Set ProjId value
     * @param int $projId
     * @return \StructType\TransactionInformation
     */
    public function setProjId($projId = null)
    {
        // validation for constraint: int
        if (!is_null($projId) && !(is_int($projId) || ctype_digit($projId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($projId, true), gettype($projId)), __LINE__);
        }
        $this->ProjId = $projId;
        return $this;
    }
    /**
     * Get Ref1 value
     * @return string|null
     */
    public function getRef1()
    {
        return $this->Ref1;
    }
    /**
     * Set Ref1 value
     * @param string $ref1
     * @return \StructType\TransactionInformation
     */
    public function setRef1($ref1 = null)
    {
        // validation for constraint: string
        if (!is_null($ref1) && !is_string($ref1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref1, true), gettype($ref1)), __LINE__);
        }
        $this->Ref1 = $ref1;
        return $this;
    }
    /**
     * Get Ref2 value
     * @return string|null
     */
    public function getRef2()
    {
        return $this->Ref2;
    }
    /**
     * Set Ref2 value
     * @param string $ref2
     * @return \StructType\TransactionInformation
     */
    public function setRef2($ref2 = null)
    {
        // validation for constraint: string
        if (!is_null($ref2) && !is_string($ref2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref2, true), gettype($ref2)), __LINE__);
        }
        $this->Ref2 = $ref2;
        return $this;
    }
    /**
     * Get Ref3 value
     * @return string|null
     */
    public function getRef3()
    {
        return $this->Ref3;
    }
    /**
     * Set Ref3 value
     * @param string $ref3
     * @return \StructType\TransactionInformation
     */
    public function setRef3($ref3 = null)
    {
        // validation for constraint: string
        if (!is_null($ref3) && !is_string($ref3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref3, true), gettype($ref3)), __LINE__);
        }
        $this->Ref3 = $ref3;
        return $this;
    }
    /**
     * Get Narrative value
     * @return string|null
     */
    public function getNarrative()
    {
        return $this->Narrative;
    }
    /**
     * Set Narrative value
     * @param string $narrative
     * @return \StructType\TransactionInformation
     */
    public function setNarrative($narrative = null)
    {
        // validation for constraint: string
        if (!is_null($narrative) && !is_string($narrative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($narrative, true), gettype($narrative)), __LINE__);
        }
        $this->Narrative = $narrative;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
