<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptNotes StructType
 * @subpackage Structs
 */
class ReceiptNotes extends AbstractStructBase
{
    /**
     * The ReceiptId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptId;
    /**
     * The NoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoteId;
    /**
     * The NoteDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NoteDate;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for ReceiptNotes
     * @uses ReceiptNotes::setReceiptId()
     * @uses ReceiptNotes::setNoteId()
     * @uses ReceiptNotes::setNoteDate()
     * @uses ReceiptNotes::setNotes()
     * @param int $receiptId
     * @param int $noteId
     * @param string $noteDate
     * @param string $notes
     */
    public function __construct($receiptId = null, $noteId = null, $noteDate = null, $notes = null)
    {
        $this
            ->setReceiptId($receiptId)
            ->setNoteId($noteId)
            ->setNoteDate($noteDate)
            ->setNotes($notes);
    }
    /**
     * Get ReceiptId value
     * @return int
     */
    public function getReceiptId()
    {
        return $this->ReceiptId;
    }
    /**
     * Set ReceiptId value
     * @param int $receiptId
     * @return \StructType\ReceiptNotes
     */
    public function setReceiptId($receiptId = null)
    {
        // validation for constraint: int
        if (!is_null($receiptId) && !(is_int($receiptId) || ctype_digit($receiptId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptId, true), gettype($receiptId)), __LINE__);
        }
        $this->ReceiptId = $receiptId;
        return $this;
    }
    /**
     * Get NoteId value
     * @return int
     */
    public function getNoteId()
    {
        return $this->NoteId;
    }
    /**
     * Set NoteId value
     * @param int $noteId
     * @return \StructType\ReceiptNotes
     */
    public function setNoteId($noteId = null)
    {
        // validation for constraint: int
        if (!is_null($noteId) && !(is_int($noteId) || ctype_digit($noteId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($noteId, true), gettype($noteId)), __LINE__);
        }
        $this->NoteId = $noteId;
        return $this;
    }
    /**
     * Get NoteDate value
     * @return string
     */
    public function getNoteDate()
    {
        return $this->NoteDate;
    }
    /**
     * Set NoteDate value
     * @param string $noteDate
     * @return \StructType\ReceiptNotes
     */
    public function setNoteDate($noteDate = null)
    {
        // validation for constraint: string
        if (!is_null($noteDate) && !is_string($noteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteDate, true), gettype($noteDate)), __LINE__);
        }
        $this->NoteDate = $noteDate;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\ReceiptNotes
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReceiptNotes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
